/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.colorspace;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.colorspace.ColorSpaceConverter;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import org.apache.commons.io.IOUtils;

public class ColorSpaceComputeConverter
implements ColorSpaceConverter {
    private int width;
    private int height;
    private ColorSpace colorSpace;
    private ComputeProgram program;
    private int target;

    public ColorSpaceComputeConverter(int n, int n2, ColorSpace colorSpace) {
        this.rebuildProgram(n, n2, colorSpace);
    }

    @Override
    public void rebuildProgram(int n, int n2, ColorSpace colorSpace) {
        String string;
        if (this.program != null) {
            this.program.destroy();
            this.program = null;
        }
        this.width = n;
        this.height = n2;
        this.colorSpace = colorSpace;
        try {
            string = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/colorSpace.csh"))), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ArrayList<StringPair> arrayList = new ArrayList<StringPair>();
        arrayList.add(new StringPair("COMPUTE", ""));
        arrayList.add(new StringPair("CURRENT_COLOR_SPACE", String.valueOf(colorSpace.ordinal())));
        for (ColorSpace colorSpace2 : ColorSpace.values()) {
            arrayList.add(new StringPair(colorSpace2.name(), String.valueOf(colorSpace2.ordinal())));
        }
        string = JcppProcessor.glslPreprocessSource(string, arrayList);
        ProgramBuilder programBuilder = ProgramBuilder.beginCompute("colorSpaceCompute", string, (ImmutableSet<Integer>)ImmutableSet.of());
        programBuilder.addTextureImage(() -> this.target, InternalTextureFormat.RGBA8, "readImage");
        this.program = programBuilder.buildCompute();
    }

    @Override
    public void process(int n) {
        if (this.colorSpace == ColorSpace.SRGB) {
            return;
        }
        this.target = n;
        this.program.use();
        IrisRenderSystem.dispatchCompute(this.width / 8, this.height / 8, 1);
        IrisRenderSystem.memoryBarrier(40);
        ComputeProgram.unbind();
    }
}

