/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.BooleanStateExtended;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.minecraft.class_8251;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3i;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.EXTShaderImageLoadStore;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL45C;

public class IrisRenderSystem {
    private static Matrix4f backupProjection;
    private static DSAAccess dsaState;
    private static boolean hasMultibind;
    private static boolean supportsCompute;
    private static int[] samplers;
    private static int[] emptyArray;

    public static void initRenderer() {
        if (GL.getCapabilities().OpenGL45) {
            dsaState = new DSACore();
            Iris.logger.info("OpenGL 4.5 detected, enabling DSA.");
        } else if (GL.getCapabilities().GL_ARB_direct_state_access) {
            dsaState = new DSAARB();
            Iris.logger.info("ARB_direct_state_access detected, enabling DSA.");
        } else {
            dsaState = new DSAUnsupported();
            Iris.logger.info("DSA support not detected.");
        }
        hasMultibind = GL.getCapabilities().OpenGL45 || GL.getCapabilities().GL_ARB_multi_bind;
        supportsCompute = GL.getCapabilities().glDispatchCompute != 0L;
        samplers = new int[SamplerLimits.get().getMaxTextureUnits()];
    }

    public static void getIntegerv(int n, int[] nArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glGetIntegerv((int)n, (int[])nArray);
    }

    public static void getFloatv(int n, float[] fArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glGetFloatv((int)n, (float[])fArray);
    }

    public static void generateMipmaps(int n, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.generateMipmaps(n, n2);
    }

    public static void bindAttributeLocation(int n, int n2, CharSequence charSequence) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glBindAttribLocation((int)n, (int)n2, (CharSequence)charSequence);
    }

    public static void texImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, @Nullable ByteBuffer byteBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        IrisRenderSystem.bindTextureForSetup(n2, n);
        GL30C.glTexImage1D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (ByteBuffer)byteBuffer);
    }

    public static void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, @Nullable ByteBuffer byteBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        IrisRenderSystem.bindTextureForSetup(n2, n);
        GL32C.glTexImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (ByteBuffer)byteBuffer);
    }

    public static void texImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, @Nullable ByteBuffer byteBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        IrisRenderSystem.bindTextureForSetup(n2, n);
        GL30C.glTexImage3D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (ByteBuffer)byteBuffer);
    }

    public static void uniformMatrix4fv(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniformMatrix4fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public static void copyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glCopyTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    public static void uniform1f(int n, float f) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform1f((int)n, (float)f);
    }

    public static void uniform2f(int n, float f, float f2) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform2f((int)n, (float)f, (float)f2);
    }

    public static void uniform2i(int n, int n2, int n3) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform2i((int)n, (int)n2, (int)n3);
    }

    public static void uniform3f(int n, float f, float f2, float f3) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform3f((int)n, (float)f, (float)f2, (float)f3);
    }

    public static void uniform4f(int n, float f, float f2, float f3, float f4) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public static void uniform4i(int n, int n2, int n3, int n4, int n5) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniform4i((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void texParameteriv(int n, int n2, int n3, int[] nArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.texParameteriv(n, n2, n3, nArray);
    }

    public static void texParameterivDirect(int n, int n2, int[] nArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glTexParameteriv((int)n, (int)n2, (int[])nArray);
    }

    public static void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        dsaState.copyTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static void texParameteri(int n, int n2, int n3, int n4) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.texParameteri(n, n2, n3, n4);
    }

    public static void texParameterf(int n, int n2, int n3, float f) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.texParameterf(n, n2, n3, f);
    }

    public static String getProgramInfoLog(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL32C.glGetProgramInfoLog((int)n);
    }

    public static String getShaderInfoLog(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL32C.glGetShaderInfoLog((int)n);
    }

    public static void drawBuffers(int n, int[] nArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.drawBuffers(n, nArray);
    }

    public static void readBuffer(int n, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        dsaState.readBuffer(n, n2);
    }

    public static String getActiveUniform(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL32C.glGetActiveUniform((int)n, (int)n2, (int)n3, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (float[])fArray);
    }

    public static void bufferData(int n, float[] fArray, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glBufferData((int)n, (float[])fArray, (int)n2);
    }

    public static int bufferStorage(int n, float[] fArray, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        return dsaState.bufferStorage(n, fArray, n2);
    }

    public static void bufferStorage(int n, long l, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL45C.glBufferStorage((int)n, (long)l, (int)n2);
    }

    public static void bindBufferBase(int n, Integer n2, int n3) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL43C.glBindBufferBase((int)n, (int)n2, (int)n3);
    }

    public static void vertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glVertexAttrib4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public static void detachShader(int n, int n2) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glDetachShader((int)n, (int)n2);
    }

    public static void framebufferTexture2D(int n, int n2, int n3, int n4, int n5, int n6) {
        dsaState.framebufferTexture2D(n, n2, n3, n4, n5, n6);
    }

    public static int getTexParameteri(int n, int n2, int n3) {
        RenderSystem.assertOnRenderThreadOrInit();
        return dsaState.getTexParameteri(n, n2, n3);
    }

    public static void bindImageTexture(int n, int n2, int n3, boolean bl, int n4, int n5, int n6) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (GL.getCapabilities().OpenGL42 || GL.getCapabilities().GL_ARB_shader_image_load_store) {
            GL42C.glBindImageTexture((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (int)n5, (int)n6);
        } else {
            EXTShaderImageLoadStore.glBindImageTextureEXT((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (int)n5, (int)n6);
        }
    }

    public static int getMaxImageUnits() {
        if (GL.getCapabilities().OpenGL42 || GL.getCapabilities().GL_ARB_shader_image_load_store) {
            return GlStateManager._getInteger((int)36664);
        }
        if (GL.getCapabilities().GL_EXT_shader_image_load_store) {
            return GlStateManager._getInteger((int)36664);
        }
        return 0;
    }

    public static boolean supportsSSBO() {
        return GL.getCapabilities().OpenGL44 || GL.getCapabilities().GL_ARB_shader_storage_buffer_object && GL.getCapabilities().GL_ARB_buffer_storage;
    }

    public static boolean supportsImageLoadStore() {
        return GL.getCapabilities().glBindImageTexture != 0L || GL.getCapabilities().OpenGL42 || (GL.getCapabilities().GL_ARB_shader_image_load_store || GL.getCapabilities().GL_EXT_shader_image_load_store) && GL.getCapabilities().GL_ARB_buffer_storage;
    }

    public static void genBuffers(int[] nArray) {
        GL43C.glGenBuffers((int[])nArray);
    }

    public static void clearBufferSubData(int n, int n2, long l, long l2, int n3, int n4, int[] nArray) {
        GL43C.glClearBufferSubData((int)n, (int)n2, (long)l, (long)l2, (int)n3, (int)n4, (int[])nArray);
    }

    public static void getProgramiv(int n, int n2, int[] nArray) {
        GL32C.glGetProgramiv((int)n, (int)n2, (int[])nArray);
    }

    public static void dispatchCompute(int n, int n2, int n3) {
        GL45C.glDispatchCompute((int)n, (int)n2, (int)n3);
    }

    public static void dispatchCompute(Vector3i vector3i) {
        GL45C.glDispatchCompute((int)vector3i.x, (int)vector3i.y, (int)vector3i.z);
    }

    public static void memoryBarrier(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (supportsCompute) {
            GL45C.glMemoryBarrier((int)n);
        }
    }

    public static boolean supportsBufferBlending() {
        return GL.getCapabilities().GL_ARB_draw_buffers_blend || GL.getCapabilities().OpenGL40;
    }

    public static void disableBufferBlend(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glDisablei((int)3042, (int)n);
        ((BooleanStateExtended)GlStateManagerAccessor.getBLEND().field_5045).setUnknownState();
    }

    public static void enableBufferBlend(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glEnablei((int)3042, (int)n);
        ((BooleanStateExtended)GlStateManagerAccessor.getBLEND().field_5045).setUnknownState();
    }

    public static void blendFuncSeparatei(int n, int n2, int n3, int n4, int n5) {
        RenderSystem.assertOnRenderThreadOrInit();
        ARBDrawBuffersBlend.glBlendFuncSeparateiARB((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void bindTextureToUnit(int n, int n2, int n3) {
        dsaState.bindTextureToUnit(n, n2, n3);
    }

    public static int getUniformBlockIndex(int n, String string) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL32C.glGetUniformBlockIndex((int)n, (CharSequence)string);
    }

    public static void uniformBlockBinding(int n, int n2, int n3) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL32C.glUniformBlockBinding((int)n, (int)n2, (int)n3);
    }

    public static void setShadowProjection(Matrix4f matrix4f) {
        backupProjection = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
    }

    public static void restorePlayerProjection() {
        RenderSystem.setProjectionMatrix((Matrix4f)backupProjection, (class_8251)class_8251.field_43360);
        backupProjection = null;
    }

    public static void blitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        dsaState.blitFramebuffer(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12);
    }

    public static int createFramebuffer() {
        return dsaState.createFramebuffer();
    }

    public static int createTexture(int n) {
        return dsaState.createTexture(n);
    }

    public static void bindTextureForSetup(int n, int n2) {
        GL30C.glBindTexture((int)n, (int)n2);
    }

    public static boolean supportsCompute() {
        return supportsCompute;
    }

    public static int genSampler() {
        return GL33C.glGenSamplers();
    }

    public static void destroySampler(int n) {
        GL33C.glDeleteSamplers((int)n);
    }

    public static void bindSamplerToUnit(int n, int n2) {
        if (samplers[n] == n2) {
            return;
        }
        GL33C.glBindSampler((int)n, (int)n2);
        IrisRenderSystem.samplers[n] = n2;
    }

    public static void unbindAllSamplers() {
        boolean bl = false;
        for (int i = 0; i < samplers.length; ++i) {
            if (samplers[i] == 0) continue;
            bl = true;
            if (!hasMultibind) {
                GL33C.glBindSampler((int)i, (int)0);
            }
            IrisRenderSystem.samplers[i] = 0;
        }
        if (bl && hasMultibind) {
            GL45C.glBindSamplers((int)0, (int[])emptyArray);
        }
    }

    public static void samplerParameteri(int n, int n2, int n3) {
        GL33C.glSamplerParameteri((int)n, (int)n2, (int)n3);
    }

    public static void samplerParameterf(int n, int n2, float f) {
        GL33C.glSamplerParameterf((int)n, (int)n2, (float)f);
    }

    public static void samplerParameteriv(int n, int n2, int[] nArray) {
        GL33C.glSamplerParameteriv((int)n, (int)n2, (int[])nArray);
    }

    public static long getVRAM() {
        if (GL.getCapabilities().GL_NVX_gpu_memory_info) {
            return (long)GL32C.glGetInteger((int)36937) * 1024L;
        }
        return 0x100000000L;
    }

    public static void deleteBuffers(int n) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL43C.glDeleteBuffers((int)n);
    }

    static {
        emptyArray = new int[SamplerLimits.get().getMaxTextureUnits()];
    }

    public static class DSACore
    extends DSAARB {
    }

    public static interface DSAAccess {
        public void generateMipmaps(int var1, int var2);

        public void texParameteri(int var1, int var2, int var3, int var4);

        public void texParameterf(int var1, int var2, int var3, float var4);

        public void texParameteriv(int var1, int var2, int var3, int[] var4);

        public void readBuffer(int var1, int var2);

        public void drawBuffers(int var1, int[] var2);

        public int getTexParameteri(int var1, int var2, int var3);

        public void copyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void bindTextureToUnit(int var1, int var2, int var3);

        public int bufferStorage(int var1, float[] var2, int var3);

        public void blitFramebuffer(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

        public void framebufferTexture2D(int var1, int var2, int var3, int var4, int var5, int var6);

        public int createFramebuffer();

        public int createTexture(int var1);
    }

    public static class DSAARB
    extends DSAUnsupported {
        @Override
        public void generateMipmaps(int n, int n2) {
            ARBDirectStateAccess.glGenerateTextureMipmap((int)n);
        }

        @Override
        public void texParameteri(int n, int n2, int n3, int n4) {
            ARBDirectStateAccess.glTextureParameteri((int)n, (int)n3, (int)n4);
        }

        @Override
        public void texParameterf(int n, int n2, int n3, float f) {
            ARBDirectStateAccess.glTextureParameterf((int)n, (int)n3, (float)f);
        }

        @Override
        public void texParameteriv(int n, int n2, int n3, int[] nArray) {
            ARBDirectStateAccess.glTextureParameteriv((int)n, (int)n3, (int[])nArray);
        }

        @Override
        public void readBuffer(int n, int n2) {
            ARBDirectStateAccess.glNamedFramebufferReadBuffer((int)n, (int)n2);
        }

        @Override
        public void drawBuffers(int n, int[] nArray) {
            ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)n, (int[])nArray);
        }

        @Override
        public int getTexParameteri(int n, int n2, int n3) {
            return ARBDirectStateAccess.glGetTextureParameteri((int)n, (int)n3);
        }

        @Override
        public void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            ARBDirectStateAccess.glCopyTextureSubImage2D((int)n, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9);
        }

        @Override
        public void bindTextureToUnit(int n, int n2, int n3) {
            if (GlStateManagerAccessor.getTEXTURES()[n2].field_5167 == n3) {
                return;
            }
            ARBDirectStateAccess.glBindTextureUnit((int)n2, (int)n3);
            GlStateManagerAccessor.getTEXTURES()[n2].field_5167 = n3;
        }

        @Override
        public int bufferStorage(int n, float[] fArray, int n2) {
            int n3 = GL45C.glCreateBuffers();
            GL45C.glNamedBufferData((int)n3, (float[])fArray, (int)n2);
            return n3;
        }

        @Override
        public void blitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)n11, (int)n12);
        }

        @Override
        public void framebufferTexture2D(int n, int n2, int n3, int n4, int n5, int n6) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)n, (int)n3, (int)n5, (int)n6);
        }

        @Override
        public int createFramebuffer() {
            return ARBDirectStateAccess.glCreateFramebuffers();
        }

        @Override
        public int createTexture(int n) {
            return ARBDirectStateAccess.glCreateTextures((int)n);
        }
    }

    public static class DSAUnsupported
    implements DSAAccess {
        @Override
        public void generateMipmaps(int n, int n2) {
            GlStateManager._bindTexture((int)n);
            GL32C.glGenerateMipmap((int)n2);
        }

        @Override
        public void texParameteri(int n, int n2, int n3, int n4) {
            IrisRenderSystem.bindTextureForSetup(n2, n);
            GL32C.glTexParameteri((int)n2, (int)n3, (int)n4);
        }

        @Override
        public void texParameterf(int n, int n2, int n3, float f) {
            IrisRenderSystem.bindTextureForSetup(n2, n);
            GL32C.glTexParameterf((int)n2, (int)n3, (float)f);
        }

        @Override
        public void texParameteriv(int n, int n2, int n3, int[] nArray) {
            IrisRenderSystem.bindTextureForSetup(n2, n);
            GL32C.glTexParameteriv((int)n2, (int)n3, (int[])nArray);
        }

        @Override
        public void readBuffer(int n, int n2) {
            GlStateManager._glBindFramebuffer((int)36160, (int)n);
            GL32C.glReadBuffer((int)n2);
        }

        @Override
        public void drawBuffers(int n, int[] nArray) {
            GlStateManager._glBindFramebuffer((int)36160, (int)n);
            GL32C.glDrawBuffers((int[])nArray);
        }

        @Override
        public int getTexParameteri(int n, int n2, int n3) {
            IrisRenderSystem.bindTextureForSetup(n2, n);
            return GL32C.glGetTexParameteri((int)n2, (int)n3);
        }

        @Override
        public void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            int n10 = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].field_5167;
            GlStateManager._bindTexture((int)n);
            GL32C.glCopyTexSubImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9);
            GlStateManager._bindTexture((int)n10);
        }

        @Override
        public void bindTextureToUnit(int n, int n2, int n3) {
            int n4 = GlStateManager._getActiveTexture();
            GlStateManager._activeTexture((int)(33984 + n2));
            IrisRenderSystem.bindTextureForSetup(n, n3);
            GlStateManager._activeTexture((int)n4);
        }

        @Override
        public int bufferStorage(int n, float[] fArray, int n2) {
            int n3 = GlStateManager._glGenBuffers();
            GlStateManager._glBindBuffer((int)n, (int)n3);
            IrisRenderSystem.bufferData(n, fArray, n2);
            GlStateManager._glBindBuffer((int)n, (int)0);
            return n3;
        }

        @Override
        public void blitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
            GlStateManager._glBindFramebuffer((int)36008, (int)n);
            GlStateManager._glBindFramebuffer((int)36009, (int)n2);
            GL32C.glBlitFramebuffer((int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)n11, (int)n12);
        }

        @Override
        public void framebufferTexture2D(int n, int n2, int n3, int n4, int n5, int n6) {
            GlStateManager._glBindFramebuffer((int)n2, (int)n);
            GL32C.glFramebufferTexture2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
        }

        @Override
        public int createFramebuffer() {
            int n = GlStateManager.glGenFramebuffers();
            GlStateManager._glBindFramebuffer((int)36160, (int)n);
            return n;
        }

        @Override
        public int createTexture(int n) {
            int n2 = GlStateManager._genTexture();
            GlStateManager._bindTexture((int)n2);
            return n2;
        }
    }
}

