/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageBuffer;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.sampler.SamplerLimits;

public class ShaderStorageBufferHolder {
    private int cachedWidth;
    private int cachedHeight;
    private ShaderStorageBuffer[] buffers;
    private boolean destroyed = false;

    public ShaderStorageBufferHolder(Int2ObjectArrayMap<ShaderStorageInfo> int2ObjectArrayMap, int n, int n2) {
        this.cachedWidth = n;
        this.cachedHeight = n2;
        this.buffers = new ShaderStorageBuffer[(Integer)Collections.max(int2ObjectArrayMap.keySet()) + 1];
        int2ObjectArrayMap.forEach((n3, shaderStorageInfo) -> {
            if ((long)shaderStorageInfo.size() > IrisRenderSystem.getVRAM()) {
                throw new OutOfVideoMemoryError("We only have " + ShaderStorageBufferHolder.toMib(IrisRenderSystem.getVRAM()) + "MiB of RAM to work with, but the pack is requesting " + shaderStorageInfo.size() + "! Can't continue.");
            }
            if (n3 > SamplerLimits.get().getMaxShaderStorageUnits()) {
                throw new IllegalStateException("We don't have enough SSBO units??? (index: " + n3 + ", max: " + SamplerLimits.get().getMaxShaderStorageUnits());
            }
            this.buffers[n3.intValue()] = new ShaderStorageBuffer((int)n3, (ShaderStorageInfo)shaderStorageInfo);
            int n4 = this.buffers[n3].getId();
            if (shaderStorageInfo.relative()) {
                this.buffers[n3].resizeIfRelative(n, n2);
            } else {
                GlStateManager._glBindBuffer((int)37074, (int)n4);
                IrisRenderSystem.bufferStorage(37074, shaderStorageInfo.size(), 0);
                IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, shaderStorageInfo.size(), 6403, 5120, new int[]{0});
                IrisRenderSystem.bindBufferBase(37074, n3, n4);
            }
        });
        GlStateManager._glBindBuffer((int)37074, (int)0);
    }

    public void hasResizedScreen(int n, int n2) {
        if (n != this.cachedWidth || n2 != this.cachedHeight) {
            this.cachedWidth = n;
            this.cachedHeight = n2;
            for (ShaderStorageBuffer shaderStorageBuffer : this.buffers) {
                shaderStorageBuffer.resizeIfRelative(n, n2);
            }
        }
    }

    private static long toMib(long l) {
        return l / 1024L / 1024L;
    }

    public void setupBuffers() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed buffer objects");
        }
        for (ShaderStorageBuffer shaderStorageBuffer : this.buffers) {
            shaderStorageBuffer.bind();
        }
    }

    public void destroyBuffers() {
        for (ShaderStorageBuffer shaderStorageBuffer : this.buffers) {
            shaderStorageBuffer.destroy();
        }
        this.buffers = null;
        this.destroyed = true;
    }

    private static class OutOfVideoMemoryError
    extends RuntimeException {
        public OutOfVideoMemoryError(String string) {
            super(string);
        }
    }
}

