/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class FileDialogUtil {
    private static final ExecutorService FILE_DIALOG_EXECUTOR = Executors.newSingleThreadExecutor();

    private FileDialogUtil() {
    }

    public static CompletableFuture<Optional<Path>> fileSelectDialog(DialogType dialogType, String string, @Nullable Path path, @Nullable String string2, String ... stringArray) {
        CompletableFuture<Optional<Path>> completableFuture = new CompletableFuture<Optional<Path>>();
        FILE_DIALOG_EXECUTOR.submit(() -> {
            String string4 = null;
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                PointerBuffer pointerBuffer = memoryStack.mallocPointer(stringArray.length);
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string5 = stringArray2[i];
                    pointerBuffer.put(memoryStack.UTF8((CharSequence)string5));
                }
                pointerBuffer.flip();
                String[] stringArray3 = stringArray2 = path != null ? path.toAbsolutePath().toString() : null;
                if (dialogType == DialogType.SAVE) {
                    string4 = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)string, (CharSequence)stringArray2, (PointerBuffer)pointerBuffer, (CharSequence)string2);
                } else if (dialogType == DialogType.OPEN) {
                    string4 = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)string, (CharSequence)stringArray2, (PointerBuffer)pointerBuffer, (CharSequence)string2, (boolean)false);
                }
            }
            completableFuture.complete(Optional.ofNullable(string4).map(string -> Paths.get(string, new String[0])));
        });
        return completableFuture;
    }

    public static enum DialogType {
        SAVE,
        OPEN;

    }
}

