/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction;

import com.crimsoncrips.alexsmobsinteraction.config.AMIConfigHolder;
import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.crimsoncrips.alexsmobsinteraction.effect.AMIEffects;
import com.crimsoncrips.alexsmobsinteraction.enchantment.AMIEnchantmentRegistry;
import com.crimsoncrips.alexsmobsinteraction.event.AMInteractionEvents;
import com.crimsoncrips.alexsmobsinteraction.item.AMIItemRegistry;
import com.crimsoncrips.alexsmobsinteraction.misc.CrimsonAdvancementTriggerRegistry;
import com.crimsoncrips.alexsmobsinteraction.networking.AMIPacketHandler;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="alexsmobsinteraction")
public class AlexsMobsInteraction {
    public static final String MODID = "alexsmobsinteraction";

    public AlexsMobsInteraction() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onModConfigEvent);
        AMIEnchantmentRegistry.DEF_REG.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new AMInteractionEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        AMIEffects.EFFECT_REGISTER.register(modEventBus);
        AMIEffects.POTION_REGISTER.register(modEventBus);
        AMIItemRegistry.DEF_REG.register(modEventBus);
        modEventBus.addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AMIConfigHolder.INTERACT_SPEC, "alexsmobsinteraction.toml");
        AMIPacketHandler.init();
    }

    @SubscribeEvent
    public void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == AMIConfigHolder.INTERACT_SPEC) {
            AMInteractionConfig.bake();
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        AMIEffects.init();
        CrimsonAdvancementTriggerRegistry.init();
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }
}

