/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.client.renderer;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.github.alexthe666.alexsmobs.client.event.ClientEvents;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alexsmobsinteraction", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AMIRendering {
    private static final ResourceLocation FARSEER_TEXT = AlexsMobsInteraction.prefix("textures/gui/farseer_text.png");
    private static final ResourceLocation FARSEER_TEXT_SHADOW = AlexsMobsInteraction.prefix("textures/gui/farseer_text_shadow.png");
    private static final ResourceLocation FARSEER_PORTAL = AlexsMobsInteraction.prefix("textures/gui/farseer_portal.png");
    public static float ALPHA_PROGRESS = 1.0f;

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "farseer_text", (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, 13, 8, 0.07, 1.0f, 0.0f, 0.0f, 3);
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, -10, 13, 0.17, 1.0f, 0.0f, 0.0f, 3);
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, 8, -17, 0.05, 0.0f, 1.0f, 0.0f, 3);
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, 17, -9, 0.12, 0.0f, 1.0f, 0.0f, 3);
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, -13, -9, 0.1, 0.0f, 0.0f, 1.0f, 3);
            AMIRendering.renderFarseerTextEffects(graphics, screenWidth, screenHeight, -8, 17, 0.04, 0.0f, 0.0f, 1.0f, 3);
            AMIRendering.renderFarseerText(graphics, screenWidth, screenHeight);
        });
    }

    public static void renderFarseerText(GuiGraphics graphics, int screenWidth, int screenHeight) {
        float currentAlpha = Math.min(2.0f - Math.abs(4.0f * ALPHA_PROGRESS - 2.0f), 1.0f);
        if (currentAlpha <= 0.0f) {
            return;
        }
        int imageWidth = 500;
        int imageHeight = 191;
        double movement = Math.sin(2.0 * Math.sin((double)ALPHA_PROGRESS / 2.0) * 300.0);
        ClientEvents.renderStaticScreenFor = 30;
        double x1 = (double)(screenWidth - imageWidth) / 2.0;
        double y2 = (double)(screenHeight - imageHeight) / 2.0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlpha);
        graphics.m_280398_(FARSEER_PORTAL, (int)x1, (int)y2, 0, 0.0f, 0.0f, 500, 191, 500, 191);
        graphics.m_280398_(FARSEER_TEXT, (int)(x1 + movement), (int)(y2 + movement), 0, 0.0f, 0.0f, 500, 191, 500, 191);
    }

    public static void renderFarseerTextEffects(GuiGraphics graphics, int screenWidth, int screenHeight, int xRange, int yRange, double speed, float red, float green, float blue, int transparency) {
        float currentAlpha = Math.min(2.0f - Math.abs(4.0f * ALPHA_PROGRESS - 2.0f), 1.0f);
        if (currentAlpha <= 0.0f) {
            return;
        }
        int imageWidth = 500;
        int imageHeight = 191;
        double movementX = (double)xRange * Math.sin((double)ALPHA_PROGRESS / speed) * 2.0;
        double movementY = (double)yRange * Math.sin((double)ALPHA_PROGRESS / speed) * 2.0;
        double x1 = (double)(screenWidth - imageWidth) / 2.0 + movementX;
        double y2 = (double)(screenHeight - imageHeight) / 2.0 + movementY;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)(currentAlpha / (float)transparency));
        graphics.m_280398_(FARSEER_TEXT_SHADOW, (int)x1, (int)y2, 0, 0.0f, 0.0f, 500, 191, 500, 191);
    }
}

