/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.event;

import biomesoplenty.api.block.BOPBlocks;
import com.crimsoncrips.alexsmobsinteraction.AMInteractionTagRegistry;
import com.crimsoncrips.alexsmobsinteraction.compat.SoulFiredCompat;
import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.crimsoncrips.alexsmobsinteraction.effect.AMIEffects;
import com.crimsoncrips.alexsmobsinteraction.misc.CrimsonAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAntChamber;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAlligatorSnappingTurtle;
import com.github.alexthe666.alexsmobs.entity.EntityBananaSlug;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeHead;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityFlutter;
import com.github.alexthe666.alexsmobs.entity.EntityFrilledShark;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.entity.EntitySoulVulture;
import com.github.alexthe666.alexsmobs.entity.EntitySugarGlider;
import com.github.alexthe666.alexsmobs.entity.EntityTusklin;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.EmeraldsForItemsTrade;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="alexsmobsinteraction", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AMInteractionEvents {
    @SubscribeEvent
    public void onEntityFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        if (entity instanceof EntityCrimsonMosquito) {
            EntityCrimsonMosquito crimsonMosquito = (EntityCrimsonMosquito)entity;
            if (AMInteractionConfig.BLOODED_ENABLED && crimsonMosquito.m_217043_().m_188500_() < 0.2) {
                crimsonMosquito.setBloodLevel(crimsonMosquito.getBloodLevel() + 1);
            }
        }
    }

    @SubscribeEvent
    public void tradeEvents(VillagerTradesEvent villagerTradesEvent) {
        if (villagerTradesEvent.getType() == VillagerProfession.f_35591_ && AMInteractionConfig.DEVILS_TRADE_ENABLED) {
            EmeraldsForItemsTrade pupfishTrade = new EmeraldsForItemsTrade((ItemLike)AMItemRegistry.DEVILS_HOLE_PUPFISH_BUCKET.get(), 24, 2, 5);
            List list = (List)villagerTradesEvent.getTrades().get(5);
            list.add(pupfishTrade);
            villagerTradesEvent.getTrades().put(5, (Object)list);
        }
    }

    @SubscribeEvent
    public void mobTickEvents(LivingEvent.LivingTickEvent livingTickEvent) {
        LivingEntity livingEntity = livingTickEvent.getEntity();
        if (AMInteractionConfig.BLOODED_EFFECT_ENABLED && ModList.get().isLoaded("biomesoplenty") && livingEntity.m_146900_().m_60713_(BOPBlocks.BLOOD)) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)AMIEffects.BLOODED.get(), 140, 0));
        }
        if (livingEntity instanceof EntityCrimsonMosquito) {
            EntityCrimsonMosquito crimsonMosquito = (EntityCrimsonMosquito)livingEntity;
            Entity attach = crimsonMosquito.m_20202_();
            if (AMInteractionConfig.GOOFY_MODE_ENABLED && AMInteractionConfig.GOOFY_CRIMSON_MULTIPLY_ENABLED && attach != null && crimsonMosquito.getBloodLevel() > 1 && !(attach instanceof Player)) {
                ((EntityType)AMEntityRegistry.GUST.get()).m_262496_((ServerLevel)crimsonMosquito.m_9236_(), BlockPos.m_274561_((double)crimsonMosquito.m_20185_(), (double)(crimsonMosquito.m_20186_() + 0.2), (double)crimsonMosquito.m_20189_()), MobSpawnType.MOB_SUMMONED);
                attach.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (livingEntity instanceof EntityGrizzlyBear) {
            EntityGrizzlyBear grizzlyBear = (EntityGrizzlyBear)livingEntity;
            if (AMInteractionConfig.FREDDYABLE_ENABLED) {
                String freddy = "Freddy Fazbear";
                if (grizzlyBear.m_7755_().getString().equals(freddy)) {
                    grizzlyBear.setAprilFoolsFlag(2);
                    if (!AMInteractionConfig.GOOFY_MODE_ENABLED) {
                        grizzlyBear.m_7105_(false);
                        grizzlyBear.m_21816_(null);
                    }
                }
            }
        }
        if (livingEntity instanceof EntityElephant) {
            EntityElephant elephant = (EntityElephant)livingEntity;
            if (AMInteractionConfig.ELEPHANT_TRAMPLE_ENABLED) {
                Iterator var4 = elephant.m_9236_().m_45976_(LivingEntity.class, elephant.m_20191_().m_82363_(0.5, -2.0, 0.5)).iterator();
                if (elephant.m_20160_() && elephant.m_21824_()) {
                    while (var4.hasNext()) {
                        LivingEntity entity = (LivingEntity)var4.next();
                        if (entity == elephant || entity == elephant.m_6688_() || !(entity.m_20206_() <= 2.5f)) continue;
                        entity.m_6469_(elephant.m_269291_().m_269333_((LivingEntity)elephant), 8.0f + elephant.m_217043_().m_188501_() * 2.0f);
                    }
                }
            }
        }
        if (livingEntity instanceof EntityBananaSlug) {
            EntityBananaSlug bananaSlug = (EntityBananaSlug)livingEntity;
            if (!AMInteractionConfig.GOOFY_MODE_ENABLED) {
                return;
            }
            if (!AMInteractionConfig.GOOFY_BANANA_SLIP_ENABLED) {
                return;
            }
            for (LivingEntity livingEntitys : bananaSlug.m_9236_().m_45976_(LivingEntity.class, bananaSlug.m_20191_().m_82363_(0.5, 0.2, 0.5))) {
                if (!(livingEntitys instanceof Player)) continue;
                livingEntitys.m_6074_();
            }
        }
        if (livingEntity instanceof EntityAlligatorSnappingTurtle) {
            EntityAlligatorSnappingTurtle snappingturtle = (EntityAlligatorSnappingTurtle)livingEntity;
            if (!AMInteractionConfig.SNAPPING_MOSS_ENABLED) {
                return;
            }
            if (!(snappingturtle.m_217043_().m_188500_() < 1.0E-4)) {
                return;
            }
            if (snappingturtle.m_9236_().m_46471_() || snappingturtle.m_9236_().m_46470_() || snappingturtle.m_20069_()) {
                snappingturtle.setMoss(Math.min(10, snappingturtle.getMoss() + 1));
            }
        }
        if (livingEntity instanceof EntityCentipedeHead) {
            Player player;
            EntityCentipedeHead centipede = (EntityCentipedeHead)livingEntity;
            if (!AMInteractionConfig.LIGHT_FEAR_ENABLED) {
                return;
            }
            LivingEntity target = centipede.m_5448_();
            if (target == null) {
                return;
            }
            if (centipede.m_21188_() == target) {
                return;
            }
            if (target.m_21093_((Predicate)Ingredient.m_204132_(AMInteractionTagRegistry.CENTIPEDE_LIGHT_FEAR)) || target instanceof Player && this.curiosLight(player = (Player)target)) {
                centipede.m_6710_(null);
            }
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BlockState feetBlockstate = player.m_20075_();
            if (AMInteractionConfig.COMBUSTABLE_ENABLED && player.m_21023_((MobEffect)AMEffectRegistry.OILED.get())) {
                if (feetBlockstate.m_60713_(Blocks.f_50450_) || feetBlockstate.m_60713_(Blocks.f_50683_)) {
                    player.m_20254_(20);
                }
                if (feetBlockstate.m_60713_(Blocks.f_50684_)) {
                    if (ModList.get().isLoaded("soulfired")) {
                        SoulFiredCompat.setOnFire((Entity)player, 20);
                    } else {
                        player.m_20254_(20);
                    }
                }
            }
            if (AMInteractionConfig.GOOFY_BANANA_SLIP_ENABLED && AMInteractionConfig.GOOFY_MODE_ENABLED && feetBlockstate.m_60713_((Block)AMBlockRegistry.BANANA_PEEL.get())) {
                player.m_6074_();
            }
            if (AMInteractionConfig.SUNBIRD_UPGRADE_ENABLED) {
                for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82377_(7.0, 4.0, 7.0))) {
                    EntityType entityType = entity.m_6095_();
                    if (!entityType.m_204039_(AMInteractionTagRegistry.BURNABLE_DEAD) || entity.m_20069_()) continue;
                    if (player.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_BLESSING.get())) {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                        entity.m_20254_(3);
                    }
                    if (!player.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_CURSE.get())) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 350, 2));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 0));
                }
            }
            if (AMInteractionConfig.TIGER_STEALTH_ENABLED && player.m_21023_((MobEffect)AMEffectRegistry.TIGERS_BLESSING.get()) && !player.m_20142_() && !player.m_6069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 30, 0));
            }
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        RandomSource random = player.m_217043_();
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (itemStack.m_41720_() == AMItemRegistry.LAVA_BOTTLE.get() && AMInteractionConfig.MOLTEN_BATH_ENABLED) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                living.m_20254_(10);
                player.m_36356_(Items.f_42590_.m_7968_());
            }
            if (itemStack.m_41720_() == AMItemRegistry.POISON_BOTTLE.get() && AMInteractionConfig.POISONOUS_BATH_ENABLED) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 150, 1));
                player.m_36356_(Items.f_42590_.m_7968_());
            }
            if (living instanceof EntityCrimsonMosquito) {
                EntityCrimsonMosquito crimsonMosquito = (EntityCrimsonMosquito)living;
                if (AMInteractionConfig.CRIMSON_TRANSFORM_ENABLED && itemStack.m_41720_() == AMItemRegistry.WARPED_MUSCLE.get() && crimsonMosquito.m_21023_(MobEffects.f_19613_)) {
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                    crimsonMosquito.m_146850_(GameEvent.f_223708_);
                    crimsonMosquito.m_146850_(GameEvent.f_157806_);
                    crimsonMosquito.m_5496_(SoundEvents.f_11912_, 1.0f, crimsonMosquito.m_6100_());
                    crimsonMosquito.setSick(true);
                }
            }
            if (living instanceof EntityBananaSlug) {
                EntityBananaSlug bananaSlug = (EntityBananaSlug)living;
                if (!AMInteractionConfig.BANANA_SHEAR_ENABLED) {
                    return;
                }
                if (itemStack.m_41720_() != Items.f_42574_) {
                    return;
                }
                if (!player.m_7500_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p_233654_0_ -> {});
                }
                bananaSlug.m_146850_(GameEvent.f_223708_);
                bananaSlug.m_5496_(SoundEvents.f_12344_, 1.0f, bananaSlug.m_6100_());
                bananaSlug.m_19998_((ItemLike)AMItemRegistry.BANANA.get());
                bananaSlug.m_146870_();
            }
            if (living instanceof EntityFlutter) {
                EntityFlutter flutter = (EntityFlutter)living;
                if (itemStack.m_41720_() == Items.f_41951_ && AMInteractionConfig.FLUTTER_WITHERED_ENABLED && !flutter.m_21824_()) {
                    if (!player.m_7500_()) {
                        itemStack.m_41622_(1, (LivingEntity)flutter, p_233654_0_ -> {});
                    }
                    flutter.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 900, 0));
                }
                if (itemStack.m_41720_() == Items.f_42574_ && AMInteractionConfig.FLUTTER_SHEAR_ENABLED && !flutter.m_21824_()) {
                    flutter.m_5496_(SoundEvents.f_12344_, 1.0f, flutter.m_6100_());
                    flutter.m_19998_((ItemLike)Items.f_151014_);
                    flutter.m_19998_((ItemLike)Items.f_151012_);
                    flutter.m_19998_((ItemLike)Items.f_151012_);
                    if (!player.m_7500_()) {
                        itemStack.m_41622_(6, (LivingEntity)flutter, p_233654_0_ -> {});
                    }
                    flutter.m_146870_();
                }
            }
            if (living instanceof EntitySugarGlider) {
                EntitySugarGlider sugarGlider = (EntitySugarGlider)living;
                if (!AMInteractionConfig.SUGAR_RUSH_ENABLED) {
                    return;
                }
                if (itemStack.m_41720_() == Items.f_42501_ || itemStack.m_41720_() == Items.f_41909_) {
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                    sugarGlider.m_146850_(GameEvent.f_157806_);
                    sugarGlider.m_5496_(SoundEvents.f_11947_, 1.0f, sugarGlider.m_6100_());
                    sugarGlider.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 900, 1));
                }
            }
            if (living instanceof EntityGrizzlyBear) {
                EntityGrizzlyBear grizzlyBear = (EntityGrizzlyBear)living;
                if (!AMInteractionConfig.BRUSHED_ENABLED) {
                    return;
                }
                if (itemStack.m_41720_() != Items.f_271356_) {
                    return;
                }
                if (!player.m_7500_()) {
                    itemStack.m_41622_(32, (LivingEntity)player, p_233654_0_ -> {});
                }
                grizzlyBear.m_19998_((ItemLike)AMItemRegistry.BEAR_FUR.get());
                if (random.m_188500_() < 0.2) {
                    grizzlyBear.m_19998_((ItemLike)AMItemRegistry.BEAR_FUR.get());
                }
                if (random.m_188500_() < 2.0E-4) {
                    grizzlyBear.m_19998_((ItemLike)AMItemRegistry.BEAR_DUST.get());
                }
            }
        }
    }

    @SubscribeEvent
    public void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState = event.getEntity().m_9236_().m_8055_(event.getPos());
        BlockPos pos = event.getPos();
        Level worldIn = event.getLevel();
        RandomSource random = event.getEntity().m_217043_();
        Player livingEntity = event.getEntity();
        if (AMInteractionConfig.SKREECHER_WARD_ENABLED && event.getItemStack().m_150930_((Item)AMItemRegistry.SKREECHER_SOUL.get()) && blockState.m_60713_(Blocks.f_220858_) && ((Boolean)blockState.m_61143_((Property)SculkShriekerBlock.f_222154_)).booleanValue()) {
            Player player;
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    BlockPos sculkPos = new BlockPos(pos.m_123341_() + x - 2, pos.m_123342_() - 1, pos.m_123343_() + z - 2);
                    BlockState sculkPosState = worldIn.m_8055_(sculkPos);
                    if (!(random.m_188500_() < 0.7) || !sculkPosState.m_204336_(BlockTags.f_215823_)) continue;
                    worldIn.m_7731_(sculkPos, Blocks.f_220855_.m_49966_(), 2);
                    worldIn.m_186460_(sculkPos, sculkPosState.m_60734_(), 8);
                    worldIn.m_5594_((Player)null, sculkPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + random.m_188501_() * 0.4f);
                    if (random.m_188500_() < 0.2) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235898_, (double)sculkPos.m_123341_() + 0.5, (double)sculkPos.m_123342_() + 1.15, (double)sculkPos.m_123343_() + 0.5, 0.0, 0.05, 0.0);
                    }
                    if (!(random.m_188500_() < 0.2)) continue;
                    for (int i = 0; i < random.m_188503_(5); ++i) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235900_, (double)sculkPos.m_123341_() + 0.5, (double)sculkPos.m_123342_() + 1.15, (double)sculkPos.m_123343_() + 0.5, 0.0 + random.m_188583_() * 0.02, 0.01 + random.m_188583_() * 0.02, 0.0 + random.m_188583_() * 0.02);
                    }
                }
            }
            worldIn.m_5594_(null, pos, SoundEvents.f_215750_, SoundSource.AMBIENT, 1.0f, 1.0f);
            worldIn.m_46597_(pos, (BlockState)blockState.m_61124_((Property)SculkShriekerBlock.f_222154_, (Comparable)Boolean.valueOf(true)));
            if (livingEntity instanceof Player && !(player = livingEntity).m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            for (int i = 0; i < 100; ++i) {
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d0, d1, d2);
            }
        }
        if (AMInteractionConfig.COCKROACH_CHAMBER_ENABLED && blockState.m_60713_((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) && !worldIn.f_46443_) {
            if ((Integer)blockState.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) != 5) {
                return;
            }
            if (!(livingEntity.m_217043_().m_188500_() < 0.7)) {
                return;
            }
            Entity entityToSpawn = ((EntityType)AMEntityRegistry.COCKROACH.get()).m_262496_((ServerLevel)worldIn, BlockPos.m_274561_((double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.0), (double)((double)pos.m_123343_() + 0.5)), MobSpawnType.MOB_SUMMONED);
            if (entityToSpawn instanceof EntityCockroach) {
                EntityCockroach cockroach = (EntityCockroach)entityToSpawn;
                if (worldIn.m_213780_().m_188500_() < 0.07) {
                    cockroach.m_6863_(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag playerData = event.getEntity().getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (!data.m_128471_("ami_book") && AMInteractionConfig.CRIMSON_WIKI_ENABLED) {
            System.out.println("testing");
            CrimsonAdvancementTriggerRegistry.AMI_BOOK.trigger((ServerPlayer)player);
            data.m_128379_("ami_book", true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public void mobDeath(LivingDeathEvent livingDeathEvent) {
        LivingEntity deadEntity = livingDeathEvent.getEntity();
        LivingEntity murdererEntity = deadEntity.m_271686_();
        if (AMInteractionConfig.SNOW_LUCK_ENABLED && murdererEntity instanceof EntitySnowLeopard) {
            RandomSource random = murdererEntity.m_217043_();
            if (deadEntity instanceof Goat && random.m_188500_() < 0.5) {
                murdererEntity.m_19998_((ItemLike)Items.f_220219_);
                if (random.m_188500_() < 0.05) {
                    murdererEntity.m_19998_((ItemLike)Items.f_220219_);
                }
            } else if (deadEntity instanceof Turtle && random.m_188500_() < 0.2) {
                murdererEntity.m_19998_((ItemLike)Items.f_42355_);
            } else if (deadEntity instanceof EntityFrilledShark && random.m_188500_() < 0.08) {
                murdererEntity.m_19998_((ItemLike)AMItemRegistry.SERRATED_SHARK_TOOTH.get());
                if (random.m_188500_() < 0.01) {
                    murdererEntity.m_19998_((ItemLike)AMItemRegistry.SERRATED_SHARK_TOOTH.get());
                }
            } else if (deadEntity instanceof EntityBananaSlug && random.m_188500_() < 0.2) {
                murdererEntity.m_19998_((ItemLike)AMItemRegistry.BANANA_SLUG_SLIME.get());
            } else if (deadEntity instanceof Rabbit) {
                murdererEntity.m_19998_((ItemLike)Items.f_42648_);
                if (random.m_188500_() < 0.02) {
                    deadEntity.m_19998_((ItemLike)Items.f_42648_);
                }
            }
        }
    }

    @SubscribeEvent
    public void mobAttack(LivingAttackEvent attackEvent) {
        Entity entity = attackEvent.getSource().m_7640_();
        if (entity instanceof EntitySoulVulture) {
            EntitySoulVulture soulVulture = (EntitySoulVulture)entity;
            soulVulture.setSoulLevel(soulVulture.getSoulLevel() + 1);
        }
    }

    @SubscribeEvent
    public void mobHurt(LivingHurtEvent hurtEvent) {
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent breakEvent) {
        BlockState blockState = breakEvent.getState();
        Level level = (Level)breakEvent.getLevel();
        if (AMInteractionConfig.COCKROACH_CHAMBER_ENABLED && blockState.m_60713_((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) && breakEvent.getLevel().m_213780_().m_188500_() < 0.1) {
            if ((Integer)blockState.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) < 3) {
                return;
            }
            Entity entityToSpawn = ((EntityType)AMEntityRegistry.COCKROACH.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)((double)breakEvent.getPos().m_123341_() + 0.5), (double)((double)breakEvent.getPos().m_123342_() + 1.0), (double)((double)breakEvent.getPos().m_123343_() + 0.5)), MobSpawnType.MOB_SUMMONED);
            if (entityToSpawn instanceof EntityCockroach) {
                EntityCockroach cockroach = (EntityCockroach)entityToSpawn;
                if (breakEvent.getLevel().m_213780_().m_188500_() < 0.8) {
                    cockroach.m_6863_(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void struckLightning(EntityStruckByLightningEvent lightningEvent) {
        Entity entity = lightningEvent.getEntity();
        if (entity instanceof EntityTusklin) {
            EntityTusklin tusklin = (EntityTusklin)entity;
            if (AMInteractionConfig.TUSKLIN_STRUCK_ENABLED) {
                Level level = tusklin.m_9236_();
                if (!level.f_46443_) {
                    LivingEntity entityToSpawn = (LivingEntity)EntityType.f_20500_.m_262496_((ServerLevel)level, BlockPos.m_274561_((double)(tusklin.m_20185_() + 0.5), (double)(tusklin.m_20186_() + 1.0), (double)(tusklin.m_20189_() + 0.5)), MobSpawnType.TRIGGERED);
                    if (tusklin.m_6162_() && entityToSpawn instanceof Zoglin) {
                        Zoglin zoglin = (Zoglin)entityToSpawn;
                        zoglin.m_6863_(true);
                    }
                    tusklin.m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public void mobSpawn(MobSpawnEvent.PositionCheck spawnPlacementCheck) {
        EntityType entityType = spawnPlacementCheck.getEntity().m_6095_();
        Holder biome = spawnPlacementCheck.getLevel().m_204166_(spawnPlacementCheck.getEntity().m_20183_());
        long time = spawnPlacementCheck.getLevel().m_8044_();
        if (entityType == AMEntityRegistry.LOBSTER.get()) {
            if (!AMInteractionConfig.LOBSTER_NIGHT_ENABLED) {
                return;
            }
            if (time <= 13000L || time >= 23460L) {
                spawnPlacementCheck.setResult(Event.Result.DENY);
            }
        }
    }

    public boolean curiosLight(Player player) {
        if (ModList.get().isLoaded("curiouslanterns")) {
            ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElseThrow(() -> new IllegalStateException("Player " + player.m_7755_() + " has no curios inventory!"));
            return ((ICurioStacksHandler)handler.getStacksHandler("belt").orElseThrow()).getStacks().getStackInSlot(0).m_204117_(AMInteractionTagRegistry.CENTIPEDE_LIGHT_FEAR);
        }
        return false;
    }
}

