/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.goal;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public class AMIFollowNearestGoal<T extends LivingEntity>
extends Goal {
    protected final PathfinderMob mob;
    final Predicate<T> followPredicate;
    protected Class<T> targetType;
    private final double speedModifier;
    private final float areaSize;
    private final PathNavigation navigation;
    private int timeToRecalcPath;

    public AMIFollowNearestGoal(PathfinderMob mob, Class<T> targetType, float areaSize, double speedModifier, @Nullable Predicate<T> followPredicate) {
        this.mob = mob;
        this.targetType = targetType;
        this.followPredicate = followPredicate;
        this.speedModifier = speedModifier;
        this.areaSize = areaSize;
        this.navigation = mob.m_21573_();
    }

    public boolean m_8036_() {
        return this.getTarget() != null;
    }

    public void m_8037_() {
        LivingEntity target = this.getTarget();
        if (target != null && !this.mob.m_21523_()) {
            this.mob.m_21563_().m_24960_((Entity)target, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_5624_((Entity)target, this.speedModifier);
            }
        } else {
            this.timeToRecalcPath = this.m_183277_(10);
            this.navigation.m_26573_();
        }
    }

    @Nullable
    private LivingEntity getTarget() {
        Level level = this.mob.m_9236_();
        List targetList = level.m_6443_(this.targetType, this.mob.m_20191_().m_82400_((double)this.areaSize), this.followPredicate);
        if (targetList.isEmpty()) {
            return null;
        }
        return (LivingEntity)targetList.get(0);
    }
}

