/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.crimsoncrips.alexsmobsinteraction.goal.AvoidBlockGoal;
import com.github.alexthe666.alexsmobs.entity.EntityTusklin;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityTusklin.class})
public abstract class AMITusklin
extends Mob {
    private int ridingTime = 0;
    private int entityToLaunchId = -1;
    private int conversionTime = 0;
    private static final EntityDataAccessor<Boolean> PERMTRUSTED = SynchedEntityData.m_135353_(EntityTusklin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    @Nullable
    public abstract LivingEntity m_6688_();

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(PERMTRUSTED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("PermTrusted", this.isPermTrusted());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setPermTrusted(compound.m_128471_("PermTrusted"));
    }

    public boolean isPermTrusted() {
        return (Boolean)this.f_19804_.m_135370_(PERMTRUSTED);
    }

    public void setPermTrusted(boolean permTrusted) {
        this.f_19804_.m_135381_(PERMTRUSTED, (Object)permTrusted);
    }

    protected AMITusklin(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (source.m_7640_() instanceof Player) {
            this.setPermTrusted(false);
        }
        return prev;
    }

    public boolean m_6779_(LivingEntity entity) {
        EntityTusklin tusklin = (EntityTusklin)this;
        boolean prev = super.m_6779_(entity);
        return !(entity instanceof Player) || this.m_21188_() != null && this.m_21188_().equals((Object)entity) || tusklin.getPassiveTicks() <= 0 && !this.isPermTrusted() && !this.isMushroom(entity.m_21120_(InteractionHand.MAIN_HAND)) && !tusklin.isMushroom(entity.m_21120_(InteractionHand.OFF_HAND)) ? prev : false;
    }

    public boolean isMushroom(ItemStack stack) {
        return stack.m_150930_(Items.f_41952_) || stack.m_150930_(Items.f_42400_);
    }

    public void m_8119_() {
        LivingEntity passenger;
        EntityTusklin tusklin = (EntityTusklin)this;
        super.m_8119_();
        if (tusklin.isInNether()) {
            LivingEntity entityToSpawn;
            ++this.conversionTime;
            if (this.conversionTime > 300 && !this.m_9236_().f_46443_ && (entityToSpawn = (LivingEntity)EntityType.f_20456_.m_262496_((ServerLevel)this.m_9236_(), BlockPos.m_274446_((Position)this.m_20318_(1.0f)), MobSpawnType.MOB_SUMMONED)) != null) {
                entityToSpawn.m_146922_(this.m_9236_().m_213780_().m_188501_() * 360.0f);
                entityToSpawn.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                this.m_5907_();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (AMInteractionConfig.TUSKLIN_TRAMPLE_ENABLED && this.m_20160_()) {
            for (Entity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82363_(0.2, -2.0, 0.2))) {
                if (entity == this || entity == this.m_6688_() || !(entity.m_20206_() <= 2.1f) || !this.m_20160_()) continue;
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 3.0f + this.f_19796_.m_188501_() * 2.0f);
                if (!entity.m_20096_()) continue;
                double d0 = entity.m_20185_() - this.m_20185_();
                double d1 = entity.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                float f = 0.5f;
                entity.m_5997_(d0 / d2 * (double)f, (double)f, d1 / d2 * (double)f);
            }
        }
        if (this.entityToLaunchId != -1 && this.m_6084_()) {
            Entity launch = this.m_9236_().m_6815_(this.entityToLaunchId);
            this.m_20153_();
            this.entityToLaunchId = -1;
            if (launch != null && !launch.m_20159_() && launch instanceof LivingEntity) {
                launch.m_146884_(this.m_146892_().m_82520_(0.0, 1.0, 0.0));
                float rot = 180.0f + this.m_146908_();
                float strength = (float)((double)this.getLaunchStrength() * (1.0 - ((LivingEntity)launch).m_21133_(Attributes.f_22278_)));
                float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
                float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
                if (!((double)strength <= 0.0)) {
                    launch.f_19812_ = true;
                    Vec3 vec3 = this.m_20184_();
                    Vec3 vec31 = vec3.m_82549_(new Vec3((double)x, 0.0, (double)z).m_82541_().m_82490_((double)strength));
                    launch.m_20334_(vec31.f_82479_, (double)strength, vec31.f_82481_);
                }
            }
        }
        if (tusklin.getAnimation() == EntityTusklin.ANIMATION_BUCK && tusklin.getAnimationTick() >= 5 && (passenger = this.m_6688_()) instanceof LivingEntity) {
            this.entityToLaunchId = passenger.m_19879_();
        }
        if (!this.m_9236_().f_46443_) {
            if (AMInteractionConfig.TUSKLIN_TRUST_ENABLED) {
                if (this.m_20160_() && !this.isPermTrusted()) {
                    ++this.ridingTime;
                    if (this.ridingTime >= this.getMaxRidingTime() && tusklin.getAnimation() != EntityTusklin.ANIMATION_BUCK) {
                        tusklin.setAnimation(EntityTusklin.ANIMATION_BUCK);
                    }
                } else {
                    this.ridingTime = 0;
                }
            } else if (this.m_20160_()) {
                ++this.ridingTime;
                if (this.ridingTime >= this.getMaxRidingTime() && tusklin.getAnimation() != EntityTusklin.ANIMATION_BUCK) {
                    tusklin.setAnimation(EntityTusklin.ANIMATION_BUCK);
                }
            } else {
                this.ridingTime = 0;
            }
            if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.m_20270_((Entity)this.m_5448_()) < this.m_5448_().m_20205_() + this.m_20205_() + 1.8f) {
                if (tusklin.getAnimation() == EntityTusklin.ANIMATION_FLING && tusklin.getAnimationTick() == 6) {
                    this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                    this.knockbackTarget(this.m_5448_(), 0.9f, 0.0f);
                }
                if (tusklin.getAnimation() == EntityTusklin.ANIMATION_GORE_L && tusklin.getAnimationTick() == 6) {
                    this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                    this.knockbackTarget(this.m_5448_(), 0.5f, -90.0f);
                }
                if (tusklin.getAnimation() == EntityTusklin.ANIMATION_GORE_R && tusklin.getAnimationTick() == 6) {
                    this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                    this.knockbackTarget(this.m_5448_(), 0.5f, 90.0f);
                }
            }
        }
        if (tusklin.getAnimation() == EntityTusklin.ANIMATION_RUT && tusklin.getAnimationTick() == 23 && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_) && this.m_217043_().m_188503_(3) == 0) {
            if (this.m_6162_() && this.m_9236_().m_8055_(this.m_20183_()).m_247087_() && this.f_19796_.m_188503_(3) == 0) {
                this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50072_.m_49966_());
                this.m_146850_(GameEvent.f_157794_);
                this.m_5496_(SoundEvents.f_11839_, this.m_6121_(), this.m_6100_());
            }
            this.m_9236_().m_46796_(2001, this.m_20183_().m_7495_(), Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
            this.m_9236_().m_7731_(this.m_20183_().m_7495_(), Blocks.f_50493_.m_49966_(), 2);
            this.m_5634_(5.0f);
        }
        if (!this.m_9236_().f_46443_ && tusklin.getAnimation() == EntityTusklin.NO_ANIMATION && this.m_217043_().m_188503_(this.m_6162_() ? 140 : 70) == 0 && (this.m_21188_() == null || this.m_20270_((Entity)this.m_21188_()) > 30.0f) && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_) && this.m_217043_().m_188503_(3) == 0) {
            tusklin.setAnimation(EntityTusklin.ANIMATION_RUT);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)tusklin);
    }

    private float getLaunchStrength() {
        EntityTusklin tusklin = (EntityTusklin)this;
        return tusklin.getShoeStack().m_150930_((Item)AMItemRegistry.PIGSHOES.get()) ? 0.4f : 0.9f;
    }

    private int getMaxRidingTime() {
        EntityTusklin tusklin = (EntityTusklin)this;
        return tusklin.getShoeStack().m_150930_((Item)AMItemRegistry.PIGSHOES.get()) ? 160 : 60;
    }

    private void knockbackTarget(LivingEntity entity, float strength, float angle) {
        float rot = this.m_146908_() + angle;
        if (entity != null) {
            entity.m_147240_((double)strength, (double)Mth.m_14031_((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(rot * ((float)Math.PI / 180)))));
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = player.m_21120_(hand);
        if (AMInteractionConfig.TUSKLIN_TRUST_ENABLED && itemstack.m_41720_() == Items.f_42400_) {
            itemstack.m_41774_(1);
            this.m_146850_(GameEvent.f_157806_);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
            this.setPermTrusted(true);
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        EntityTusklin tusklin = (EntityTusklin)this;
        if (AMInteractionConfig.TUSKLIN_FLEE_ENABLED) {
            tusklin.f_21345_.m_25352_(3, (Goal)new AvoidBlockGoal((PathfinderMob)tusklin, 4.0f, 1.0, 1.2, pos -> {
                BlockState state = tusklin.m_9236_().m_8055_(pos);
                return state.m_204336_(BlockTags.f_13084_);
            }));
        }
    }
}

