/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.lavithan;

import com.crimsoncrips.alexsmobsinteraction.AMInteractionTagRegistry;
import com.crimsoncrips.alexsmobsinteraction.ReflectionUtil;
import com.crimsoncrips.alexsmobsinteraction.config.AMInteractionConfig;
import com.crimsoncrips.alexsmobsinteraction.mobmodification.interfaces.AMILavithanInterface;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathanPart;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.util.Maths;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityLaviathan.class})
public abstract class AMILavithan
extends Animal
implements ISemiAquatic,
IHerdPanic,
AMILavithanInterface {
    private static final EntityDataAccessor<Boolean> RELAVA = SynchedEntityData.m_135353_(EntityLaviathan.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RELAVATICK = SynchedEntityData.m_135353_(EntityLaviathan.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean hasObsidianArmor;
    private int conversionTime = 0;
    public final EntityLaviathanPart[] allParts;

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(RELAVA, (Object)false);
        this.f_19804_.m_135372_(RELAVATICK, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Relava", this.isRelava());
        compound.m_128405_("RelavaTicks", this.getRelavaTicks());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setRelava(compound.m_128471_("Relava"));
        this.setRelavaTicks(compound.m_128451_("RelavaTicks"));
    }

    public int getRelavaTicks() {
        return (Integer)this.f_19804_.m_135370_(RELAVATICK);
    }

    public void setRelavaTicks(int relavaTime) {
        this.f_19804_.m_135381_(RELAVATICK, (Object)relavaTime);
    }

    protected AMILavithan(EntityType<? extends Animal> pEntityType, Level pLevel, EntityLaviathanPart[] allParts, EntityLaviathanPart[] allParts1) {
        super(pEntityType, pLevel);
        this.allParts = allParts1;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        EntityLaviathan laviathan = (EntityLaviathan)this;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_204117_(AMInteractionTagRegistry.LAVITHAN_PICKAXES) && laviathan.isObsidian() && !this.isRelava() && AMInteractionConfig.OBSIDIAN_EXTRACT_ENABLED) {
            this.setRelava(true);
            laviathan.setObsidian(false);
            this.m_146850_(GameEvent.f_223708_);
            this.m_5496_(SoundEvents.f_11726_, this.m_6121_(), this.m_6100_());
            if (!this.m_6162_()) {
                for (int i = 0; i < 6; ++i) {
                    this.m_19998_((ItemLike)Items.f_41999_);
                }
                if (this.f_19796_.m_188500_() < 0.1) {
                    this.m_19998_((ItemLike)Items.f_41999_);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.m_19998_((ItemLike)Items.f_41999_);
                }
                if (this.f_19796_.m_188500_() < 0.05) {
                    this.m_19998_((ItemLike)Items.f_41999_);
                }
            }
            itemstack.m_41622_(1, (LivingEntity)this, p_233654_0_ -> {});
            this.m_21153_(this.m_21223_() - 3.0f);
            itemstack.m_41622_(10, (LivingEntity)this, p_233654_0_ -> {});
            return InteractionResult.SUCCESS;
        }
        if (item == Items.f_42542_ && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_5634_(10.0f);
            return InteractionResult.SUCCESS;
        }
        if (item == AMItemRegistry.STRADDLE_HELMET.get() && !laviathan.hasHeadGear() && !this.m_6162_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            laviathan.setHeadGear(true);
            return InteractionResult.SUCCESS;
        }
        if (item == AMItemRegistry.STRADDLE_SADDLE.get() && !laviathan.hasBodyGear() && !this.m_6162_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            laviathan.setBodyGear(true);
            return InteractionResult.SUCCESS;
        }
        InteractionResult type = super.m_6071_(player, hand);
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && !this.m_6898_(itemstack) && laviathan.hasBodyGear() && !this.m_6162_()) {
            if (!player.m_6144_()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this);
                }
            } else {
                this.m_20153_();
            }
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Override
    public boolean isRelava() {
        return (Boolean)this.f_19804_.m_135370_(RELAVA);
    }

    public void setRelava(boolean relava) {
        this.f_19804_.m_135381_(RELAVA, (Object)relava);
    }

    public void m_8119_() {
        super.m_8119_();
        EntityLaviathan laviathan = (EntityLaviathan)this;
        laviathan.prevSwimProgress = laviathan.swimProgress;
        laviathan.prevBiteProgress = laviathan.biteProgress;
        laviathan.prevHeadHeight = laviathan.getHeadHeight();
        laviathan.f_20883_ = laviathan.m_146908_();
        if (laviathan.shouldSwim()) {
            if (laviathan.swimProgress < 5.0f) {
                laviathan.swimProgress += 1.0f;
            }
        } else if (laviathan.swimProgress > 0.0f) {
            laviathan.swimProgress -= 1.0f;
        }
        if (laviathan.isObsidian()) {
            if (!this.hasObsidianArmor) {
                this.hasObsidianArmor = true;
                laviathan.m_21051_(Attributes.f_22284_).m_22100_(30.0);
            }
        } else if (this.hasObsidianArmor) {
            this.hasObsidianArmor = false;
            laviathan.m_21051_(Attributes.f_22284_).m_22100_(10.0);
        }
        if (!this.m_9236_().f_46443_) {
            if (!(laviathan.isObsidian() || !this.m_20072_() || this.isRelava() && AMInteractionConfig.OBSIDIAN_EXTRACT_ENABLED)) {
                if (this.conversionTime < 300) {
                    ++this.conversionTime;
                } else {
                    laviathan.setObsidian(true);
                    this.conversionTime = 0;
                }
            }
            if (!laviathan.isObsidian() && !this.m_20072_() && this.isRelava() && AMInteractionConfig.OBSIDIAN_EXTRACT_ENABLED) {
                if (this.getRelavaTicks() < 5000) {
                    this.setRelavaTicks(this.getRelavaTicks() + 1);
                } else {
                    this.setRelava(false);
                    this.setRelavaTicks(0);
                }
            }
            if (laviathan.shouldSwim()) {
                this.f_19789_ = 0.0f;
            }
        }
        float neckBase = 0.8f;
        if (!laviathan.m_21525_()) {
            int l;
            Vec3[] avector3d = new Vec3[laviathan.allParts.length];
            ReflectionUtil.callMethod(this.collideWithNearbyEntities(), "collideWithNearbyEntities", new Class[]{Integer.class, Float.class}, new Object[]{42, Float.valueOf(64.0f)});
            for (int j = 0; j < laviathan.allParts.length; ++j) {
                ReflectionUtil.callMethod(laviathan.allParts[j], "collideWithNearbyEntities", new Class[0], new Object[0]);
                avector3d[j] = new Vec3(laviathan.allParts[j].m_20185_(), laviathan.allParts[j].m_20186_(), laviathan.allParts[j].m_20189_());
            }
            float yaw = laviathan.m_146908_() * ((float)Math.PI / 180);
            float neckContraction = 2.0f * Math.abs(laviathan.getHeadHeight() / 3.0f) + 0.5f * Math.abs(laviathan.getHeadYaw(0.0f) / 50.0f);
            for (l = 0; l < laviathan.theEntireNeck.length; ++l) {
                float f = (float)l / (float)laviathan.theEntireNeck.length;
                float f1 = -(2.2f + (float)l - f * neckContraction);
                float f2 = Mth.m_14031_((float)(yaw + Maths.rad((double)(f * laviathan.getHeadYaw(0.0f))))) * (1.0f - Math.abs(laviathan.m_146909_() / 90.0f));
                float f3 = Mth.m_14089_((float)(yaw + Maths.rad((double)(f * laviathan.getHeadYaw(0.0f))))) * (1.0f - Math.abs(laviathan.m_146909_() / 90.0f));
                this.setPartPosition(laviathan.theEntireNeck[l], f2 * f1, (double)neckBase + Math.sin((double)f * Math.PI * 0.5) * (double)(laviathan.getHeadHeight() * 1.1f), -f3 * f1);
            }
            this.setPartPosition(laviathan.seat1, this.getXForPart(yaw, 145.0f) * 0.75f, 2.0, this.getZForPart(yaw, 145.0f) * 0.75f);
            this.setPartPosition(laviathan.seat2, this.getXForPart(yaw, -145.0f) * 0.75f, 2.0, this.getZForPart(yaw, -145.0f) * 0.75f);
            this.setPartPosition(laviathan.seat3, this.getXForPart(yaw, 35.0f) * 0.95f, 2.0, this.getZForPart(yaw, 35.0f) * 0.95f);
            this.setPartPosition(laviathan.seat4, this.getXForPart(yaw, -35.0f) * 0.95f, 2.0, this.getZForPart(yaw, -35.0f) * 0.95f);
            if (this.m_9236_().f_46443_ && laviathan.isChilling()) {
                if (!this.m_6162_()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)(this.getXForPart(yaw, 158.0f) * 1.75f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, 158.0f) * 1.75f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)(this.getXForPart(yaw, -166.0f) * 1.48f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, -166.0f) * 1.48f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)(this.getXForPart(yaw, 14.0f) * 1.78f), this.m_20227_(0.9), this.m_20189_() + (double)(this.getZForPart(yaw, 14.0f) * 1.78f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)(this.getXForPart(yaw, -14.0f) * 1.6f), this.m_20227_(1.1), this.m_20189_() + (double)(this.getZForPart(yaw, -14.0f) * 1.6f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                }
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, laviathan.headPart.m_20208_(0.6), laviathan.headPart.m_20227_(0.9), laviathan.headPart.m_20262_(0.6), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
            }
            if (this.m_9236_().f_46443_ && this.isRelava() && AMInteractionConfig.OBSIDIAN_EXTRACT_ENABLED && !this.m_6162_() && this.f_19796_.m_188500_() < 0.1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, 158.0f) * 1.75f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, 158.0f) * 1.75f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, -166.0f) * 1.48f), this.m_20227_(1.0), this.m_20189_() + (double)(this.getZForPart(yaw, -166.0f) * 1.48f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, 14.0f) * 1.78f), this.m_20227_(0.9), this.m_20189_() + (double)(this.getZForPart(yaw, 14.0f) * 1.78f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)(this.getXForPart(yaw, -14.0f) * 1.6f), this.m_20227_(1.1), this.m_20189_() + (double)(this.getZForPart(yaw, -14.0f) * 1.6f), 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
            }
            for (l = 0; l < laviathan.allParts.length; ++l) {
                laviathan.allParts[l].f_19854_ = avector3d[l].f_82479_;
                laviathan.allParts[l].f_19855_ = avector3d[l].f_82480_;
                laviathan.allParts[l].f_19856_ = avector3d[l].f_82481_;
                laviathan.allParts[l].f_19790_ = avector3d[l].f_82479_;
                laviathan.allParts[l].f_19791_ = avector3d[l].f_82480_;
                laviathan.allParts[l].f_19792_ = avector3d[l].f_82481_;
            }
        }
    }

    private void setPartPosition(EntityLaviathanPart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    private float getXForPart(float yaw, float degree) {
        return Mth.m_14031_((float)((float)((double)yaw + Math.toRadians(degree))));
    }

    private float getZForPart(float yaw, float degree) {
        return -Mth.m_14089_((float)((float)((double)yaw + Math.toRadians(degree))));
    }

    protected Object collideWithNearbyEntities() {
        return null;
    }
}

