/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigMan {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public ForgeConfigSpec.IntValue crucibleTickDelay;
        public ForgeConfigSpec.IntValue crucibleRange;
        public ForgeConfigSpec.IntValue areaMemoryRange;
        public ForgeConfigSpec.IntValue maxDisplaceCount;
        public ForgeConfigSpec.IntValue displaceConductRange;
        public ForgeConfigSpec.DoubleValue maxMoveBlockBreakTime;
        public ForgeConfigSpec.ConfigValue<List<String>> doNotTeleport;
        public ForgeConfigSpec.BooleanValue acidMeltBlockEntities;
        public ForgeConfigSpec.BooleanValue lightStaffLightsPermanent;
        public ForgeConfigSpec.BooleanValue registerCommand;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Options:").push("config");
            this.crucibleTickDelay = builder.comment("The crucible performs a stage of its calculations once every X game ticks. Lower numbers are more responsive, but laggier. [Default: 5]").defineInRange("crucibleTickDelay", 5, 1, 900);
            this.crucibleRange = builder.comment("The crucible affect entities with an area of this radius. [Default: 12]").defineInRange("crucibleRange", 12, 2, 64);
            this.areaMemoryRange = builder.comment("The crucible checks an area this many blocks in radius up to a few times a second. Do not set this too high. [Default: 6]").defineInRange("areaMemoryRange", 6, 2, 64);
            this.doNotTeleport = builder.comment("Certain effects might teleport entities if they are not in this blacklist. [Default: \"minecraft:ender_dragon\", \"minecraft:wither\", \"minecraft:warden\"]").define("doNotTeleport", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:warden"}));
            this.acidMeltBlockEntities = builder.comment("Whether acid should dissolve entity blocks. This would delete the contents of said blocks. [Default: false]").define("acidMeltBlockEntities", false);
            this.maxMoveBlockBreakTime = builder.comment("Blocks with a base break time beyond this cannot be displaced or made to fall. For finer control, use the relevant block tags. [Default: 35.0]").defineInRange("maxMoveBlockBreakTime", 35.0, 0.0, 10000.0);
            this.maxDisplaceCount = builder.comment("The maximum number of blocks that can be displaced at once by a certain effect. [Default: 128]").defineInRange("maxDisplaceCount", 128, 4, 4096);
            this.displaceConductRange = builder.comment("The maximum distance that a block like Copper can convey a displacement pulse [Default: 8]").defineInRange("copperDisplaceConductRange", 8, 1, 4096);
            this.lightStaffLightsPermanent = builder.comment("Whether the Radiant Staff of Power produces permanent light sources. When false, its lights will gradually vanish. [Default: true]").define("lightStaffLightsPermanent", true);
            this.registerCommand = builder.comment("Whether to register the /reactive command on startup. [Default: true]").define("registerCommand", true);
            builder.pop();
        }
    }

    public static class Server {
        public ForgeConfigSpec.BooleanValue useWorldSeed;
        public ForgeConfigSpec.LongValue seed;
        public ForgeConfigSpec.DoubleValue pehkuiSmallSize;
        public ForgeConfigSpec.DoubleValue pehkuiLargeSize;
        public ForgeConfigSpec.ConfigValue<List<String>> disabledReactions;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("World Specific Value Options:").push("wsv");
            this.seed = builder.comment("The seed value used to generate world-specific values. By default, it is set to your world seed on world load. If you change this, alchemy rules might change!").defineInRange("seed", 42L, Long.MIN_VALUE, Long.MAX_VALUE);
            this.useWorldSeed = builder.comment("Whether to reset the seed to your world seed when loading.").define("resetSeed", true);
            builder.pop();
            builder.comment("Mod Integration Options:").push("integration");
            this.pehkuiSmallSize = builder.comment(":Requires Pehkui: The scale that the Reduction reaction sets nearby creatures to. [Default: 0.65]").defineInRange("pehkuiSmallSize", 0.65, 0.05, 0.95);
            this.pehkuiLargeSize = builder.comment(":Requires Pehkui: The scale that the Enlargement reaction sets nearby creatures to. [Default: 1.33]").defineInRange("pehkuiLargeSize", 1.33, 1.05, 10.0);
            builder.pop();
            builder.comment("Other:").push("other");
            this.disabledReactions = builder.comment("A list of reaction aliases to disable. To see the reaction aliases, use /reactive reaction list [Default: []]").define("disabledReactions", (Object)Lists.newArrayList());
            builder.pop();
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue showPowerSources;
        public ForgeConfigSpec.BooleanValue doNotChangeWaterTexture;
        public ForgeConfigSpec.BooleanValue colorizeLitmusOutput;
        public ForgeConfigSpec.BooleanValue hidePowersFromJEI;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Side Options:").push("config");
            this.showPowerSources = builder.comment("Whether to show the sources of each Power in JEI. Use this if your pack adds a lot of unintuitive Power sources, or you become frustrated.").define("showPowerSources", false);
            this.doNotChangeWaterTexture = builder.comment("Whether to render all Powers using vanilla Water's icon. Use if Rubidium or other rendering mods make the custom water textures break.").define("doNotChangeWaterTexture", false);
            this.colorizeLitmusOutput = builder.comment("Whether to allow Litmus Paper to use multicolored text. Disable if the colored text is hard to read.").define("colorizeLitmusOutput", true);
            this.hidePowersFromJEI = builder.comment("Whether to hide the icons of Powers in JEI. This is on by default because otherwise the menu looks redundant due to how Power icons work.").define("hidePowersFromJEI", true);
            builder.pop();
        }
    }
}

