/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;

public class AnnihilationReaction
extends EffectReaction {
    public AnnihilationReaction(String alias, Power p1, Power p2, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render) {
        super(alias, function, render, 0);
        this.reagents.put(p1, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
        this.reagents.put(p2, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
        super.render(l, crucible);
        ParticleScribe.drawParticleCrucibleTop(l, (ParticleOptions)ParticleTypes.f_123762_, crucible.m_58899_(), 0.2f);
    }

    @Override
    public Reaction.Status conditionsMet(CrucibleBlockEntity crucible) {
        if (super.conditionsMet(crucible) == Reaction.Status.REACTING) {
            if (crucible.getTotalPowerLevel() > WorldSpecificValues.ANNIHILATION_THRESHOLD.get()) {
                return Reaction.Status.REACTING;
            }
            return Reaction.Status.POWER_TOO_WEAK;
        }
        return Reaction.Status.STABLE;
    }

    @Override
    public String toString() {
        return super.toString() + " - annihilation reaction";
    }
}

