/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Function;
import net.minecraft.world.level.Level;

public class FreeEffectReaction
extends Reaction {
    protected Function<CrucibleBlockEntity, CrucibleBlockEntity> effectFunction;
    protected Function<CrucibleBlockEntity, CrucibleBlockEntity> renderFunction;

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> effect, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, int numReagents) {
        super(alias, numReagents);
        this.effectFunction = effect;
        this.renderFunction = render;
    }

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power ... required_powers) {
        super(alias, 0);
        this.effectFunction = function;
        this.renderFunction = render;
        for (Power required_power : required_powers) {
            this.reagents.put(required_power, WorldSpecificValue.get(alias + required_power + "required", 1, 400));
        }
    }

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power required_power, int num_additionals) {
        super(alias, num_additionals);
        this.effectFunction = function;
        this.renderFunction = render;
        this.reagents.put(required_power, WorldSpecificValue.get(alias + "required", 1, 400));
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
        if (this.renderFunction != null) {
            this.renderFunction.apply(crucible);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " - effect reaction";
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        if (this.effectFunction != null) {
            this.effectFunction.apply(crucible);
        }
    }
}

