/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.FlagCriterion;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public abstract class Reaction {
    protected HashMap<Power, Integer> reagents = new HashMap();
    protected Stimulus stimulus = Stimulus.NONE;
    public FlagCriterion criterion;
    public FlagCriterion perfect_criterion;
    protected MutableComponent name;
    public boolean always_perfect = false;
    String alias;

    public Reaction(String alias, int max_reagent_count) {
        this.alias = alias;
        this.criterion = ReactionMan.CRITERIA_BUILDER.get(alias);
        this.perfect_criterion = ReactionMan.CRITERIA_BUILDER.get(alias + "_perfect");
        this.name = Component.m_237115_((String)("reaction.reactive." + alias));
        int reagent_count = max_reagent_count < 3 ? max_reagent_count : WorldSpecificValue.get(alias + "reagent_count", 2, max_reagent_count);
        int i = 0;
        while (this.reagents.size() < reagent_count) {
            Power chosen_power = WorldSpecificValue.getFromCollection(alias + "r" + i, ReactionMan.BASE_POWER_LIST);
            int min = WorldSpecificValue.get(alias + "r" + i, 1, 400);
            this.reagents.put(chosen_power, min);
            ++i;
        }
    }

    public Reaction(String alias, Power ... powers) {
        this.alias = alias;
        this.name = Component.m_237115_((String)("reaction.reactive." + alias));
        this.criterion = ReactionMan.CRITERIA_BUILDER.get(alias);
        this.perfect_criterion = ReactionMan.CRITERIA_BUILDER.get(alias + "_perfect");
        for (Power p : powers) {
            this.reagents.put(p, WorldSpecificValue.get(alias + p.getId(), 1, 400));
        }
    }

    public Reaction setStimulus(Stimulus rxs) {
        this.stimulus = rxs;
        return this;
    }

    public Stimulus getStimulus() {
        return this.stimulus;
    }

    public Map<Power, Integer> getReagents() {
        return this.reagents;
    }

    public Reaction markAlwaysPerfect() {
        this.always_perfect = true;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public Status conditionsMet(CrucibleBlockEntity crucible) {
        for (Power p : this.reagents.keySet()) {
            if (p.checkReactivity(crucible.getPowerLevel(p), this.reagents.get(p))) continue;
            if (crucible.getPowerLevel(p) > 0) {
                return Status.POWER_TOO_WEAK;
            }
            return Status.STABLE;
        }
        boolean met_conditions = this.checkStimulus(crucible);
        if (met_conditions) {
            if (crucible.getPowerLevel((Power)Powers.BODY_POWER.get()) > WorldSpecificValue.get("body_inhibition_threshold", 20, 200) && !this.reagents.containsKey(Powers.BODY_POWER.get())) {
                return Status.INHIBITED;
            }
            return Status.REACTING;
        }
        if (this.stimulus == Stimulus.NO_ELECTRIC) {
            return Status.INHIBITED;
        }
        if (this.reagents.size() == 1) {
            return Status.VOLATILE;
        }
        return Status.MISSING_STIMULUS;
    }

    private boolean checkStimulus(CrucibleBlockEntity crucible) {
        return switch (this.stimulus) {
            case Stimulus.END_CRYSTAL -> this.checkEndCrystal(crucible);
            case Stimulus.GOLD_SYMBOL -> crucible.areaMemory.exists(crucible.m_58904_(), (Block)Registration.GOLD_SYMBOL.get());
            case Stimulus.ELECTRIC -> {
                if (crucible.electricCharge > 0) {
                    yield true;
                }
                yield false;
            }
            case Stimulus.NO_ELECTRIC -> {
                if (crucible.electricCharge == 0) {
                    yield true;
                }
                yield false;
            }
            case Stimulus.SACRIFICE -> {
                if (crucible.sacrificeCount >= 10) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean checkEndCrystal(CrucibleBlockEntity crucible) {
        Level level = crucible.m_58904_();
        if (crucible.linked_crystal != null && !crucible.linked_crystal.m_213877_()) {
            crucible.used_crystal_this_cycle = true;
            return true;
        }
        if (level.f_46443_) {
            return false;
        }
        if (((ServerLevel)level).m_8586_() != null) {
            return false;
        }
        int range = (Integer)ConfigMan.COMMON.crucibleRange.get();
        AABB aoe = new AABB(crucible.m_58899_().m_7918_(-range, -range, -range), crucible.m_58899_().m_7918_(range, range, range));
        List end_crystals = level.m_45976_(EndCrystal.class, aoe);
        if (end_crystals.isEmpty()) {
            return false;
        }
        ((EndCrystal)end_crystals.get(0)).m_31052_(crucible.m_58899_().m_6625_(2));
        crucible.linked_crystal = (EndCrystal)end_crystals.get(0);
        crucible.used_crystal_this_cycle = true;
        return true;
    }

    public void run(CrucibleBlockEntity crucible) {
        Level level = crucible.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        crucible.m_58904_().m_220407_(GameEvent.f_223702_, crucible.m_58899_(), GameEvent.Context.m_223722_((BlockState)crucible.m_58900_()));
        if (this.criterion != null) {
            FlagCriterion.triggerForNearbyPlayers(server, this.criterion, crucible.m_58899_(), 6);
        }
        if (this.perfect_criterion != null && (this.always_perfect || this.isPerfect(crucible))) {
            FlagCriterion.triggerForNearbyPlayers(server, this.perfect_criterion, crucible.m_58899_(), 6);
        }
    }

    public boolean isPerfect(CrucibleBlockEntity crucible) {
        return crucible.getPowerMap().keySet().size() == this.reagents.size();
    }

    public abstract void render(Level var1, CrucibleBlockEntity var2);

    public MutableComponent getName() {
        return this.name.m_6881_();
    }

    public String toString() {
        return this.reagents.toString();
    }

    public static enum Stimulus {
        NONE,
        GOLD_SYMBOL,
        ELECTRIC,
        NO_ELECTRIC,
        SACRIFICE,
        END_CRYSTAL,
        NO_END_CRYSTAL;

    }

    public static enum Status {
        STABLE,
        VOLATILE,
        MISSING_CATALYST,
        INHIBITED,
        POWER_TOO_WEAK,
        MISSING_STIMULUS,
        REACTING;

    }
}

