/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.advancements.FlagCriterion;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBearer;
import dev.hyperlynx.reactive.alchemy.PowerBottleInsertContext;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.recipes.PrecipitateRecipe;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import dev.hyperlynx.reactive.util.AreaMemory;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.FakeContainer;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class CrucibleBlockEntity
extends BlockEntity
implements PowerBearer {
    public static final int CRUCIBLE_MAX_POWER = 1600;
    private final HashMap<Power, Integer> powers = new HashMap();
    public AreaMemory areaMemory;
    private int tick_counter = 0;
    private int process_stage = 0;
    private int gather_stage = 0;
    public final Color mix_color = new Color();
    public boolean color_changed = true;
    private final Color next_mix_color = new Color();
    public boolean color_initialized = false;
    public int electricCharge = 0;
    public int sacrificeCount = 0;
    public int integrity = 100;
    public int enderRiftStrength = 0;
    public EndCrystal linked_crystal = null;
    public int render_tick_counter = 0;
    public List<Reaction> reactions_to_render = new LinkedList<Reaction>();
    public boolean used_crystal_this_cycle = false;
    public final SculkSpreader sculkSpreader = SculkSpreader.m_222254_();
    public List<ReactionStatusEntry> reaction_status = new ArrayList<ReactionStatusEntry>();

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CRUCIBLE_BE_TYPE.get(), pos, state);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.areaMemory = new AreaMemory(pos);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        try {
            ++crucible.tick_counter;
            if (!level.f_46443_ && crucible.enderRiftStrength > 0) {
                crucible.enderRiftStrength = SpecialCaseMan.tryTeleportNearbyEntity(crucible.m_58899_(), crucible.m_58904_(), crucible.m_58899_(), true) ? 0 : crucible.enderRiftStrength - 1;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5625 + level.f_46441_.m_188500_() * 2.0, (double)pos.m_123343_() + 0.5, 1, level.f_46441_.m_188583_(), 0.0, level.f_46441_.m_188583_(), 0.0);
            }
            if (crucible.tick_counter >= (Integer)ConfigMan.COMMON.crucibleTickDelay.get()) {
                crucible.tick_counter = 1;
                if (!((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
                    CrucibleBlockEntity.empty(level, pos, state, crucible);
                }
                switch (crucible.process_stage) {
                    case 0: {
                        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get()) && crucible.electricCharge < 15) {
                            crucible.electricCharge = 15;
                        } else if (crucible.electricCharge > 0) {
                            --crucible.electricCharge;
                        }
                        if (!level.m_5776_() && !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue() && crucible.areaMemory.existsAbove(crucible.f_58857_, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.WARP_SPONGE.get())) {
                            crucible.m_58904_().m_7731_(crucible.m_58899_(), (BlockState)level.m_8055_(crucible.m_58899_()).m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(true)), 2);
                            level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.6f, 1.0f);
                            level.m_220407_(GameEvent.f_157769_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        }
                        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.CURSE_CELL.get())) {
                            boolean hungers = true;
                            for (Power base_power : ReactionMan.BASE_POWER_LIST) {
                                if (crucible.getPowerLevel(base_power) <= 0) continue;
                                hungers = false;
                                crucible.expendPower(base_power, WorldSpecificValue.get("curse_cell_draw_rate:" + base_power.getId(), 16, 45));
                            }
                            ParticleScribe.drawParticleBox(level, (ParticleOptions)ParticleTypes.f_123783_, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos.m_7495_()), (double)1.0, (double)1.0, (double)1.0), 2);
                            if (hungers) {
                                --crucible.integrity;
                            }
                        } else if (crucible.integrity < 100 && crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 1) {
                            crucible.integrity += 2;
                        } else if (crucible.integrity < 100 && crucible.integrity > 10) {
                            crucible.integrity += Math.min(10, 100 - crucible.integrity);
                        } else if (crucible.integrity < 10) {
                            --crucible.integrity;
                        }
                        crucible.integrity = Math.min(crucible.integrity, 100);
                        break;
                    }
                    case 1: {
                        if (level.m_5776_() || !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) break;
                        CrucibleBlockEntity.gatherPower(level, crucible);
                        break;
                    }
                    case 2: {
                        if (level.m_5776_() || !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue() || crucible.integrity <= 70 || !CrucibleBlockEntity.processItemsInside(level, pos, state, crucible)) break;
                        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 0.65f + level.m_213780_().m_188501_() / 5.0f);
                        level.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        break;
                    }
                    case 3: {
                        if (!level.m_5776_() && ((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
                            CrucibleBlockEntity.react(level, crucible);
                        }
                        crucible.sculkSpreader.m_222255_((LevelAccessor)level, crucible.m_58899_(), level.f_46441_, true);
                        break;
                    }
                    case 4: {
                        CrucibleBlockEntity.checkIntegrity(level, pos, state, crucible);
                        crucible.setDirty();
                        crucible.process_stage = -1;
                        break;
                    }
                    default: {
                        System.err.println("Crucible ran out of steps! This can't be!");
                    }
                }
                ++crucible.process_stage;
            }
        }
        catch (Exception e) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.f_123792_, crucible.m_58899_());
            ReactiveMod.LOGGER.error("Encountered an unexpected error when ticking the crucible at {}: {}", (Object)crucible.m_58899_(), (Object)e);
            CrucibleBlockEntity.empty(level, pos, state, crucible);
        }
    }

    public int getTickCount() {
        return this.tick_counter;
    }

    private static void checkIntegrity(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (crucible.integrity < 70) {
            crucible.expendAnyPowerExcept(null, 1);
        }
        if (crucible.integrity < 50 && crucible.integrity > 10) {
            ParticleScribe.drawParticleRing(level, (ParticleOptions)Registration.RUNE_PARTICLE, pos, 0.7, 0.9, 1);
        }
        if (crucible.integrity < 20 && crucible.integrity > 12) {
            level.m_5594_(null, pos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.3f, 0.9f);
        }
        if (crucible.integrity == 10) {
            if (((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
                crucible.addPower((Power)Powers.MIND_POWER.get(), 23);
            }
            level.m_5594_(null, pos, SoundEvents.f_11738_, SoundSource.BLOCKS, 0.2f, 0.9f);
            level.m_220407_(GameEvent.f_157812_, pos, GameEvent.Context.m_223722_((BlockState)state));
            --crucible.integrity;
        } else if (crucible.integrity == 2) {
            level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, 0.9f);
            level.m_220407_(GameEvent.f_157812_, pos, GameEvent.Context.m_223722_((BlockState)state));
        } else if (crucible.integrity == 1) {
            level.m_5594_(null, pos, SoundEvents.f_11909_, SoundSource.BLOCKS, 1.0f, 0.9f);
            level.m_220407_(GameEvent.f_157812_, pos, GameEvent.Context.m_223722_((BlockState)state));
        } else if (crucible.integrity < 1) {
            CrucibleBlockEntity.empty(level, pos, state, crucible);
            CrucibleBlockEntity.integrityFail(level, pos, state);
        }
    }

    public static void integrityFail(Level level, BlockPos pos, BlockState state) {
        ParticleScribe.drawParticleRing(level, (ParticleOptions)Registration.RUNE_PARTICLE, pos, 0.7, 0.9, 20);
        level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.BLOCKS, 1.15f, 0.8f);
        level.m_254849_(null, Vec3.m_82512_((Vec3i)pos).f_82479_, Vec3.m_82512_((Vec3i)pos).f_82480_, Vec3.m_82512_((Vec3i)pos).f_82481_, 0.1f, Level.ExplosionInteraction.NONE);
        if (state.m_60734_().equals(Registration.SHULKER_CRUCIBLE.get())) {
            ItemEntity dropped_shell = new ItemEntity(level, Vec3.m_82512_((Vec3i)pos).f_82479_, Vec3.m_82512_((Vec3i)pos).f_82480_, Vec3.m_82512_((Vec3i)pos).f_82481_, Items.f_42748_.m_7968_());
            level.m_7967_((Entity)dropped_shell);
        }
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            FlagCriterion.triggerForNearbyPlayers(slevel, CriteriaTriggers.SEE_CRUCIBLE_FAIL_TRIGGER, pos, 24);
        }
        if (((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
            level.m_7731_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 2);
        } else {
            level.m_7731_(pos, Blocks.f_50256_.m_49966_(), 2);
        }
    }

    public static void insertPowerBottle(CrucibleBlockEntity crucible, PowerBottleInsertContext context) {
        boolean changed = false;
        for (Power p : Powers.POWER_SUPPLIER.get()) {
            if (!p.matchesBottle(context.getBottle()) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
            if (context.getBottle().m_150930_((Item)Registration.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(context.getBottle())) {
                crucible.enderRiftStrength = 2000;
            }
            context.reduceByOne();
            changed = true;
        }
        if (changed) {
            crucible.setDirty();
            crucible.m_58904_().m_5594_(null, crucible.m_58899_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.m_58904_().m_213780_().m_188501_() / 5.0f);
            crucible.m_58904_().m_220407_(GameEvent.f_157816_, crucible.m_58899_(), GameEvent.Context.m_223722_((BlockState)crucible.m_58900_()));
        }
    }

    public static void empty(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 400) {
            crucible.expendPower((Power)Powers.ASTRAL_POWER.get(), crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) / 2);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(true)), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            return;
        }
        if (crucible.getTotalPowerLevel() > 0) {
            SpecialCaseMan.checkEmptySpecialCases(crucible);
            crucible.expendPower();
            crucible.resetColor();
            crucible.setDirty(level, pos, state);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        if (crucible.linked_crystal != null) {
            crucible.unlinkCrystal(level, pos, state);
        }
        crucible.sculkSpreader.m_222284_();
        crucible.reaction_status.clear();
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
    }

    public void unlinkCrystal(Level level, BlockPos pos, BlockState state) {
        this.linked_crystal.m_31052_(null);
        this.linked_crystal = null;
        this.setDirty(level, pos, state);
    }

    private static void gatherPower(Level level, CrucibleBlockEntity crucible) {
        if (crucible.areaMemory.exists(level, (Block)Registration.COPPER_SYMBOL.get()) && !crucible.areaMemory.exists(level, (Block)Registration.IRON_SYMBOL.get())) {
            switch (crucible.gather_stage) {
                case 0: {
                    if (!crucible.areaMemory.exists(level, Blocks.f_50142_) || crucible.getTotalPowerLevel() <= 400) break;
                    if (crucible.getPowerLevel((Power)Powers.MIND_POWER.get()) > 1300) {
                        BlockPos portal_pos = crucible.areaMemory.fetch(crucible.f_58857_, Blocks.f_50142_);
                        SpecialCaseMan.solidifyPortal(crucible.f_58857_, portal_pos, (Direction.Axis)crucible.f_58857_.m_8055_(portal_pos).m_61143_((Property)NetherPortalBlock.f_54904_));
                        crucible.f_58857_.m_5594_(null, portal_pos, SoundEvents.f_12644_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_220407_(GameEvent.f_157812_, crucible.m_58899_(), GameEvent.Context.m_223722_((BlockState)crucible.m_58900_()));
                    }
                    crucible.expendAnyPowerExcept(null, 400);
                    FlagCriterion.triggerForNearbyPlayers((ServerLevel)level, CriteriaTriggers.PORTAL_TRADE_TRIGGER, crucible.m_58899_(), (Integer)ConfigMan.COMMON.crucibleRange.get());
                    break;
                }
                case 1: {
                    if (!crucible.areaMemory.exists(level, (Block)Registration.BLAZE_ROD.get())) break;
                    crucible.addPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("blaze_rod_power_amount", 35, 50));
                    FlagCriterion.triggerForNearbyPlayers((ServerLevel)level, CriteriaTriggers.SEE_BLAZE_GATHER_TRIGGER, crucible.m_58899_(), (Integer)ConfigMan.COMMON.crucibleRange.get());
                    break;
                }
                case 2: {
                    if (!crucible.areaMemory.exists(level, Blocks.f_50489_)) break;
                    crucible.addPower((Power)Powers.LIGHT_POWER.get(), WorldSpecificValue.get("end_rod_power_amount", 100, 300));
                    break;
                }
                case 3: {
                    if (crucible.areaMemory.exists(level, (Block)Registration.OCCULT_SYMBOL.get()) || crucible.areaMemory.exists(level, Blocks.f_50312_) || crucible.areaMemory.exists(level, Blocks.f_50313_)) {
                        crucible.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("wither_skull_power_amount", 50, 400));
                    }
                    if (!crucible.areaMemory.exists(level, (Block)Registration.DIVINE_SYMBOL.get())) break;
                    crucible.expendPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("divine_cleanse_amount", 200, 400));
                    break;
                }
                case 4: {
                    Optional maybe_conduit;
                    if (!crucible.areaMemory.exists(level, Blocks.f_50569_) || !(maybe_conduit = level.m_141902_(crucible.areaMemory.fetch(level, Blocks.f_50569_), BlockEntityType.f_58941_)).isPresent() || !((ConduitBlockEntity)maybe_conduit.get()).m_59216_()) break;
                    if (WorldSpecificValues.CONDUIT_POWER.get() == 1) {
                        crucible.addPower((Power)Powers.SOUL_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                        break;
                    }
                    crucible.addPower((Power)Powers.WARP_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                    break;
                }
                case 5: {
                    if (crucible.enderRiftStrength > 0) {
                        crucible.addPower((Power)Powers.WARP_POWER.get(), 10);
                    }
                    crucible.gather_stage = -1;
                }
            }
            ++crucible.gather_stage;
        }
        if (level.m_45527_(crucible.m_58899_())) {
            if (level.m_46758_(crucible.m_58899_())) {
                crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), 80);
            } else if (level.m_46468_() > 5900L && level.m_46468_() < 6100L) {
                crucible.addPower((Power)Powers.LIGHT_POWER.get(), 5);
                ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123810_, crucible.m_58899_(), crucible.m_58899_().m_6630_(15), 5, 0.0);
            }
        }
    }

    private static void react(Level level, CrucibleBlockEntity crucible) {
        crucible.used_crystal_this_cycle = false;
        crucible.reaction_status.clear();
        for (Reaction r : ReactiveMod.REACTION_MAN.getReactions()) {
            Reaction.Status reaction_status = r.conditionsMet(crucible);
            if (reaction_status == Reaction.Status.REACTING) {
                r.run(crucible);
                crucible.setDirty();
            }
            if (reaction_status == Reaction.Status.STABLE) continue;
            crucible.reaction_status.add(ReactionStatusEntry.of(reaction_status.toString(), r.getAlias()));
        }
        if (crucible.reaction_status.isEmpty()) {
            crucible.reaction_status.add(ReactionStatusEntry.stable());
        }
        if (!crucible.used_crystal_this_cycle && crucible.linked_crystal != null) {
            crucible.unlinkCrystal(level, crucible.m_58899_(), crucible.m_58900_());
        }
    }

    private static boolean processItemsInside(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (!((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
            return false;
        }
        boolean changed = false;
        for (Entity entity_inside : CrucibleBlock.getEntitesInside(pos, level)) {
            if (!(entity_inside instanceof ItemEntity)) continue;
            ItemEntity item_entity = (ItemEntity)entity_inside;
            SpecialCaseMan.checkDissolveSpecialCases(crucible, item_entity);
            CrucibleBlockEntity.insertPowerBottle(crucible, new PowerBottleInsertContext(item_entity));
            if (!item_entity.m_6084_()) continue;
            changed = changed || CrucibleBlockEntity.tryTransmute(level, pos, state, crucible, (ItemEntity)entity_inside);
            boolean bl = changed = changed || CrucibleBlockEntity.tryReduceToPower(item_entity.m_32055_(), crucible);
            if (item_entity.m_32055_().m_41613_() != 0) continue;
            item_entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        changed = changed || CrucibleBlockEntity.tryPrecipitate(level, pos, state, crucible);
        return changed;
    }

    public static boolean tryReduceToPower(ItemStack stack, CrucibleBlockEntity crucible) {
        List<Power> stack_power_list = Power.getSourcePower(stack);
        boolean changed = false;
        if (stack_power_list.isEmpty()) {
            boolean dissolved = CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.m_58904_()), crucible.m_58899_(), stack, stack.m_41613_(), crucible);
            if (dissolved) {
                stack.m_41764_(0);
            }
            return false;
        }
        for (Power p : stack_power_list) {
            int dissolve_capacity = (1600 - crucible.getPowerLevel(p)) / Power.getSourceLevel(stack);
            if (dissolve_capacity <= 0) continue;
            changed = changed || crucible.addPower(p, stack.m_41613_() * Power.getSourceLevel(stack) / stack_power_list.size());
            CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.m_58904_()), crucible.m_58899_(), stack, Math.min(stack.m_41613_(), dissolve_capacity), crucible);
            stack.m_41764_(Math.max(stack.m_41613_() - dissolve_capacity, 0));
        }
        return changed;
    }

    private static boolean tryDissolveWithByproduct(Level level, BlockPos pos, ItemStack stack, int count, CrucibleBlockEntity crucible) {
        List purify_recipes = level.m_7465_().m_44013_((RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get());
        for (DissolveRecipe r : purify_recipes) {
            if (r.needs_electricity && crucible.electricCharge < 1 || !r.m_5818_(new FakeContainer(stack), level)) continue;
            ItemStack reactant = stack.m_41777_();
            reactant.m_41764_(count);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, r.m_5874_(new FakeContainer(reactant), level.m_9598_())));
            return true;
        }
        return false;
    }

    private static boolean tryTransmute(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible, ItemEntity itemEntity) {
        List purify_recipes = level.m_7465_().m_44013_((RecipeType)Registration.TRANS_RECIPE_TYPE.get());
        for (TransmuteRecipe r : purify_recipes) {
            if (r.needs_electricity && crucible.electricCharge < 1 || !r.m_5818_(new FakeContainer(itemEntity.m_32055_()), level) || !r.powerMet(crucible)) continue;
            ItemStack result = r.apply(itemEntity.m_32055_(), crucible);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    private static boolean tryPrecipitate(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        List creation_recipes = level.m_7465_().m_44013_((RecipeType)Registration.PRECIPITATE_RECIPE_TYPE.get());
        for (PrecipitateRecipe r : creation_recipes) {
            if (r.needs_electricity && crucible.electricCharge < 1 || !r.powerMet(crucible, level)) continue;
            ItemStack result = r.apply(crucible, level);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    @Override
    public void setDirty() {
        this.setDirty(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
    }

    public void beHitByLightning() {
        this.electricCharge = 50;
        this.setDirty();
    }

    public void m_7651_() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        super.m_7651_();
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (this.m_58904_() == null || !((Boolean)this.m_58900_().m_61143_((Property)CrucibleBlock.FULL)).booleanValue() || event.getEntity().m_9236_().f_46443_ || Objects.requireNonNull(this.m_58904_()).f_46443_) {
            return;
        }
        double dist = BeamHelper.distance(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        if (dist > (double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue() || this.areaMemory.exists(event.getEntity().m_9236_(), (Block)Registration.IRON_SYMBOL.get())) {
            return;
        }
        if (event.getEntity().m_6336_().equals(MobType.f_21641_)) {
            if (!event.getSource().m_276093_(DamageTypes.f_268468_) && !event.getSource().m_276093_(DamageTypes.f_268631_)) {
                this.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("undead_curse_strength", 30, 300));
            }
            return;
        }
        ++this.sacrificeCount;
        FlagCriterion.triggerForNearbyPlayers((ServerLevel)event.getEntity().m_9236_(), CriteriaTriggers.SEE_SACRIFICE_TRIGGER, this.m_58899_(), 8);
        double x = event.getEntity().m_20185_();
        double y = event.getEntity().m_20186_();
        double z = event.getEntity().m_20189_();
        if (this.getPowerLevel((Power)Powers.CURSE_POWER.get()) >= WorldSpecificValues.CURSE_RATE.get() && this.getPowerLevel((Power)Powers.MIND_POWER.get()) > 0 && !(event.getEntity() instanceof Phantom) && event.getEntity().m_9236_().m_46462_()) {
            this.spawnPhantom(x, y, z);
        } else {
            ParticleScribe.drawParticleLine(this.f_58857_, (ParticleOptions)ParticleTypes.f_123796_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.4, (double)this.m_58899_().m_123343_() + 0.5, x, y, z, 15, 0.3);
        }
        int best_sacrifice_type = WorldSpecificValues.BEST_SACRIFICE.get();
        int power = best_sacrifice_type == 1 && event.getEntity() instanceof Animal ? WorldSpecificValue.get("strong_sacrifice", 200, 400) : (best_sacrifice_type == 2 && event.getEntity() instanceof AbstractVillager ? WorldSpecificValue.get("strong_sacrifice", 400, 500) : (best_sacrifice_type == 3 && (event.getEntity() instanceof AbstractPiglin || event.getEntity() instanceof Hoglin) ? WorldSpecificValue.get("strong_sacrifice", 450, 500) : (best_sacrifice_type == 4 && event.getEntity() instanceof Monster ? WorldSpecificValue.get("strong_sacrifice", 200, 600) : WorldSpecificValue.get("weak_sacrifice_" + event.getEntity().m_20078_(), 60, 120))));
        this.addPower((Power)Powers.VITAL_POWER.get(), power);
        this.setDirty();
    }

    private void spawnPhantom(double x, double y, double z) {
        Phantom p = new Phantom(EntityType.f_20509_, Objects.requireNonNull(this.m_58904_()));
        p.m_146884_(new Vec3(x, y + 2.0, z));
        p.m_33108_(this.m_58904_().f_46441_.m_216339_(2, 4));
        this.m_58904_().m_7967_((Entity)p);
        ParticleScribe.drawParticleLine(this.f_58857_, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, x, y + 2.0, z, 25, 0.1);
    }

    @Override
    @NotNull
    public Map<Power, Integer> getPowerMap() {
        return this.powers;
    }

    public void setDirty(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            this.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    @Override
    public boolean addPower(Power p, int amount) {
        int prev;
        if (p == null) {
            return false;
        }
        if (this.getPowerLevel(p) == 1600) {
            return false;
        }
        if (this.getTotalPowerLevel() + amount > 1600) {
            int excess = this.getTotalPowerLevel() + amount - 1600;
            this.expendAnyPowerExcept(p, excess);
            excess = this.getTotalPowerLevel() + amount - 1600;
            if (excess > 0) {
                amount -= excess;
            }
        }
        if ((prev = this.powers.getOrDefault(p, 0).intValue()) > 0) {
            this.powers.replace(p, amount + prev);
        } else {
            this.powers.put(p, amount);
        }
        return true;
    }

    @Override
    public int getPowerLevel(Power t) {
        if (this.powers.isEmpty() || this.powers.get(t) == null) {
            return 0;
        }
        return this.powers.get(t);
    }

    @Override
    public boolean expendPower(Power t, int amount) {
        if (this.powers.isEmpty() || !this.powers.containsKey(t)) {
            return false;
        }
        int level = this.powers.get(t);
        if (level > amount) {
            this.powers.put(t, level - amount);
            return true;
        }
        if (level == amount) {
            this.powers.put(t, 0);
            return true;
        }
        this.powers.put(t, 0);
        return false;
    }

    @Override
    public void expendAnyPowerExcept(Power immune_power, int amount) {
        boolean expended = false;
        for (Power p : this.powers.keySet()) {
            if (p != immune_power && p != Powers.CURSE_POWER.get()) {
                expended = this.expendPower(p, amount);
            }
            if (!expended) continue;
            return;
        }
    }

    @Override
    public void expendPower() {
        this.powers.clear();
        this.color_changed = true;
        this.mix_color.reset();
        this.next_mix_color.reset();
        this.color_initialized = false;
    }

    @Override
    public int getTotalPowerLevel() {
        int totalpp = 0;
        if (this.powers == null) {
            return 0;
        }
        for (Power p : this.powers.keySet()) {
            totalpp += this.powers.get(p).intValue();
        }
        return totalpp;
    }

    public void setStartingColor(Color starting) {
        this.mix_color.set(starting);
        this.color_initialized = true;
    }

    @Override
    public Color getCombinedColor(int water_color_number) {
        Color water_color = new Color(water_color_number);
        if (this.powers == null || this.powers.isEmpty() || this.getTotalPowerLevel() == 0) {
            return water_color;
        }
        if (this.color_changed) {
            this.updateColor(water_color);
        }
        if (!this.color_initialized) {
            this.mix_color.set(water_color);
            this.color_initialized = true;
        }
        if (!this.mix_color.equals(this.next_mix_color)) {
            int delta_red = Math.min(Math.abs(this.next_mix_color.red - this.mix_color.red), 2);
            int delta_green = Math.min(Math.abs(this.next_mix_color.green - this.mix_color.green), 2);
            int delta_blue = Math.min(Math.abs(this.next_mix_color.blue - this.mix_color.blue), 2);
            this.mix_color.red = this.next_mix_color.red > this.mix_color.red ? this.mix_color.red + delta_red : this.mix_color.red - delta_red;
            this.mix_color.green = this.next_mix_color.green > this.mix_color.green ? this.mix_color.green + delta_green : this.mix_color.green - delta_green;
            this.mix_color.blue = this.next_mix_color.blue > this.mix_color.blue ? this.mix_color.blue + delta_blue : this.mix_color.blue - delta_blue;
        }
        return this.mix_color;
    }

    private void updateColor(Color water_color) {
        if (this.powers == null) {
            return;
        }
        this.next_mix_color.reset();
        for (Power p : this.powers.keySet()) {
            if (p == null || p.invisible) continue;
            Color pow_color = p.getColor();
            float pow_weight = (float)this.getPowerLevel(p) / (float)this.getTotalVisiblePowerLevel();
            this.next_mix_color.red = (int)((float)this.next_mix_color.red + (float)pow_color.red * pow_weight);
            this.next_mix_color.green = (int)((float)this.next_mix_color.green + (float)pow_color.green * pow_weight);
            this.next_mix_color.blue = (int)((float)this.next_mix_color.blue + (float)pow_color.blue * pow_weight);
        }
        float tint_alpha = (float)this.getTotalVisiblePowerLevel() / 1600.0f;
        this.next_mix_color.red = (int)((float)water_color.red * (1.0f - tint_alpha) + (float)this.next_mix_color.red * tint_alpha);
        this.next_mix_color.green = (int)((float)water_color.green * (1.0f - tint_alpha) + (float)this.next_mix_color.green * tint_alpha);
        this.next_mix_color.blue = (int)((float)water_color.blue * (1.0f - tint_alpha) + (float)this.next_mix_color.blue * tint_alpha);
        this.color_changed = false;
    }

    private int getTotalVisiblePowerLevel() {
        int totalpp = 0;
        for (Power p : this.powers.keySet()) {
            if (p.invisible) continue;
            totalpp += this.powers.get(p).intValue();
        }
        return totalpp;
    }

    private void resetColor() {
        this.color_changed = true;
        this.color_initialized = false;
        this.mix_color.reset();
        this.next_mix_color.reset();
    }

    public float getOpacity() {
        return 0.7f + 0.3f * (float)this.getTotalVisiblePowerLevel() / 1600.0f;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.color_changed = true;
    }

    protected void m_183515_(@NotNull CompoundTag main_tag) {
        super.m_183515_(main_tag);
        main_tag.m_128365_("electric_charge", (Tag)IntTag.m_128679_((int)this.electricCharge));
        main_tag.m_128365_("integrity", (Tag)IntTag.m_128679_((int)this.integrity));
        if (this.linked_crystal != null) {
            main_tag.m_128365_("LinkedCrystal", (Tag)NbtUtils.m_129226_((UUID)this.linked_crystal.m_20148_()));
        }
        if (this.powers == null || this.powers.isEmpty()) {
            return;
        }
        ListTag power_list_tag = new ListTag();
        for (Power p : this.powers.keySet()) {
            if (p == null) {
                System.err.println("Skipping null power in save process.");
                continue;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("name", (Tag)StringTag.m_129297_((String)p.getResourceLocation().toString()));
            tag.m_128365_("level", (Tag)IntTag.m_128679_((int)this.getPowerLevel(p)));
            power_list_tag.add((Object)tag);
        }
        main_tag.m_128365_("powers", (Tag)power_list_tag);
        this.sculkSpreader.m_222275_(main_tag);
    }

    public void m_142466_(@NotNull CompoundTag main_tag) {
        Object object;
        super.m_142466_(main_tag);
        if (main_tag.m_128441_("LinkedCrystal") && (object = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)object;
            UUID crystal_uuid = main_tag.m_128342_("LinkedCrystal");
            Entity entity = server.m_8791_(crystal_uuid);
            if (entity instanceof EndCrystal) {
                EndCrystal crystal;
                this.linked_crystal = crystal = (EndCrystal)entity;
            }
        } else {
            this.linked_crystal = null;
        }
        ListTag power_list_tag = (ListTag)main_tag.m_128423_("powers");
        this.powers.clear();
        if (power_list_tag != null && !power_list_tag.isEmpty()) {
            for (Tag power_tag : power_list_tag) {
                Power p = Power.readPower((CompoundTag)power_tag);
                this.addPower(p, ((CompoundTag)power_tag).m_128451_("level"));
            }
        } else {
            this.resetColor();
        }
        this.electricCharge = main_tag.m_128451_("electric_charge");
        if (main_tag.m_128441_("integrity")) {
            this.integrity = main_tag.m_128451_("integrity");
        }
        this.sculkSpreader.m_222269_(main_tag);
    }
}

