/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.blocks.MnemonicBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class MnemonicBlockEntity
extends BlockEntity {
    List<OutputStep> memory = new ArrayList<OutputStep>();
    int index = 0;
    int counter = 0;
    Status status = Status.EMPTY;
    public static final int MAX_SIGNAL_DURATION = 600;
    public static final int MAX_SEQUENCE_LENGTH = 256;
    public static final String MEMORY_TAG = "Memory";
    public static final String INDEX_TAG = "RecordingIndex";
    public static final String COUNTER_TAG = "PlaybackCounter";
    public static final String STATUS_TAG = "Status";

    public MnemonicBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.MNEMONIC_BULB_BE_TYPE.get(), pPos, pBlockState);
    }

    public void performTick(Level level, BlockPos pos, BlockState state) {
        if (this.status != Status.REPLAYING && (Integer)state.m_61143_((Property)MnemonicBlock.POWER) > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MnemonicBlock.POWER, (Comparable)Integer.valueOf(0)), 3);
        }
        int input = level.m_277173_(pos);
        switch (this.status) {
            case EMPTY: {
                if (input == 0) {
                    return;
                }
                this.index = 0;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                this.status = Status.RECORDING;
                break;
            }
            case RECORDING: {
                if (!this.memory.isEmpty() && this.memory.get((int)(this.memory.size() - 1)).signal == input) {
                    this.memory.get(this.memory.size() - 1).increment();
                } else {
                    if (this.memory.size() >= 256) {
                        this.memory.remove(0);
                    }
                    this.memory.add(new OutputStep(input));
                }
                if (((Boolean)state.m_61143_((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    this.index = 0;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    this.status = Status.REPLAYING;
                }
                if (this.memory.get((int)(this.memory.size() - 1)).duration <= 600) break;
                if (input == 0) {
                    this.status = Status.DISABLED;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    break;
                }
                this.memory.add(new OutputStep(input));
                break;
            }
            case DISABLED: {
                if (((Boolean)state.m_61143_((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    this.index = 0;
                    this.status = Status.REPLAYING;
                    break;
                }
                if (input <= 0) break;
                this.memory.clear();
                this.status = Status.EMPTY;
                break;
            }
            case REPLAYING: {
                if (!((Boolean)state.m_61143_((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MnemonicBlock.POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    this.status = Status.DISABLED;
                }
                this.index %= this.memory.size();
                OutputStep output = this.memory.get(this.index);
                if (this.counter < 1) {
                    level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MnemonicBlock.POWER, (Comparable)Integer.valueOf(output.signal))).m_61124_((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(output.signal > 0)), 3);
                    level.m_5594_(null, pos, output.signal > 0 ? SoundEvents.f_244181_ : SoundEvents.f_244533_, SoundSource.BLOCKS, 1.3f, 0.5f + (float)(output.signal + 1) / 54.0f);
                    level.m_5594_(null, pos, SoundEvents.f_215710_, SoundSource.BLOCKS, 0.1f, 0.7f + (float)(output.signal + 1) / 54.0f);
                    level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
                    this.counter = output.duration;
                    ++this.index;
                }
                --this.counter;
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MnemonicBlockEntity bulb) {
        bulb.performTick(level, pos, state);
    }

    public boolean hasMemory() {
        return !this.memory.isEmpty();
    }

    public void stopRecording() {
        if (this.status.equals((Object)Status.RECORDING)) {
            this.status = Status.DISABLED;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag memory_list = new ListTag();
        memory_list.addAll(this.memory.stream().map(OutputStep::save).toList());
        tag.m_128365_(MEMORY_TAG, (Tag)memory_list);
        tag.m_128365_(INDEX_TAG, (Tag)IntTag.m_128679_((int)this.index));
        tag.m_128365_(COUNTER_TAG, (Tag)IntTag.m_128679_((int)this.counter));
        tag.m_128365_(STATUS_TAG, (Tag)StringTag.m_129297_((String)this.status.name()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag memory_list = tag.m_128437_(MEMORY_TAG, 10);
        this.memory = new ArrayList<OutputStep>(memory_list.stream().map(OutputStep::load).toList());
        this.index = tag.m_128451_(INDEX_TAG);
        this.counter = tag.m_128451_(COUNTER_TAG);
        this.status = Status.valueOf(tag.m_128461_(STATUS_TAG));
    }

    static enum Status {
        EMPTY,
        RECORDING,
        REPLAYING,
        DISABLED;

    }

    static class OutputStep {
        public int signal;
        public int duration;

        public OutputStep(int signal) {
            this.signal = signal;
            this.duration = 1;
        }

        public static OutputStep load(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                System.err.println("The mnemonic tag was not a compound tag! Oh no!");
                return null;
            }
            CompoundTag compound = (CompoundTag)tag;
            OutputStep ret = new OutputStep(compound.m_128451_("signal"));
            ret.duration = compound.m_128451_("duration");
            return ret;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("signal", (Tag)IntTag.m_128679_((int)this.signal));
            tag.m_128365_("duration", (Tag)IntTag.m_128679_((int)this.duration));
            return tag;
        }

        public void increment() {
            ++this.duration;
        }
    }
}

