/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SymbolBlockEntity
extends BlockEntity {
    public Direction facing = Direction.DOWN;
    public Item symbol_item = Items.f_42127_;

    public SymbolBlockEntity(BlockPos pos, BlockState state, Item item) {
        super((BlockEntityType)Registration.SYMBOL_BE_TYPE.get(), pos, state);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setItem(item);
    }

    public SymbolBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.SYMBOL_BE_TYPE.get(), pos, state);
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public void setItem(Item item) {
        this.symbol_item = item;
    }

    public CompoundTag serializeNBT() {
        return null;
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || !this.symbol_item.m_7968_().m_150930_((Item)Registration.OCCULT_SYMBOL_ITEM.get()) || !(event.getEntity() instanceof Player)) {
            return;
        }
        double dist = BeamHelper.distance(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        if (dist > (double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue()) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        if (level.m_8055_(this.m_58899_()).m_60795_()) {
            return;
        }
        level.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 2);
        level.m_5594_(null, this.m_58899_(), SoundEvents.f_11738_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.1f);
        if (WorldSpecificValue.getBool("occult_death_spawn_zombie", 0.5f)) {
            Zombie zombie = new Zombie(level);
            zombie.m_146884_(event.getEntity().m_20318_(0.0f));
            zombie.m_6593_(event.getEntity().m_5446_());
            zombie.m_20340_(true);
            level.m_7967_((Entity)zombie);
        } else {
            Skeleton skeleton = new Skeleton(EntityType.f_20524_, level);
            skeleton.m_146884_(event.getEntity().m_20318_(0.0f));
            skeleton.m_6593_(event.getEntity().m_5446_());
            skeleton.m_20340_(true);
            level.m_7967_((Entity)skeleton);
        }
        for (int i = 0; i < 4; ++i) {
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.SMALL_BLACK_RUNE_PARTICLE, this.m_58899_(), event.getEntity().m_20183_().m_7494_(), 5, 4, 0.7);
        }
    }
}

