/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface ChainDisplacingBlock {
    public boolean stateMatchesSelf(BlockState var1);

    default public void breadthFirstDisplace(Level level, BlockPos source, boolean displace_surroundings) {
        this.breadthFirstDisplace(level, source, displace_surroundings, 20);
    }

    default public void breadthFirstDisplace(Level level, BlockPos source, boolean displace_surroundings, int displace_time) {
        int max = (Integer)ConfigMan.COMMON.maxDisplaceCount.get();
        ArrayDeque<BlockPos> displace_queue = new ArrayDeque<BlockPos>();
        displace_queue.add(source);
        int count = 0;
        BlockPos prior = null;
        while (!displace_queue.isEmpty()) {
            BlockPos target = (BlockPos)displace_queue.poll();
            boolean found_child = false;
            if (count <= max) {
                ArrayList<Direction> shuffled_directions = new ArrayList<Direction>(List.of(Direction.values()));
                Collections.shuffle(shuffled_directions);
                for (Direction direction : shuffled_directions) {
                    BlockPos next_target = target.m_121945_(direction);
                    if (displace_queue.contains(next_target) || !level.m_46749_(next_target)) continue;
                    BlockPos conduct_start = next_target;
                    while (level.m_8055_(next_target).m_204336_(AlchemyTags.displaceConductive) && next_target.m_123314_((Vec3i)conduct_start, (double)((Integer)ConfigMan.COMMON.displaceConductRange.get()).intValue())) {
                        next_target = next_target.m_121945_(direction);
                    }
                    if (this.stateMatchesSelf(level.m_8055_(next_target))) {
                        displace_queue.add(next_target);
                        found_child = true;
                        ++count;
                        continue;
                    }
                    if (!displace_surroundings || level.m_8055_(next_target).m_60795_() || level.m_8055_(next_target).m_60713_((Block)Registration.VOLT_CELL.get()) || level.m_8055_(next_target).m_60713_((Block)Registration.DISPLACED_BLOCK.get())) continue;
                    DisplacedBlock.displaceWithChain(level.m_8055_(next_target), next_target, level, 2 + count, count, target);
                }
            }
            if (target.equals((Object)source)) {
                DisplacedBlock.displace(level.m_8055_(target), target, level, displace_time);
            } else if (source != null) {
                DisplacedBlock.displaceWithChain(level.m_8055_(target), target, level, 2 + count, count, prior);
            } else {
                DisplacedBlock.displace(level.m_8055_(target), target, level, 10 + count);
            }
            if (!found_child) continue;
            prior = target;
        }
    }
}

