/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.blocks.SymbolBlock;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OccultSymbolBlock
extends SymbolBlock {
    public static BooleanProperty ACTIVE = BlockStateProperties.f_61431_;

    public OccultSymbolBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.PLACE_OCCULT_TRIGGER.trigger((ServerPlayer)entity);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return;
        }
        double d0 = source.m_188500_() * 8.0 - 4.0;
        double d1 = source.m_188500_() * 8.0 - 4.0;
        double d2 = source.m_188500_() * 8.0 - 4.0;
        level.m_7106_((ParticleOptions)Registration.SMALL_BLACK_RUNE_PARTICLE, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!player.m_21120_(hand).m_150930_((Item)Registration.QUARTZ_BOTTLE.get())) {
            return InteractionResult.PASS;
        }
        if (player.m_36335_().m_41519_((Item)Registration.QUARTZ_BOTTLE.get())) {
            return InteractionResult.PASS;
        }
        List<Item> bottle_list = List.of((Item)Registration.ACID_BOTTLE.get(), (Item)Registration.BODY_BOTTLE.get(), (Item)Registration.BLAZE_BOTTLE.get(), (Item)Registration.VERDANT_BOTTLE.get(), (Item)Registration.LIGHT_BOTTLE.get(), (Item)Registration.MIND_BOTTLE.get());
        int roll = level.f_46441_.m_216339_(0, 7);
        boolean bottle_broke = false;
        switch (roll) {
            case 0: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 1500, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 1500, 0));
                player.m_6469_(level.m_269111_().m_269425_(), Math.min(12.0f, player.m_21223_() - 1.0f));
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_acid"), true);
                break;
            }
            case 1: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1000, 1));
                player.m_36324_().m_38705_(Math.max(0, player.m_36324_().m_38702_() - 16));
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_body"), true);
                break;
            }
            case 2: {
                player.m_146917_(800);
                player.m_7311_(0);
                player.m_6469_(level.m_269111_().m_269109_(), Math.min(5.0f, player.m_21223_() - 1.0f));
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_blaze"), true);
                break;
            }
            case 3: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 800, 2));
                player.m_6469_(level.m_269111_().m_269425_(), 2.0f);
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_verdant"), true);
                break;
            }
            case 4: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 1500, 0));
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_light"), true);
                break;
            }
            case 5: {
                if (player.f_36078_ > 4) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer splayer = (ServerPlayer)player;
                        CriteriaTriggers.HARVEST_TRIGGER.trigger(splayer);
                    }
                    player.m_6749_(-4);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 150, 2));
                    player.m_5661_((Component)Component.m_237115_((String)"message.reactive.extract_mind"), true);
                    player.m_5496_(SoundEvents.f_11700_, 0.8f, 0.8f);
                    break;
                }
                bottle_broke = true;
                break;
            }
            default: {
                bottle_broke = true;
            }
        }
        ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.SMALL_BLACK_RUNE_PARTICLE, pos, player.m_20183_().m_7494_(), 5, 4, 0.7);
        player.m_21120_(hand).m_41774_(1);
        if (bottle_broke) {
            player.m_5661_((Component)Component.m_237115_((String)"message.reactive.bottle_broke"), true);
            player.m_6469_(level.m_269111_().m_269264_(), 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.PLAYERS, 0.5f, 1.0f);
        } else {
            ItemStack bottled_power = bottle_list.get(roll).m_7968_();
            player.m_36356_(bottled_power);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        if (!player.m_150110_().f_35937_) {
            player.m_36335_().m_41524_((Item)Registration.QUARTZ_BOTTLE.get(), 80);
        }
        return InteractionResult.SUCCESS;
    }
}

