/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ShulkerCrucibleBlock
extends CrucibleBlock {
    public ShulkerCrucibleBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    @NotNull
    private static ItemStack getDropStack(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        ItemStack drop_stack = ((Item)Registration.SHULKER_CRUCIBLE_ITEM.get()).m_7968_();
        if (crucible.getTotalPowerLevel() > 0) {
            crucible.m_187476_(drop_stack);
            drop_stack.m_41783_().m_128365_("Label", (Tag)StringTag.m_129297_((String)ShulkerCrucibleBlock.getItemLabel(crucible)));
        } else if (((Boolean)state.m_61143_((Property)FULL)).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.6f, 0.8f);
        }
        return drop_stack;
    }

    @Override
    public void onRemoveWithoutEmpty(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        super.onRemoveWithoutEmpty(state, level, pos, new_state, p_60519_);
    }

    private static String getItemLabel(CrucibleBlockEntity crucible) {
        StringBuilder label = new StringBuilder();
        for (Power p : crucible.getPowerMap().keySet()) {
            if (crucible.getPowerLevel(p) <= 0) continue;
            label.append(p.getName()).append(", ");
        }
        return label.substring(0, label.length() - 2);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        if (new_state.m_60713_((Block)Registration.SHULKER_CRUCIBLE.get())) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)be;
            if (!level.f_46443_) {
                ItemStack drop_stack = ShulkerCrucibleBlock.getDropStack(level, pos, state, crucible);
                ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop_stack);
                drop.m_32060_();
                level.m_7967_((Entity)drop);
            }
        }
        super.onRemoveWithoutEmpty(state, level, pos, new_state, p_60519_);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState old_state, boolean p_60570_) {
        BlockEntity recently_placed_be = level.m_7702_(pos);
        if (!(recently_placed_be instanceof CrucibleBlockEntity)) {
            return;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)recently_placed_be;
        if (old_state.m_60734_() instanceof ShulkerCrucibleBlock) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(crucible.getTotalPowerLevel() > 0)), 11);
    }
}

