/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.datagen;

import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.core.HolderLookup;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class ReactiveAdvancementGenerator
implements ForgeAdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
        String REACTION_ADVANCEMENT_PREFIX = ":reactions/";
        List<String> aliases = ReactionMan.CRITERIA_BUILDER.getAliases();
        for (String alias : aliases) {
            if (ReactionMan.CRITERIA_BUILDER.get(alias) == null) {
                System.err.println("Reaction " + alias + " doesn't have a criterion, so no advancement will be generated.");
                continue;
            }
            Advancement.Builder builder = Advancement.Builder.m_138353_();
            builder.m_138386_("criterion", (CriterionTriggerInstance)Objects.requireNonNull(ReactionMan.CRITERIA_BUILDER.get(alias)).createInstance(ContextAwarePredicate.f_285567_));
            builder.m_138360_(RequirementsStrategy.f_15978_);
            builder.m_138356_(AdvancementRewards.f_9978_);
            builder.m_138389_(consumer, "reactive" + REACTION_ADVANCEMENT_PREFIX + alias);
            if (ReactionMan.CRITERIA_BUILDER.get(alias + "_perfect") == null) {
                System.err.println("Reaction " + alias + " doesn't have a perfection criterion, so no perfection advancement will be generated.");
                continue;
            }
            Advancement.Builder perfect_builder = Advancement.Builder.m_138353_();
            perfect_builder.m_138386_("criterion", (CriterionTriggerInstance)Objects.requireNonNull(ReactionMan.CRITERIA_BUILDER.get(alias + "_perfect")).createInstance(ContextAwarePredicate.f_285567_));
            perfect_builder.m_138360_(RequirementsStrategy.f_15978_);
            perfect_builder.m_138356_(AdvancementRewards.f_9978_);
            perfect_builder.m_138389_(consumer, "reactive" + REACTION_ADVANCEMENT_PREFIX + alias + "_perfect");
        }
    }
}

