/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.integration.kubejs.CustomPower;
import dev.hyperlynx.reactive.integration.kubejs.KubeScriptException;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PowerBuilder
extends BuilderBase<Power> {
    public transient int color = 0xFFFFFF;
    public transient Supplier<Item> bottle;
    public transient Supplier<Item> render_item = () -> Items.f_42127_;
    public transient Supplier<Block> render_water_block;
    public transient boolean invisible = false;
    public transient MutableComponent custom_component = null;

    public PowerBuilder(ResourceLocation id) {
        super(id);
        this.bottle = () -> null;
        this.render_water_block = () -> Blocks.f_49990_;
    }

    public RegistryInfo<?> getRegistryType() {
        return ReactiveKubeJSPlugin.POWER_REGISTRY_INFO;
    }

    public Power createObject() {
        CustomPower power = new CustomPower(this.id, this.color, this.render_water_block, this.bottle, this.render_item);
        power.invisible = this.invisible;
        power.custom_component = this.custom_component;
        return power;
    }

    public PowerBuilder color(int color) {
        this.color = color;
        return this;
    }

    public PowerBuilder icon(ResourceLocation icon_id) {
        this.render_item = () -> this.getItem(icon_id, true);
        return this;
    }

    public PowerBuilder bottle(ResourceLocation bottle_id) {
        this.bottle = () -> this.getItem(bottle_id, false);
        return this;
    }

    public PowerBuilder setNormalWater() {
        this.render_water_block = () -> Blocks.f_49990_;
        return this;
    }

    public PowerBuilder setMagicWater() {
        this.render_water_block = Registration.DUMMY_MAGIC_WATER;
        return this;
    }

    public PowerBuilder setFastWater() {
        this.render_water_block = Registration.DUMMY_FAST_WATER;
        return this;
    }

    public PowerBuilder setNoiseWater() {
        this.render_water_block = Registration.DUMMY_NOISE_WATER;
        return this;
    }

    public PowerBuilder setCustomWater(Block water) {
        if (water.m_49966_().m_60713_(Blocks.f_50016_)) {
            throw new KubeScriptException("Power " + this.id + " has an invalid water block!");
        }
        this.render_water_block = () -> water;
        return this;
    }

    public PowerBuilder setInvisible() {
        this.invisible = true;
        return this;
    }

    public PowerBuilder setName(MutableComponent name) {
        this.custom_component = name;
        return this;
    }

    public Item getItem(ResourceLocation id, boolean barrier_if_invalid) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
        if (item == Items.f_41852_) {
            if (barrier_if_invalid) {
                return Items.f_42127_;
            }
            return null;
        }
        return item;
    }
}

