/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TransmuteComponentProcessor
implements IComponentProcessor {
    private TransmuteRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipeId = "reactive:transmutation/" + variables.get("recipe").asString();
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        List recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)Registration.TRANS_RECIPE_TYPE.get());
        for (TransmuteRecipe r : recipes) {
            if (!r.m_6423_().equals((Object)new ResourceLocation(recipeId))) continue;
            this.recipe = r;
            break;
        }
    }

    public IVariable process(Level level, @NotNull String key) {
        if (this.recipe != null && key.equals("reactant")) {
            return IVariable.from((Object)this.recipe.getReactant().m_43908_());
        }
        if (this.recipe != null && key.equals("product")) {
            return IVariable.from((Object)this.recipe.m_8043_(level.m_9598_()));
        }
        if (key.equals("reagents")) {
            if (this.recipe == null) {
                return IVariable.wrap((String)Component.m_237115_((String)"docs.reactive.removed_recipe").getString());
            }
            ArrayList<String> reagent_list = new ArrayList<String>();
            for (Power reagent : this.recipe.getReagents()) {
                reagent_list.add(reagent.getName());
            }
            return IVariable.wrap((String)(Component.m_237115_((String)"docs.reactive.reagent_label").getString() + ((Object)reagent_list).toString().substring(1, ((Object)reagent_list).toString().length() - 1)));
        }
        return null;
    }
}

