/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.recipes.PrecipitateRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrecipitateRecipeSerializer
implements RecipeSerializer<PrecipitateRecipe> {
    @NotNull
    public PrecipitateRecipe fromJson(@NotNull ResourceLocation id, JsonObject json) {
        ItemStack product = CraftingHelper.getItemStack((JsonObject)json.get("product").getAsJsonObject(), (boolean)false);
        ArrayList<Power> reagents = new ArrayList<Power>();
        for (JsonElement j : json.get("reagents").getAsJsonArray()) {
            RegistryObject powObj = RegistryObject.create((ResourceLocation)ResourceLocation.m_135820_((String)j.getAsString()), Powers.POWER_SUPPLIER.get());
            if (powObj.isPresent()) {
                reagents.add((Power)powObj.get());
                continue;
            }
            System.err.println("Tried to read a fake power " + j.getAsString() + " in recipe " + id);
        }
        int min = json.get("min").getAsInt();
        int cost = json.get("cost").getAsInt();
        int reagent_count = json.get("reagent_count").getAsInt();
        boolean needs_electricity = false;
        if (json.has("needs_electricity")) {
            needs_electricity = json.get("needs_electricity").getAsBoolean();
        }
        return new PrecipitateRecipe(id, "precipitation", product, reagents, min, cost, reagent_count, needs_electricity);
    }

    @Nullable
    public PrecipitateRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        ItemStack product = buffer.m_130267_();
        List reagents = (List)buffer.m_236838_(ArrayList::new, IForgeFriendlyByteBuf::readRegistryId);
        int min = buffer.readInt();
        int cost = buffer.readInt();
        int reagent_count = buffer.readInt();
        boolean needs_electricity = buffer.readBoolean();
        return new PrecipitateRecipe(id, "precipitation", product, reagents, min, cost, reagent_count, needs_electricity);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull PrecipitateRecipe recipe) {
        buffer.m_130055_(recipe.product);
        buffer.m_236828_(recipe.reagents, (b, p) -> b.writeRegistryId(Powers.POWER_SUPPLIER.get(), p));
        buffer.writeInt(recipe.minimum);
        buffer.writeInt(recipe.cost);
        buffer.writeInt(recipe.reagent_count);
        buffer.writeBoolean(recipe.needs_electricity);
    }
}

