/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide;

import com.li64.tide.Tide;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class TideForgeNetworking {
    private static SimpleChannel CHANNEL_INSTANCE;
    private static final ResourceLocation CHANNEL_ID;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void init() {
        CHANNEL_INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_ID).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    }

    public static <T> void registerPacket(Class<T> msgClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Player> handler, NetworkDirection direction) {
        CHANNEL_INSTANCE.messageBuilder(msgClass, TideForgeNetworking.id(), direction).decoder(decoder).encoder(encoder).consumerMainThread((msg, ctx) -> handler.accept((Object)msg, (Player)((NetworkEvent.Context)ctx.get()).getSender())).add();
    }

    public static <T> void sendToServer(T message) {
        CHANNEL_INSTANCE.sendToServer(message);
    }

    public static <T> void sendToPlayer(T msg, ServerPlayer player) {
        CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    static {
        CHANNEL_ID = Tide.resource("messages");
        packetId = 0;
    }
}

