/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.minigame;

import com.li64.tide.Tide;
import com.li64.tide.network.messages.MinigameClientMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.items.StrengthFish;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class FishCatchMinigame {
    public static ArrayList<FishCatchMinigame> ACTIVE_MINIGAMES = new ArrayList();
    protected TideFishingHook hook;
    protected ServerPlayer player;

    public static FishCatchMinigame getInstance(Player player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return minigame;
        }
        return null;
    }

    public static FishCatchMinigame create(Player player) {
        FishCatchMinigame existingInstance = FishCatchMinigame.getInstance(player);
        if (existingInstance != null) {
            return existingInstance;
        }
        FishCatchMinigame minigame = new FishCatchMinigame((ServerPlayer)player);
        ACTIVE_MINIGAMES.add(minigame);
        return minigame;
    }

    public static boolean minigameActive(Player player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    protected FishCatchMinigame(ServerPlayer player) {
        this.player = player;
        this.hook = Objects.requireNonNull(HookAccessor.getHook((Player)player));
        this.hook.setMinigameActive(true);
        float strength = 0.0f;
        Item item = this.hook.getHookedItem();
        if (item instanceof StrengthFish) {
            StrengthFish strengthFish = (StrengthFish)item;
            strength = strengthFish.getStrength();
        }
        if (this.hook.getHook().m_150930_(TideItems.IRON_FISHING_HOOK)) {
            strength *= 0.89f;
        }
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(0, strength), player);
    }

    private ServerPlayer getPlayer() {
        return this.player;
    }

    public void interact() {
        if (this.cancelIfNecessary()) {
            return;
        }
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(1), this.player);
    }

    public void onFinish() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.setMinigameActive(false);
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
        ACTIVE_MINIGAMES.remove(this);
    }

    public void onTimeout() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.onFinish();
    }

    public void onFail() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.invalidateCatch();
        this.hook.retrieve();
        this.onFinish();
    }

    public void onWin() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.retrieve();
        this.onFinish();
    }

    public boolean cancelIfNecessary() {
        if (this.hook == null || this.player == null) {
            Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
            ACTIVE_MINIGAMES.remove(this);
            return true;
        }
        return false;
    }

    public void handleClientEvent(byte event) {
        this.cancelIfNecessary();
        switch (event) {
            case 0: {
                this.onTimeout();
                break;
            }
            case 1: {
                this.onFail();
                break;
            }
            case 2: {
                this.onWin();
            }
        }
    }
}

