/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.events;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import com.li64.tide.network.messages.UpdateJournalMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.util.TideUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class TideEventHandler {
    public static void onEnterNether(ServerPlayer player) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage netherPage = TideUtils.getPageByName("nether");
        if (netherPage == null) {
            return;
        }
        if (!data.hasPageUnlocked(netherPage)) {
            data.unlockPage(netherPage);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((Component)Component.m_237115_((String)"newpage.toast.title"), TideUtils.getPageToastDesc(netherPage), TideUtils.getPageToastIcon(netherPage)), player);
            data.syncTo(player);
        }
    }

    public static void onPlayerJoinWorld(ServerPlayer player) {
        if (!Tide.CONFIG.general.giveJournal) {
            return;
        }
        Tide.NETWORK.sendToPlayer(new UpdateJournalMsg(), player);
        TidePlayerData playerData = TidePlayerData.getOrCreate(player);
        playerData.syncTo(player);
        if (!playerData.gotJournal && player.m_36356_(TideItems.FISHING_JOURNAL.m_7968_())) {
            playerData.gotJournal = true;
            playerData.syncTo(player);
        }
    }

    public static void updateFishingJournal(ServerPlayer player) {
        Inventory inventory = player.m_150109_();
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack stack = inventory.m_8020_(slot);
            if (!TideUtils.isJournalFish(stack)) continue;
            TidePlayerData data = TidePlayerData.getOrCreate(player);
            if (!data.hasFishUnlocked(stack)) {
                data.unlockFish(stack);
                Tide.NETWORK.sendToPlayer(new ShowToastMsg((Component)Component.m_237115_((String)"newfish.toast.title"), TideUtils.removeRawTextInName(stack.m_41786_()), stack.m_41720_().m_7968_()), player);
                data.syncTo(player);
            }
            List<JournalLayout.Page> pages = Tide.JOURNAL.getPageConfigs();
            pages.forEach(pageConfig -> {
                JournalPage page = new JournalPage((JournalLayout.Page)pageConfig);
                if (TideUtils.isInPage(page.idName(), stack)) {
                    TideUtils.unlockPage(player, page);
                    TideUtils.checkPageCompletion(data, page, player);
                }
            });
        }
    }
}

