/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.registries.entities.misc.fishing.TideFishingBobberLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TideFishingHookRenderer
extends EntityRenderer<TideFishingHook>
implements RenderLayerParent<TideFishingHook, TideFishingHookModel<TideFishingHook>> {
    private final TideFishingHookModel<TideFishingHook> model;
    private final TideFishingBobberLayer bobberLayer;
    private static final ResourceLocation HOOK_TEX_LOCATION = Tide.resource("textures/entity/fishing_hook/fishing_hook.png");

    public TideFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TideFishingHookModel(context.m_174023_(TideFishingHookModel.LAYER_LOCATION));
        this.bobberLayer = new TideFishingBobberLayer(this, context.m_174027_());
        this.f_114477_ = 0.1f;
    }

    public void render(TideFishingHook hookEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Player player = hookEntity.getPlayerOwner();
        if (player == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.03125f, 0.0f, 0.03125f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - hookEntity.getInitialYaw()));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(hookEntity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(hookEntity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.bobberLayer.render(poseStack, bufferSource, packedLight, hookEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
        this.renderConnectingString(hookEntity, partialTick, poseStack, bufferSource, player);
        poseStack.m_85849_();
        super.m_7392_((Entity)hookEntity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private void renderConnectingString(TideFishingHook hookEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, Player player) {
        float f3;
        double d6;
        double d5;
        double d4;
        int i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemstack = player.m_21205_();
        if (!(itemstack.m_41720_() instanceof FishingRodItem)) {
            i = -i;
        }
        float f = player.m_21324_(partialTick);
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
        float f2 = Mth.m_14179_((float)partialTick, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
        double d0 = Mth.m_14031_((float)f2);
        double d1 = Mth.m_14089_((float)f2);
        double d2 = (double)i * 0.35;
        double d3 = 0.8;
        if (this.f_114476_.f_114360_.m_92176_().m_90612_() && player == Minecraft.m_91087_().f_91074_) {
            double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
            Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.525f, -0.1f);
            vec3 = vec3.m_82490_(d7);
            vec3 = vec3.m_82524_(f1 * 0.5f);
            vec3 = vec3.m_82496_(-f1 * 0.7f);
            d4 = Mth.m_14139_((double)partialTick, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
            d5 = Mth.m_14139_((double)partialTick, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
            d6 = Mth.m_14139_((double)partialTick, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
            f3 = player.m_20192_();
        } else {
            d4 = Mth.m_14139_((double)partialTick, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.8;
            d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTick - 0.45;
            d6 = Mth.m_14139_((double)partialTick, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.8;
            f3 = player.m_6047_() ? -0.1875f : 0.0f;
        }
        double d9 = Mth.m_14139_((double)partialTick, (double)hookEntity.f_19854_, (double)hookEntity.m_20185_());
        double d10 = Mth.m_14139_((double)partialTick, (double)hookEntity.f_19855_, (double)hookEntity.m_20186_()) + 0.25;
        double d8 = Mth.m_14139_((double)partialTick, (double)hookEntity.f_19856_, (double)hookEntity.m_20189_());
        float f4 = (float)(d4 - d9);
        float f5 = (float)(d5 - d10) + f3;
        float f6 = (float)(d6 - d8);
        VertexConsumer vertexconsumer1 = multiBufferSource.m_6299_(RenderType.m_173247_());
        PoseStack.Pose posestack$pose1 = poseStack.m_85850_();
        for (int k = 0; k <= 16; ++k) {
            BlockPos vertexPos = new BlockPos((int)d9, (int)d10, (int)d8);
            TideFishingHookRenderer.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, TideFishingHookRenderer.fraction(k, 16), TideFishingHookRenderer.fraction(k + 1, 16), vertexPos, hookEntity.m_9236_(), CustomRodManager.getLineColor(hookEntity.getLine()));
        }
    }

    private static float fraction(int a, int b) {
        return (float)a / (float)b;
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float frac1, float frac2, BlockPos hookPos, Level level, String colorHex) {
        float f = x * frac1;
        float f1 = y * (frac1 * frac1 + frac1) * 0.5f + 0.25f;
        float f2 = z * frac1;
        float f3 = x * frac2 - f;
        float f4 = y * (frac2 * frac2 + frac2) * 0.5f + 0.25f - f1;
        float f5 = z * frac2 - f2;
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        f3 /= f6;
        f4 /= f6;
        f5 /= f6;
        Color color = Color.decode(colorHex);
        float colorBrightness = Tide.CONFIG.general.defaultLineColor ? 0.0f : 1.0f;
        int r = (int)((float)color.getRed() * colorBrightness);
        int g = (int)((float)color.getGreen() * colorBrightness);
        int b = (int)((float)color.getBlue() * colorBrightness);
        vertexConsumer.m_252986_(pose.m_252922_(), f, f1, f2).m_6122_(r, g, b, 255).m_252939_(pose.m_252943_(), f3, f4, f5).m_5752_();
    }

    public TideFishingHookModel<TideFishingHook> getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(TideFishingHook hookEntity) {
        if (!this.allowModifiers()) {
            return HOOK_TEX_LOCATION;
        }
        return CustomRodManager.getTextureLocation(hookEntity.getHook());
    }

    protected boolean allowModifiers() {
        return true;
    }
}

