/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MonolithFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == BOPBlocks.UNMAPPED_END_STONE;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_204336_(BlockTags.f_278411_) || world.m_8055_(pos).m_60734_() instanceof BushBlock || world.m_8055_(pos).m_60734_() == BOPBlocks.NULL_END_STONE;

    public MonolithFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos.m_7918_(0, 0, 0))) {
            return false;
        }
        int sizeX = 1 + rand.m_188503_(3);
        int sizeZ = 1 + rand.m_188503_(3);
        int height = 5 + rand.m_188503_(7);
        if (!this.checkSpace(world, startPos.m_7494_(), sizeX, sizeZ, height)) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        for (int x = 0; x <= sizeX; ++x) {
            for (int y = -6; y <= height; ++y) {
                for (int z = 0; z <= sizeZ; ++z) {
                    if (y == height - 1) {
                        if (x != 0 && x != sizeX || z != 0 && z != sizeZ) continue;
                        this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50080_.m_49966_());
                        continue;
                    }
                    this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50080_.m_49966_());
                }
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int sizeX, int sizeZ, int height) {
        for (int y = 0; y <= height; ++y) {
            for (int x = 0; x <= sizeX; ++x) {
                for (int z = 0; z <= sizeZ; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

