/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WispjellyFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_204336_(ModTags.Blocks.TIDEPOOL_REPLACEABLE);
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() instanceof BushBlock || world.m_8055_(pos).m_204336_(ModTags.Blocks.DEAD_CORALS);

    public WispjellyFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = 8 + rand.m_188503_(56);
        if (!this.checkSpace(world, startPos.m_7494_(), height)) {
            return false;
        }
        BlockPos pos = startPos.m_6630_(height);
        if (rand.m_188503_(4) == 0) {
            this.createLargeJelly(world, pos);
        } else if (rand.m_188503_(2) == 0) {
            this.createSmallJelly(world, pos);
        } else {
            this.createTinyJelly(world, pos);
        }
        return true;
    }

    public void createTinyJelly(WorldGenLevel world, BlockPos pos) {
        this.setBlock(world, pos.m_7918_(-1, 1, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(1, 1, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(0, 1, 1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(0, 1, -1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(0, 0, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(-1, 0, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(1, 0, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(0, 0, 1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(0, 0, -1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(1, 0, 1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(1, 0, -1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(-1, 0, 1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(-1, 0, -1), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(-1, -1, 0), BOPBlocks.WISPJELLY.m_49966_());
        this.setBlock(world, pos.m_7918_(1, -1, 0), BOPBlocks.WISPJELLY.m_49966_());
    }

    public void createSmallJelly(WorldGenLevel world, BlockPos pos) {
        int x;
        for (x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.WISPJELLY.m_49966_());
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if ((x == -2 || x == 2) && (z == -2 || z == 2)) continue;
                this.setBlock(world, pos.m_7918_(x, 0, z), BOPBlocks.WISPJELLY.m_49966_());
            }
        }
        int length = 2;
        for (int i = 0; i < length; ++i) {
            this.setBlock(world, pos.m_7918_(1, -(i + 1), 1), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(1, -(i + 1), -1), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 1), 1), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 1), -1), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(1, -(i + 2), 1), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 2), -1), BOPBlocks.WISPJELLY.m_49966_());
        }
    }

    public void createLargeJelly(WorldGenLevel world, BlockPos pos) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 3; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if ((x == -2 || x == 2) && (z == -2 || z == 2)) continue;
                    if (y == 3) {
                        if (x == -2 || x == 2 || z == -2 || z == 2) continue;
                        this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.WISPJELLY.m_49966_());
                        continue;
                    }
                    this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.WISPJELLY.m_49966_());
                }
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Mth.m_14040_((int)x) + Mth.m_14040_((int)z) >= 5) continue;
                this.setBlock(world, pos.m_7918_(x, 0, z), BOPBlocks.WISPJELLY.m_49966_());
            }
        }
        int length = 3;
        for (int i = 0; i < length; ++i) {
            this.setBlock(world, pos.m_7918_(-1, -(i + 1), -2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(1, -(i + 1), -2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 1), 2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(1, -(i + 1), 2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-2, -(i + 1), 0), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(2, -(i + 1), 0), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 2), -2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(-1, -(i + 2), 2), BOPBlocks.WISPJELLY.m_49966_());
            this.setBlock(world, pos.m_7918_(2, -(i + 2), 0), BOPBlocks.WISPJELLY.m_49966_());
        }
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int height) {
        for (int y = -3; y <= 3; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y + height, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

