/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.client.screen.widget;

import com.google.common.collect.Lists;
import corgitaco.corgilib.CorgiLib;
import corgitaco.corgilib.client.AnnouncementInfo;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class AnnouncementWidget
extends AbstractWidget {
    private static final ResourceLocation CORGI_TACO_WAVE = CorgiLib.createLocation("textures/gui/corgi_taco_wave.png");
    private final List<AbstractWidget> children = Lists.newArrayList();
    private int imageWidth = 0;

    public AnnouncementWidget(int guiWidth, int guiHeight, int width, int height, Component message) {
        super(guiWidth / 2, guiHeight / 2, width, height, message);
        int maxWidth = Math.min(guiWidth / 6, 250);
        int renderX = guiWidth - 30 - maxWidth;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int renderY = guiHeight - 10 - 9 * 3;
        AnnouncementInfo announcementInfo = AnnouncementInfo.getInstance();
        MultiLineTextWidget announcementHeader = new MultiLineTextWidget(renderX, renderY, announcementInfo.title(), Minecraft.m_91087_().f_91062_).m_269484_(true).m_269098_(maxWidth);
        int yOffset = announcementHeader.m_93694_() + 15;
        this.addRenderableWidget(announcementHeader);
        MultiLineTextWidget announcement = new MultiLineTextWidget(renderX, renderY + yOffset, announcementInfo.desc(), Minecraft.m_91087_().f_91062_).m_269484_(true).m_269098_(maxWidth);
        this.addRenderableWidget(announcement);
        int buttonWidth = (int)((double)announcement.m_5711_() * 0.48);
        int buttonSpacing = (int)((double)announcement.m_5711_() * 0.04);
        Button takeMeThere = new Button.Builder(announcementInfo.actionButtonText(), ConfirmLinkScreen.m_274609_((String)announcementInfo.url(), (Screen)Minecraft.m_91087_().f_91080_, (boolean)false)).m_252794_(renderX, renderY + (yOffset += announcement.m_93694_() + 5)).m_252780_(buttonWidth).m_253136_();
        this.addRenderableWidget(takeMeThere);
        Button dismiss = new Button.Builder((Component)Component.m_237113_((String)"Dismiss"), button -> {
            this.f_93624_ = false;
            AnnouncementInfo.saveStoredAnnouncementInfo();
        }).m_252794_(renderX + takeMeThere.m_5711_() + buttonSpacing, renderY + yOffset).m_252780_(buttonWidth).m_253136_();
        this.addRenderableWidget(dismiss);
        yOffset += dismiss.m_93694_() + 5;
        for (AbstractWidget widget : this.children) {
            widget.m_253211_(widget.m_252907_() - yOffset);
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (AbstractWidget child : this.children) {
            minX = Math.min(child.m_264198_().m_274563_(), minX);
            minX = Math.min(child.m_264198_().m_274445_(), minX);
            minY = Math.min(child.m_264198_().m_274349_(), minY);
            minY = Math.min(child.m_264198_().m_274449_(), minY);
            maxX = Math.max(child.m_264198_().m_274563_(), maxX);
            maxX = Math.max(child.m_264198_().m_274445_(), maxX);
            maxY = Math.max(child.m_264198_().m_274349_(), maxY);
            maxY = Math.max(child.m_264198_().m_274449_(), maxY);
        }
        minX -= 10;
        maxX += 10;
        minY -= 10;
        maxY += 10;
        if (guiWidth > 1000) {
            double corgiImageHeight = 666.0;
            double corgiImageWidth = 553.0;
            double ratio = corgiImageWidth / corgiImageHeight;
            minX -= 10;
            this.f_93619_ = maxY - minY;
            this.imageWidth = (int)((double)(this.f_93619_ - 10) * ratio);
            minX -= this.imageWidth;
        }
        this.m_253211_(minY);
        this.f_93619_ = maxY - minY;
        this.m_252865_(minX);
        this.m_93674_(maxX - minX);
    }

    protected <T extends AbstractWidget> T addRenderableWidget(T widget) {
        return this.addWidget(widget);
    }

    protected <T extends AbstractWidget> T addWidget(T listener) {
        this.children.add(listener);
        return listener;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
            guiGraphics.m_280246_(0.3f, 0.3f, 0.3f, 1.0f);
            guiGraphics.m_280411_(Screen.f_279548_, this.m_252754_() + 1, this.m_252907_() + 1, this.m_5711_() - 2, this.m_93694_() - 2, 0.0f, 0.0f, this.f_93618_, this.f_93619_, 32, 32);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            for (Renderable renderable : this.children) {
                renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.imageWidth > 0) {
                int renderHeight = this.m_93694_() - 10;
                guiGraphics.m_280411_(CORGI_TACO_WAVE, this.m_252754_() + 10, this.m_252907_() + 5, this.imageWidth, renderHeight, 0.0f, 0.0f, 553, 666, 553, 666);
            }
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (AbstractWidget child : this.children) {
            child.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7435_(SoundManager handler) {
    }
}

