/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToBedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NonHoggingLook;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StarbyBehavior
extends ChangeableBehavior {
    public Starbuncle starbuncle;

    public StarbyBehavior(Starbuncle entity, CompoundTag tag) {
        super((Entity)entity, tag);
        this.starbuncle = entity;
        this.goals.add(new WrappedGoal(4, (Goal)new GoToBedGoal(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(8, (Goal)new LookAtPlayerGoal((Mob)this.starbuncle, Player.class, 3.0f, 0.01f)));
        this.goals.add(new WrappedGoal(8, (Goal)new NonHoggingLook(this.starbuncle, Mob.class, 3.0f, 0.01f)));
        this.goals.add(new WrappedGoal(1, (Goal)new OpenDoorGoal((Mob)this.starbuncle, true)));
    }

    public boolean canGoToBed() {
        return true;
    }

    public boolean isBedPowered() {
        if (this.starbuncle.data.bedPos == null || !this.starbuncle.f_19853_.m_46749_(this.starbuncle.data.bedPos)) {
            return false;
        }
        BlockState state = this.starbuncle.f_19853_.m_8055_(this.starbuncle.data.bedPos);
        if (!state.m_204336_(BlockTagProvider.SUMMON_SLEEPABLE)) {
            return false;
        }
        return state.m_61138_((Property)BlockStateProperties.f_61448_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false;
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && playerEntity.f_19853_.m_8055_(storedPos).m_204336_(BlockTagProvider.SUMMON_SLEEPABLE)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.set_bed"));
            this.starbuncle.data.bedPos = storedPos.m_7949_();
        }
    }

    @Override
    protected ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", "starby");
    }

    @Override
    public void syncTag() {
        this.starbuncle.syncBehavior();
    }

    @Override
    public ItemStack getStackForRender() {
        return this.starbuncle.getHeldStack();
    }
}

