/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerCapAttacher;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.capability.ManaCapAttacher;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSyncPlayerCap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CapabilityRegistry {
    public static final Capability<IManaCap> MANA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IManaCap>(){});
    public static final Capability<IPlayerCap> PLAYER_DATA_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerCap>(){});
    public static final Direction DEFAULT_FACING = null;

    public static LazyOptional<IManaCap> getMana(LivingEntity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(MANA_CAPABILITY);
    }

    public static LazyOptional<IPlayerCap> getPlayerDataCap(LivingEntity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(PLAYER_DATA_CAP);
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau")
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                ManaCapAttacher.attach(event);
                ANPlayerCapAttacher.attach(event);
            }
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(IManaCap.class);
            event.register(IPlayerCap.class);
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.revive();
            CapabilityRegistry.getMana((LivingEntity)oldPlayer).ifPresent(oldMaxMana -> CapabilityRegistry.getMana((LivingEntity)event.getEntity()).ifPresent(newMaxMana -> {
                newMaxMana.setMaxMana(oldMaxMana.getMaxMana());
                newMaxMana.setMana(oldMaxMana.getCurrentMana());
                newMaxMana.setBookTier(oldMaxMana.getBookTier());
                newMaxMana.setGlyphBonus(oldMaxMana.getGlyphBonus());
            }));
            CapabilityRegistry.getPlayerDataCap((LivingEntity)oldPlayer).ifPresent(oldPlayerCap -> {
                IPlayerCap playerDataCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)event.getEntity()).orElse((Object)new ANPlayerDataCap());
                CompoundTag tag = (CompoundTag)oldPlayerCap.serializeNBT();
                playerDataCap.deserializeNBT((Tag)tag);
                EventHandler.syncPlayerCap(event.getEntity());
            });
            event.getOriginal().invalidateCaps();
        }

        @SubscribeEvent
        public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
            if (event.getTarget() instanceof Player && event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        public static void syncPlayerCap(Player player) {
            IPlayerCap cap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)player).orElse((Object)new ANPlayerDataCap());
            CompoundTag tag = (CompoundTag)cap.serializeNBT();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Networking.sendToPlayerClient(new PacketSyncPlayerCap(tag), serverPlayer);
            }
        }
    }
}

