/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.foliageplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import quek.undergarden.block.MushroomVeilBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFoliagePlacers;

public class VeilFoliagePlacer
extends FoliagePlacer {
    public static final Codec<VeilFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> VeilFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, VeilFoliagePlacer::new));

    public VeilFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)UGFoliagePlacers.VEIL.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int height, int radius, int offset) {
        VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)attachment.m_161451_());
        this.circle(-1, radius - 2, false, level, blockSetter, random, config, attachment.m_161451_());
        this.circle(-2, radius - 2, false, level, blockSetter, random, config, attachment.m_161451_());
        this.circle(-3, radius - 1, false, level, blockSetter, random, config, attachment.m_161451_());
        this.circle(-4, radius, true, level, blockSetter, random, config, attachment.m_161451_());
    }

    private void circle(int centerY, int radius, boolean veil, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        int d = (5 - radius * 4) / 4;
        int x = 0;
        int z = radius;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        do {
            posMutable.m_122154_((Vec3i)pos, x + 1, centerY, z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, x, centerY, z - 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.f_57836_, VineBlock.f_57835_, level, blockSetter, random);
                } else {
                    this.addHangingVeil(posMutable, VineBlock.f_57836_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, x, centerY, z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.m_122154_((Vec3i)pos, x + 1, centerY, -z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, x, centerY, -z + 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.f_57834_, VineBlock.f_57835_, level, blockSetter, random);
                } else {
                    this.addHangingVeil(posMutable, VineBlock.f_57834_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, x, centerY, -z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.m_122154_((Vec3i)pos, -x - 1, centerY, z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, -x, centerY, z - 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.f_57836_, VineBlock.f_57837_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, -x, centerY, z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.m_122154_((Vec3i)pos, -x - 1, centerY, -z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, -x, centerY, -z + 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.f_57834_, VineBlock.f_57837_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, -x, centerY, -z);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.m_122154_((Vec3i)pos, z, centerY, x);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, z - 1, centerY, x);
                if (x == 0) {
                    this.addHangingVeil(posMutable, VineBlock.f_57835_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, z, centerY, -x);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.m_122154_((Vec3i)pos, -z, centerY, x);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.m_122154_((Vec3i)pos, -z + 1, centerY, x);
                if (x == 0) {
                    this.addHangingVeil(posMutable, VineBlock.f_57837_, level, blockSetter, random);
                }
            }
            posMutable.m_122154_((Vec3i)pos, -z, centerY, -x);
            VeilFoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (d < 0) {
                d += 2 * x + 1;
                continue;
            }
            d += 2 * (x - z) + 1;
            --z;
        } while (++x <= z);
    }

    private void addHangingVeil(BlockPos.MutableBlockPos posMutable, BooleanProperty side, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random) {
        int length = 4 - random.m_188503_(3);
        blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
        for (int i = 0; i <= length; ++i) {
            if (level.m_7433_((BlockPos)posMutable, BlockBehaviour.BlockStateBase::m_60795_)) {
                if (i == length || !level.m_7433_(posMutable.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
                    blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true))).m_61124_((Property)MushroomVeilBlock.END, (Comparable)Boolean.valueOf(true)));
                    break;
                }
                blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true)));
            }
            posMutable.m_122173_(Direction.DOWN);
        }
    }

    private void addHangingVeil(BlockPos.MutableBlockPos posMutable, BooleanProperty side, BooleanProperty side2, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random) {
        int length = 4 - random.m_188503_(3);
        blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true))).m_61124_((Property)side2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)));
        for (int i = 0; i <= length; ++i) {
            if (level.m_7433_((BlockPos)posMutable, BlockBehaviour.BlockStateBase::m_60795_)) {
                if (i == length || !level.m_7433_(posMutable.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
                    blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true))).m_61124_((Property)side2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)MushroomVeilBlock.END, (Comparable)Boolean.valueOf(true)));
                    break;
                }
                blockSetter.m_271838_((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).m_49966_().m_61124_((Property)side, (Comparable)Boolean.valueOf(true))).m_61124_((Property)side2, (Comparable)Boolean.valueOf(true)));
            }
            posMutable.m_122173_(Direction.DOWN);
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

