/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.forge;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.vivecraft.client.Xplat;

public class XplatImpl {
    public static boolean isModLoaded(String name) {
        return FMLLoader.getLoadingModList().getModFileById(name) != null;
    }

    public static Path getConfigPath(String fileName) {
        return FMLPaths.CONFIGDIR.get().resolve(fileName);
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static Xplat.ModLoader getModloader() {
        return Xplat.ModLoader.FORGE;
    }

    public static String getModVersion() {
        if (XplatImpl.isModLoadedSuccess()) {
            return FMLLoader.getLoadingModList().getModFileById("vivecraft").versionString();
        }
        return "no version";
    }

    public static boolean isModLoadedSuccess() {
        return FMLLoader.getLoadingModList().getModFileById("vivecraft") != null;
    }

    public static boolean enableRenderTargetStencil(RenderTarget renderTarget) {
        renderTarget.enableStencil();
        return true;
    }

    public static Path getJarPath() {
        return FMLLoader.getLoadingModList().getModFileById("vivecraft").getFile().getSecureJar().getPath("/", new String[0]);
    }

    public static String getUseMethodName() {
        return ObfuscationReflectionHelper.findMethod(BlockBehaviour.class, (String)"m_6227_", (Class[])new Class[]{BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class}).getName();
    }

    public static TextureAtlasSprite[] getFluidTextures(BlockAndTintGetter level, BlockPos pos, FluidState fluidStateIn) {
        return ForgeHooksClient.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fluidStateIn);
    }

    public static Biome.ClimateSettings getBiomeClimateSettings(Biome biome) {
        return biome.getModifiedClimateSettings();
    }

    public static BiomeSpecialEffects getBiomeEffects(Biome biome) {
        return biome.getModifiedSpecialEffects();
    }

    public static double getItemEntityReach(double baseRange, ItemStack itemStack, EquipmentSlot slot) {
        Collection attributes = itemStack.m_41638_(slot).get((Object)((Attribute)ForgeMod.ENTITY_REACH.get()));
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            baseRange += a.m_22218_();
        }
        double totalRange = baseRange;
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            totalRange += baseRange * a.m_22218_();
        }
        for (AttributeModifier a : attributes) {
            if (a.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            totalRange *= 1.0 + a.m_22218_();
        }
        return totalRange;
    }
}

