/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.phys.Vec2;
import org.vivecraft.client.gui.framework.GuiVROption;
import org.vivecraft.client.gui.framework.GuiVROptionButton;
import org.vivecraft.client.gui.framework.GuiVROptionSlider;
import org.vivecraft.client.gui.framework.VROptionEntry;
import org.vivecraft.client.gui.framework.VROptionLayout;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ScreenUtils;
import org.vivecraft.client_vr.settings.VRSettings;

public abstract class GuiVROptionsBase
extends Screen {
    protected ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
    public static final int DONE_BUTTON = 200;
    public static final int DEFAULTS_BUTTON = 201;
    protected final Screen lastScreen;
    protected final VRSettings settings;
    protected boolean reinit;
    protected boolean drawDefaultButtons = true;
    protected ObjectSelectionList visibleList = null;
    private int nextButtonIndex = 0;
    public String vrTitle = "Title";
    private Button btnDone;
    private Button btnDefaults;

    public GuiVROptionsBase(Screen lastScreen) {
        super((Component)Component.m_237113_((String)""));
        this.lastScreen = lastScreen;
        this.settings = ClientDataHolderVR.getInstance().vrSettings;
    }

    protected void addDefaultButtons() {
        this.btnDone = new Button.Builder((Component)Component.m_237115_((String)"gui.back"), p -> {
            if (!this.onDoneClicked()) {
                this.dataholder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDone);
        this.btnDefaults = new Button.Builder((Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), p -> {
            this.loadDefaults();
            this.dataholder.vrSettings.saveOptions();
            this.reinit = true;
        }).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 30).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDefaults);
    }

    protected boolean onDoneClicked() {
        return false;
    }

    protected void init(VROptionLayout[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
        }
        int i = 0;
        for (final VROptionLayout vroptionlayout : settings) {
            if (vroptionlayout.getOption() != null && vroptionlayout.getOption().getEnumFloat()) {
                this.m_142416_((GuiEventListener)new GuiVROptionSlider(vroptionlayout.getOrdinal(), vroptionlayout.getX(this.f_96543_), vroptionlayout.getY(this.f_96544_), vroptionlayout.getOption()){

                    public void m_5716_(double pMouseX, double p_93635_) {
                        if (vroptionlayout.getCustomHandler() == null || !vroptionlayout.getCustomHandler().apply(this, new Vec2((float)pMouseX, (float)p_93635_)).booleanValue()) {
                            super.m_5716_(pMouseX, p_93635_);
                        }
                    }
                });
                continue;
            }
            if (vroptionlayout.getOption() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(vroptionlayout.getOrdinal(), vroptionlayout.getX(this.f_96543_), vroptionlayout.getY(this.f_96544_), vroptionlayout.getOption(), vroptionlayout.getButtonText(), p -> {
                    if (vroptionlayout.getCustomHandler() == null || !vroptionlayout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                        this.settings.setOptionValue(((GuiVROptionButton)p).getOption());
                        p.m_93666_((Component)Component.m_237113_((String)vroptionlayout.getButtonText()));
                    }
                }));
                continue;
            }
            if (vroptionlayout.getScreen() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(vroptionlayout.getOrdinal(), vroptionlayout.getX(this.f_96543_), vroptionlayout.getY(this.f_96544_), vroptionlayout.getButtonText(), p -> {
                    try {
                        if (vroptionlayout.getCustomHandler() != null && vroptionlayout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                            return;
                        }
                        this.settings.saveOptions();
                        this.f_96541_.m_91152_(vroptionlayout.getScreen().getConstructor(Screen.class).newInstance(new Object[]{this}));
                    }
                    catch (ReflectiveOperationException reflectiveoperationexception) {
                        reflectiveoperationexception.printStackTrace();
                    }
                }));
                continue;
            }
            if (vroptionlayout.getCustomHandler() != null) {
                this.m_142416_((GuiEventListener)new GuiVROptionButton(vroptionlayout.getOrdinal(), vroptionlayout.getX(this.f_96543_), vroptionlayout.getY(this.f_96544_), vroptionlayout.getButtonText(), p -> vroptionlayout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f))));
                continue;
            }
            this.m_142416_((GuiEventListener)new GuiVROptionButton(vroptionlayout.getOrdinal(), vroptionlayout.getX(this.f_96543_), vroptionlayout.getY(this.f_96544_), vroptionlayout.getButtonText(), p -> {}));
        }
        ++i;
    }

    protected void loadDefaults() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof GuiVROption)) continue;
            GuiVROption optionButton = (GuiVROption)child;
            this.settings.loadDefault(optionButton.getOption());
        }
    }

    protected void init(VROptionEntry[] settings, boolean clear) {
        if (clear) {
            this.m_169413_();
            this.nextButtonIndex = 0;
        }
        ArrayList<VROptionLayout> arraylist = new ArrayList<VROptionLayout>();
        if (this.nextButtonIndex < this.m_6702_().size()) {
            this.nextButtonIndex = this.m_6702_().size();
        }
        int i = this.nextButtonIndex;
        for (int j = 0; j < settings.length; ++j) {
            VROptionLayout.Position vroptionlayout$position;
            VROptionLayout.Position position = settings[j].center ? VROptionLayout.Position.POS_CENTER : (vroptionlayout$position = i % 2 == 0 ? VROptionLayout.Position.POS_LEFT : VROptionLayout.Position.POS_RIGHT);
            if (settings[j].center && i % 2 != 0) {
                ++i;
            }
            if (settings[j].option != null) {
                if (settings[j].option != VRSettings.VrOptions.DUMMY) {
                    arraylist.add(new VROptionLayout(settings[j].option, settings[j].customHandler, vroptionlayout$position, (float)Math.floor((float)i / 2.0f), true, settings[j].title));
                }
            } else if (settings[j].customHandler != null) {
                arraylist.add(new VROptionLayout(settings[j].customHandler, vroptionlayout$position, (float)Math.floor((float)i / 2.0f), true, settings[j].title));
            }
            if (settings[j].center) {
                ++i;
            }
            ++i;
        }
        this.nextButtonIndex = i;
        this.init(arraylist.toArray(new VROptionLayout[0]), false);
    }

    protected void init(VRSettings.VrOptions[] settings, boolean clear) {
        VROptionEntry[] avroptionentry = new VROptionEntry[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            avroptionentry[i] = new VROptionEntry(settings[i]);
        }
        this.init(avroptionentry, clear);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.reinit) {
            List<GuiEventListener> items;
            VRSettings.VrOptions vrOptions;
            this.reinit = false;
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof GuiVROptionButton) {
                GuiVROptionButton option = (GuiVROptionButton)guiEventListener;
                vrOptions = option.getOption();
            } else {
                vrOptions = null;
            }
            VRSettings.VrOptions selected = vrOptions;
            this.m_7856_();
            if (selected != null && !(items = this.m_6702_().stream().filter(listener -> {
                GuiVROptionButton o;
                return listener instanceof GuiVROptionButton && (o = (GuiVROptionButton)listener).getOption() == selected;
            }).toList()).isEmpty()) {
                this.m_7522_(items.get(0));
            }
        }
        this.m_280273_(guiGraphics);
        if (this.visibleList != null) {
            this.visibleList.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        }
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)this.vrTitle), this.f_96543_ / 2, 15, 0xFFFFFF);
        if (this.btnDefaults != null) {
            this.btnDefaults.f_93624_ = this.drawDefaultButtons;
        }
        if (this.btnDone != null) {
            this.btnDone.f_93624_ = this.drawDefaultButtons;
        }
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.renderTooltip(guiGraphics, pMouseX, pMouseY);
    }

    protected void actionPerformed(AbstractWidget button) {
    }

    protected void actionPerformedRightClick(AbstractWidget button) {
    }

    public boolean m_6375_(double pMouseX, double p_94738_, int pMouseY) {
        boolean flag = super.m_6375_(pMouseX, p_94738_, pMouseY);
        AbstractWidget abstractwidget = ScreenUtils.getSelectedButton((int)pMouseX, (int)p_94738_, ScreenUtils.getButtonList(this));
        if (abstractwidget != null) {
            if (pMouseY == 0) {
                this.actionPerformed(abstractwidget);
            } else if (pMouseY == 1) {
                this.actionPerformedRightClick(abstractwidget);
            }
        } else if (this.visibleList != null) {
            return this.visibleList.m_6375_(pMouseX, p_94738_, pMouseY);
        }
        return flag;
    }

    public boolean m_6348_(double pMouseX, double p_94754_, int pMouseY) {
        return this.visibleList != null ? this.visibleList.m_6348_(pMouseX, p_94754_, pMouseY) : super.m_6348_(pMouseX, p_94754_, pMouseY);
    }

    public boolean m_7979_(double pMouseX, double p_94741_, int pMouseY, double p_94743_, double pButton) {
        return this.visibleList != null ? this.visibleList.m_7979_(pMouseX, p_94741_, pMouseY, p_94743_, pButton) : super.m_7979_(pMouseX, p_94741_, pMouseY, p_94743_, pButton);
    }

    public boolean m_6050_(double x, double y, double scrollAmountY) {
        if (this.visibleList != null) {
            this.visibleList.m_6050_(x, y, scrollAmountY);
        }
        return super.m_6050_(x, y, scrollAmountY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            if (!this.onDoneClicked()) {
                this.dataholder.vrSettings.saveOptions();
                this.f_96541_.m_91152_(this.lastScreen);
            }
            return true;
        }
        if (super.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                this.actionPerformed(widget);
            }
            return true;
        }
        return this.visibleList != null && this.visibleList.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        return this.visibleList != null && this.visibleList.m_5534_(pCodePoint, pModifiers) || super.m_5534_(pCodePoint, pModifiers);
    }

    private void renderTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        GuiVROption guiHover;
        GuiEventListener hover = null;
        if (this.f_96541_.m_264529_().m_264505_()) {
            hover = this.m_7222_();
        }
        if (hover == null) {
            for (GuiEventListener child : this.m_6702_()) {
                AbstractWidget widget;
                if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, pMouseX, pMouseY)) continue;
                hover = child;
            }
        }
        if (hover != null && hover instanceof GuiVROption && (guiHover = (GuiVROption)hover).getOption() != null) {
            String tooltipString = "vivecraft.options." + guiHover.getOption().name() + ".tooltip";
            Object tooltip = "";
            if (I18n.m_118936_((String)tooltipString)) {
                tooltip = I18n.m_118938_((String)tooltipString, (Object[])new Object[]{null});
            }
            if (this.dataholder.vrSettings.overrides.hasSetting(guiHover.getOption())) {
                VRSettings.ServerOverrides.Setting setting = this.dataholder.vrSettings.overrides.getSetting(guiHover.getOption());
                if (setting.isValueOverridden()) {
                    tooltip = I18n.m_118938_((String)"vivecraft.message.overriddenbyserver", (Object[])new Object[0]) + (String)tooltip;
                } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                    tooltip = I18n.m_118938_((String)"vivecraft.message.limitedbyserver", (Object[])new Object[]{Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())}) + (String)tooltip;
                }
            }
            if (!((String)tooltip).isEmpty()) {
                tooltip = ((String)tooltip).replace("\n", "\u00a7r\n");
                List formattedText = this.f_96547_.m_92865_().m_92432_((String)tooltip, 308, Style.f_131099_);
                tooltip = (String)tooltip + " ".repeat((308 - (formattedText.size() == 0 ? 0 : this.f_96547_.m_92852_((FormattedText)formattedText.get(formattedText.size() - 1)))) / this.f_96547_.m_92895_(" "));
                int n = guiHover.m_252907_() + guiHover.m_93694_();
                int n2 = formattedText.size();
                Objects.requireNonNull(this.f_96547_);
                if (n + n2 * (9 + 1) + 14 < this.f_96544_) {
                    guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308), this.f_96543_ / 2 - 166, guiHover.m_252907_() + guiHover.m_93694_() + 14);
                } else {
                    List list = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308);
                    int n3 = this.f_96543_ / 2 - 166;
                    int n4 = guiHover.m_252907_();
                    int n5 = formattedText.size();
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280245_(this.f_96547_, list, n3, n4 - n5 * (9 + 1) + 9);
                }
            }
        }
    }

    private boolean isMouseOver(AbstractWidget widget, double x, double y) {
        return widget.f_93624_ && x >= (double)widget.m_252754_() && y >= (double)widget.m_252907_() && x < (double)(widget.m_252754_() + widget.m_5711_()) && y < (double)(widget.m_252907_() + widget.m_93694_());
    }
}

