/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;
import org.vivecraft.client.gui.framework.GuiVROptionSlider;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.server.config.ConfigBuilder;

public class SettingsList
extends ContainerObjectSelectionList<BaseEntry> {
    final Screen parent;
    int maxNameWidth;

    public SettingsList(Screen parent, Minecraft minecraft, List<BaseEntry> entries) {
        super(minecraft, parent.f_96543_ + 45, parent.f_96544_, 20, parent.f_96544_ - 32, 20);
        this.parent = parent;
        for (BaseEntry entry2 : entries) {
            int i = minecraft.f_91062_.m_92852_((FormattedText)entry2.name);
            if (i > this.maxNameWidth) {
                this.maxNameWidth = i;
            }
            this.m_7085_((AbstractSelectionList.Entry)entry2);
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 8;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public static BaseEntry ConfigToEntry(ConfigBuilder.ConfigValue<?> configValue, Component name) {
        AbstractWidget widget = configValue.getWidget(125, 20).get();
        return new ResettableEntry(name, widget, configValue);
    }

    public static BaseEntry vrOptionToEntry(VRSettings.VrOptions option) {
        GuiVROptionSlider widget;
        Tooltip tooltip;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        String optionString = "vivecraft.options." + option.name();
        String tooltipString = optionString + ".tooltip";
        if (I18n.m_118936_((String)tooltipString)) {
            String tooltipPrefix = "";
            if (dh.vrSettings.overrides.hasSetting(option)) {
                VRSettings.ServerOverrides.Setting setting = dh.vrSettings.overrides.getSetting(option);
                if (setting.isValueOverridden()) {
                    tooltipPrefix = I18n.m_118938_((String)"vivecraft.message.overriddenbyserver", (Object[])new Object[0]);
                } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                    tooltipPrefix = I18n.m_118938_((String)"vivecraft.message.limitedbyserver", (Object[])new Object[]{Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())});
                }
            }
            tooltip = Tooltip.m_257550_((Component)Component.m_237113_((String)(tooltipPrefix + I18n.m_118938_((String)tooltipString, (Object[])new Object[]{null}))));
        } else {
            tooltip = null;
        }
        if (option.getEnumFloat()) {
            widget = new GuiVROptionSlider(option.returnEnumOrdinal(), 0, 0, 145, 20, option, true);
            widget.m_257544_(tooltip);
        } else {
            widget = Button.m_253074_((Component)Component.m_237113_((String)dh.vrSettings.getButtonDisplayString(option, true)), button -> {
                dh.vrSettings.setOptionValue(option);
                button.m_93666_((Component)Component.m_237113_((String)dh.vrSettings.getButtonDisplayString(option, true)));
            }).m_253046_(145, 20).m_257505_(tooltip).m_253136_();
        }
        WidgetEntry entry2 = new WidgetEntry((Component)Component.m_237115_((String)optionString), (AbstractWidget)widget);
        if (dh.vrSettings.overrides.hasSetting(option) && dh.vrSettings.overrides.getSetting(option).isValueOverridden()) {
            ((BaseEntry)entry2).setActive(false);
        }
        return entry2;
    }

    public static abstract class BaseEntry
    extends ContainerObjectSelectionList.Entry<BaseEntry> {
        protected final Component name;
        private boolean active = true;

        public BaseEntry(Component name) {
            this.name = name;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public static class ResettableEntry
    extends WidgetEntry {
        private final Button resetButton;
        private final BooleanSupplier canReset = () -> !configValue.isDefault();
        public static final int valueButtonWidth = 125;

        public ResettableEntry(Component name, AbstractWidget valueWidget, ConfigBuilder.ConfigValue<?> configValue) {
            super(name, valueWidget);
            this.resetButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> {
                configValue.reset();
                this.valueWidget = configValue.getWidget(valueWidget.m_5711_(), valueWidget.m_93694_()).get();
            }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controls.reset"))).m_252987_(0, 0, 20, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            super.m_6311_(guiGraphics, i, j, k, l, m, n, o, bl, f);
            this.resetButton.m_252865_(k + 230);
            this.resetButton.m_253211_(j);
            this.resetButton.f_93623_ = this.canReset.getAsBoolean();
            this.resetButton.m_88315_(guiGraphics, n, o, f);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.resetButton.f_93623_ = active;
        }
    }

    public static class WidgetEntry
    extends BaseEntry {
        protected AbstractWidget valueWidget;
        public static final int valueButtonWidth = 145;

        public WidgetEntry(Component name, AbstractWidget valueWidget) {
            super(name);
            this.valueWidget = valueWidget;
        }

        public void m_6311_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n2 = j + m / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280430_(font, this.name, k + 90 - 140, n2 - 9 / 2, 0xFFFFFF);
            this.valueWidget.m_252865_(k + 105);
            this.valueWidget.m_253211_(j);
            this.valueWidget.m_88315_(guiGraphics, n, o, f);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.valueWidget.f_93623_ = active;
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final int width;

        public CategoryEntry(Component name) {
            super(name);
            this.width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.name);
        }

        public void m_6311_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n2 = Minecraft.m_91087_().f_91080_.f_96543_ / 2 - this.width / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280430_(font, this.name, n2, j + m - 9 - 1, 0xFFFFFF);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.m_169146_(NarratedElementType.TITLE, name);
                }
            });
        }
    }
}

