/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.common.utils.math.Vector3;

public class VRData {
    public VRDevicePose hmd;
    public VRDevicePose eye0;
    public VRDevicePose eye1;
    public VRDevicePose c0;
    public VRDevicePose c1;
    public VRDevicePose c2;
    public VRDevicePose h0;
    public VRDevicePose h1;
    public VRDevicePose t0;
    public VRDevicePose t1;
    public VRDevicePose cam;
    public Vec3 origin;
    public float rotation_radians;
    public float worldScale;

    public VRData(Vec3 origin, float walkMul, float worldScale, float rotation) {
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        this.origin = origin;
        this.worldScale = worldScale;
        this.rotation_radians = rotation;
        Vec3 vec3 = dataholder.vr.getCenterEyePosition();
        Vec3 vec31 = new Vec3(vec3.f_82479_ * (double)walkMul, vec3.f_82480_, vec3.f_82481_ * (double)walkMul);
        this.hmd = new VRDevicePose(this, dataholder.vr.hmdRotation, vec31, dataholder.vr.getHmdVector());
        this.eye0 = new VRDevicePose(this, dataholder.vr.getEyeRotation(RenderPass.LEFT), dataholder.vr.getEyePosition(RenderPass.LEFT).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getHmdVector());
        this.eye1 = new VRDevicePose(this, dataholder.vr.getEyeRotation(RenderPass.RIGHT), dataholder.vr.getEyePosition(RenderPass.RIGHT).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getHmdVector());
        this.c0 = new VRDevicePose(this, dataholder.vr.getAimRotation(0), dataholder.vr.getAimSource(0).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getAimVector(0));
        this.c1 = new VRDevicePose(this, dataholder.vr.getAimRotation(1), dataholder.vr.getAimSource(1).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getAimVector(1));
        this.h0 = new VRDevicePose(this, dataholder.vr.getHandRotation(0), dataholder.vr.getAimSource(0).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getHandVector(0));
        this.h1 = new VRDevicePose(this, dataholder.vr.getHandRotation(1), dataholder.vr.getAimSource(1).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getHandVector(1));
        if (dataholder.vrSettings.seated) {
            this.t0 = this.eye0;
            this.t1 = this.eye1;
        } else {
            Matrix4f matrix4f = this.getSmoothedRotation(0, 0.2f);
            Matrix4f matrix4f1 = this.getSmoothedRotation(1, 0.2f);
            this.t0 = new VRDevicePose(this, matrix4f, dataholder.vr.getAimSource(0).m_82546_(vec3).m_82549_(vec31), matrix4f.transform(Vector3.forward()).toVector3d());
            this.t1 = new VRDevicePose(this, matrix4f1, dataholder.vr.getAimSource(1).m_82546_(vec3).m_82549_(vec31), matrix4f1.transform(Vector3.forward()).toVector3d());
        }
        Matrix4f matrix4f2 = Matrix4f.multiply(Matrix4f.rotationY(-rotation), new Matrix4f(ClientDataHolderVR.getInstance().cameraTracker.getRotation()).transposed());
        float inverseWorldScale = 1.0f / worldScale;
        this.cam = new VRDevicePose(this, matrix4f2, ClientDataHolderVR.getInstance().cameraTracker.getPosition().m_82546_(origin).m_82524_(-rotation).m_82542_((double)inverseWorldScale, (double)inverseWorldScale, (double)inverseWorldScale).m_82546_(vec3).m_82549_(vec31), matrix4f2.transform(Vector3.forward()).toVector3d());
        if (dataholder.vr.mrMovingCamActive) {
            this.c2 = new VRDevicePose(this, dataholder.vr.getAimRotation(2), dataholder.vr.getAimSource(2).m_82546_(vec3).m_82549_(vec31), dataholder.vr.getAimVector(2));
        } else {
            VRSettings vrsettings = ClientDataHolderVR.getInstance().vrSettings;
            Matrix4f matrix4f3 = new Matrix4f(vrsettings.vrFixedCamrotQuat).transposed();
            Vec3 vec32 = new Vec3((double)vrsettings.vrFixedCamposX, (double)vrsettings.vrFixedCamposY, (double)vrsettings.vrFixedCamposZ);
            Vec3 vec33 = matrix4f3.transform(Vector3.forward()).toVector3d();
            this.c2 = new VRDevicePose(this, matrix4f3, vec32.m_82546_(vec3).m_82549_(vec31), vec33);
        }
    }

    private Matrix4f getSmoothedRotation(int c, float lenSec) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        Vec3 vec3 = dataholder.vr.controllerHistory[c].averagePosition(lenSec);
        Vec3 vec31 = dataholder.vr.controllerForwardHistory[c].averagePosition(lenSec);
        Vec3 vec32 = dataholder.vr.controllerUpHistory[c].averagePosition(lenSec);
        Vec3 vec33 = vec31.m_82537_(vec32);
        return new Matrix4f((float)vec33.f_82479_, (float)vec31.f_82479_, (float)vec32.f_82479_, (float)vec33.f_82480_, (float)vec31.f_82480_, (float)vec32.f_82480_, (float)vec33.f_82481_, (float)vec31.f_82481_, (float)vec32.f_82481_);
    }

    public VRDevicePose getController(int c) {
        return c == 1 ? this.c1 : (c == 2 ? this.c2 : this.c0);
    }

    public VRDevicePose getHand(int c) {
        return c == 0 ? this.h0 : this.h1;
    }

    public float getBodyYaw() {
        Vec3 vec31;
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return this.hmd.getYaw();
        }
        Vec3 vec3 = this.c1.getPosition().m_82546_(this.c0.getPosition()).m_82541_().m_82524_(-1.5707964f);
        if (vec3.m_82526_(vec31 = this.hmd.getDirection()) < 0.0) {
            vec3 = vec3.m_82548_();
        }
        vec3 = Utils.vecLerp(vec31, vec3, 0.7);
        return (float)Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_));
    }

    public float getFacingYaw() {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return this.hmd.getYaw();
        }
        Vec3 vec3 = this.c1.getPosition().m_82546_(this.c0.getPosition()).m_82541_().m_82524_(-1.5707964f);
        return ClientDataHolderVR.getInstance().vrSettings.reverseHands ? (float)Math.toDegrees(Math.atan2(vec3.f_82479_, -vec3.f_82481_)) : (float)Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_));
    }

    public Vec3 getHeadPivot() {
        Vec3 vec3 = this.hmd.getPosition();
        Vector3 vector3 = this.hmd.getMatrix().transform(new Vector3(0.0f, -0.1f * this.worldScale, 0.1f * this.worldScale));
        return new Vec3((double)vector3.getX() + vec3.f_82479_, (double)vector3.getY() + vec3.f_82480_, (double)vector3.getZ() + vec3.f_82481_);
    }

    public Vec3 getHeadRear() {
        Vec3 vec3 = this.hmd.getPosition();
        Vector3 vector3 = this.hmd.getMatrix().transform(new Vector3(0.0f, -0.2f, 0.2f));
        return new Vec3((double)vector3.getX() + vec3.f_82479_, (double)vector3.getY() + vec3.f_82480_, (double)vector3.getZ() + vec3.f_82481_);
    }

    public VRDevicePose getEye(RenderPass pass) {
        switch (pass) {
            case CENTER: {
                return this.hmd;
            }
            case LEFT: {
                return this.eye0;
            }
            case RIGHT: {
                return this.eye1;
            }
            case THIRD: {
                return this.c2;
            }
            case SCOPER: {
                return this.t0;
            }
            case SCOPEL: {
                return this.t1;
            }
            case CAMERA: {
                return this.cam;
            }
        }
        return this.hmd;
    }

    public String toString() {
        return "data:\r\n \t\t origin: " + this.origin + "\r\n \t\t rotation: " + String.format("%.2f", Float.valueOf(this.rotation_radians)) + "\r\n \t\t scale: " + String.format("%.2f", Float.valueOf(this.worldScale)) + "\r\n \t\t hmd " + this.hmd + "\r\n \t\t c0 " + this.c0 + "\r\n \t\t c1 " + this.c1 + "\r\n \t\t c2 " + this.c2;
    }

    protected Vec3 vecMult(Vec3 in, float factor) {
        return new Vec3(in.f_82479_ * (double)factor, in.f_82480_ * (double)factor, in.f_82481_ * (double)factor);
    }

    public class VRDevicePose {
        final VRData data;
        final Vec3 pos;
        final Vec3 dir;
        final Matrix4f matrix;

        public VRDevicePose(VRData data, Matrix4f matrix, Vec3 pos, Vec3 dir) {
            this.data = data;
            this.matrix = matrix.transposed().transposed();
            this.pos = new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            this.dir = new Vec3(dir.f_82479_, dir.f_82480_, dir.f_82481_);
        }

        public Vec3 getPosition() {
            Vec3 vec3 = this.pos.m_82490_((double)VRData.this.worldScale);
            vec3 = vec3.m_82524_(this.data.rotation_radians);
            return vec3.m_82520_(this.data.origin.f_82479_, this.data.origin.f_82480_, this.data.origin.f_82481_);
        }

        public Vec3 getDirection() {
            return new Vec3(this.dir.f_82479_, this.dir.f_82480_, this.dir.f_82481_).m_82524_(this.data.rotation_radians);
        }

        public Vec3 getCustomVector(Vec3 axis) {
            Vector3 vector3 = this.matrix.transform(new Vector3((float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_));
            return vector3.toVector3d().m_82524_(this.data.rotation_radians);
        }

        public float getYaw() {
            Vec3 vec3 = this.getDirection();
            return (float)Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_));
        }

        public float getPitch() {
            Vec3 vec3 = this.getDirection();
            return (float)Math.toDegrees(Math.asin(vec3.f_82480_ / vec3.m_82553_()));
        }

        public float getRoll() {
            return (float)(-Math.toDegrees(Math.atan2(this.matrix.M[1][0], this.matrix.M[1][1])));
        }

        public Matrix4f getMatrix() {
            Matrix4f matrix4f = Matrix4f.rotationY(VRData.this.rotation_radians);
            return Matrix4f.multiply(matrix4f, this.matrix);
        }

        public String toString() {
            return "Device: pos:" + this.getPosition() + " dir: " + this.getDirection();
        }
    }
}

