/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;

public class CameraTracker
extends Tracker {
    public static final ModelResourceLocation cameraModel = new ModelResourceLocation("vivecraft", "camera", "");
    public static final ModelResourceLocation cameraDisplayModel = new ModelResourceLocation("vivecraft", "camera_display", "");
    private boolean visible = false;
    private Vec3 position = new Vec3(0.0, 0.0, 0.0);
    private Quaternion rotation = new Quaternion();
    private int startController;
    private VRData.VRDevicePose startControllerPose;
    private Vec3 startPosition;
    private Quaternion startRotation;
    private boolean quickMode;

    public CameraTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return this.isVisible();
    }

    @Override
    public void doProcess(LocalPlayer player) {
        if (this.startControllerPose != null) {
            VRData.VRDevicePose vrdata$vrdevicepose = this.dh.vrPlayer.vrdata_world_render.getController(this.startController);
            Vec3 vec3 = this.startControllerPose.getPosition();
            Vec3 vec31 = vrdata$vrdevicepose.getPosition().m_82546_(vec3);
            Matrix4f matrix4f = Matrix4f.multiply(vrdata$vrdevicepose.getMatrix(), this.startControllerPose.getMatrix().inverted());
            Vector3 vector3 = new Vector3((float)this.startPosition.f_82479_ - (float)vec3.f_82479_, (float)this.startPosition.f_82480_ - (float)vec3.f_82480_, (float)this.startPosition.f_82481_ - (float)vec3.f_82481_);
            Vector3 vector31 = matrix4f.transform(vector3);
            this.position = new Vec3(this.startPosition.f_82479_ + (double)((float)vec31.f_82479_) + (double)(vector31.getX() - vector3.getX()), this.startPosition.f_82480_ + (double)((float)vec31.f_82480_) + (double)(vector31.getY() - vector3.getY()), this.startPosition.f_82481_ + (double)((float)vec31.f_82481_) + (double)(vector31.getZ() - vector3.getZ()));
            this.rotation = this.startRotation.multiply(new Quaternion(Utils.convertOVRMatrix(matrix4f)));
        }
        if (this.quickMode && !this.isMoving() && !this.dh.grabScreenShot) {
            this.visible = false;
        }
        if (this.dh.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition().m_82554_(this.position) > (double)(this.mc.f_91066_.m_193772_() * 12)) {
            this.visible = false;
        }
    }

    @Override
    public void reset(LocalPlayer player) {
        this.visible = false;
        this.quickMode = false;
        this.stopMoving();
    }

    @Override
    public Tracker.EntryPoint getEntryPoint() {
        return Tracker.EntryPoint.SPECIAL_ITEMS;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
    }

    public boolean isMoving() {
        return this.startControllerPose != null;
    }

    public int getMovingController() {
        return this.startController;
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public void startMoving(int controller, boolean quickMode) {
        this.startController = controller;
        this.startControllerPose = this.dh.vrPlayer.vrdata_world_pre.getController(controller);
        this.startPosition = this.position;
        this.startRotation = this.rotation.copy();
        this.quickMode = quickMode;
    }

    public void startMoving(int controller) {
        this.startMoving(controller, false);
    }

    public void stopMoving() {
        this.startControllerPose = null;
    }
}

