/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.BlockTags;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.common.network.CommonNetworkHelper;

public class ClimbTracker
extends Tracker {
    public static final ModelResourceLocation clawsModel = new ModelResourceLocation("vivecraft", "climb_claws", "inventory");
    private final boolean[] latched = new boolean[2];
    private final boolean[] wasinblock = new boolean[2];
    private final boolean[] wasbutton = new boolean[2];
    private final boolean[] waslatched = new boolean[2];
    public Set<Block> blocklist = new HashSet<Block>();
    public byte serverblockmode = 0;
    private boolean gravityOverride = false;
    public boolean forceActivate = false;
    public Vec3[] latchStart = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    public Vec3[] latchStart_room = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    public Vec3[] latchStartBody = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    public int latchStartController = -1;
    boolean wantjump = false;
    AABB[] box = new AABB[2];
    AABB[] latchbox = new AABB[2];
    boolean[] inblock = new boolean[2];
    int[] meta = new int[2];
    private final AABB northbb = new AABB(0.1, 0.0, 0.9, 0.9, 1.0, 1.1);
    private final AABB southBB = new AABB(0.1, 0.0, -0.1, 0.9, 1.0, 0.1);
    private final AABB westBB = new AABB(0.9, 0.0, 0.1, 1.1, 1.0, 0.9);
    private final AABB eastBB = new AABB(-0.1, 0.0, 0.1, 0.1, 1.0, 0.9);
    private final AABB upBB = new AABB(0.0, 0.9, 0.0, 1.0, 1.1, 1.0);
    private final AABB fullBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final Random rand = new Random();
    boolean unsetflag;

    public ClimbTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public boolean isGrabbingLadder() {
        return this.latched[0] || this.latched[1];
    }

    public boolean wasGrabbingLadder() {
        return this.waslatched[0] || this.latched[1];
    }

    public boolean isGrabbingLadder(int controller) {
        return this.latched[controller];
    }

    public boolean wasGrabbingLadder(int controller) {
        return this.waslatched[controller];
    }

    public boolean isClaws(ItemStack i) {
        if (i.m_41619_()) {
            return false;
        }
        if (!i.m_41788_()) {
            return false;
        }
        if (i.m_41720_() != Items.f_42574_) {
            return false;
        }
        if (!i.m_41782_() || !i.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return i.m_41786_().m_214077_() instanceof TranslatableContents && ((TranslatableContents)i.m_41786_().m_214077_()).m_237508_().equals("vivecraft.item.climbclaws") || i.m_41786_().getString().equals("Climb Claws");
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !ClientDataHolderVR.getInstance().vrSettings.simulateFalling) {
            return false;
        }
        if (!this.dh.vrSettings.realisticClimbEnabled) {
            return false;
        }
        if (p != null && p.m_6084_()) {
            if (this.mc.f_91072_ == null) {
                return false;
            }
            if (p.m_20159_()) {
                return false;
            }
            return this.isClimbeyClimbEquipped() || p.f_20902_ == 0.0f && p.f_20900_ == 0.0f;
        }
        return false;
    }

    public boolean isClimbeyClimb() {
        return this.isActive(this.mc.f_91074_) && this.isClimbeyClimbEquipped();
    }

    public boolean isClimbeyClimbEquipped() {
        return ClientNetworking.serverAllowsClimbey && ((PlayerExtension)this.mc.f_91074_).vivecraft$isClimbeyClimbEquipped();
    }

    private boolean canstand(BlockPos bp, LocalPlayer p) {
        AABB aabb = p.m_9236_().m_8055_(bp).m_60812_((BlockGetter)p.m_9236_(), bp).m_83215_();
        if (aabb != null && aabb.f_82292_ != 0.0) {
            BlockPos blockpos = bp.m_7494_();
            AABB aabb1 = p.m_9236_().m_8055_(blockpos).m_60812_((BlockGetter)p.m_9236_(), blockpos).m_83215_();
            if (aabb1 != null && aabb1.f_82292_ > 0.0) {
                return false;
            }
            BlockPos blockpos1 = blockpos.m_7494_();
            AABB aabb2 = p.m_9236_().m_8055_(blockpos1).m_60812_((BlockGetter)p.m_9236_(), blockpos1).m_83215_();
            return aabb2 == null || !(aabb2.f_82292_ > 0.0);
        }
        return false;
    }

    @Override
    public void idleTick(LocalPlayer player) {
        if (!this.isActive(player)) {
            this.waslatched[0] = false;
            this.waslatched[1] = false;
        }
        if (this.wasGrabbingLadder() && !this.isGrabbingLadder()) {
            this.forceActivate = true;
        } else if (this.mc.f_91074_.m_20096_() || this.mc.f_91074_.m_150110_().f_35935_) {
            this.forceActivate = false;
        }
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.RIGHT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inblock[0] || this.forceActivate));
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.LEFT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inblock[1] || this.forceActivate));
    }

    @Override
    public void reset(LocalPlayer player) {
        this.latchStartController = -1;
        this.latched[0] = false;
        this.latched[1] = false;
        player.m_20242_(false);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        boolean[] aboolean = new boolean[2];
        boolean[] aboolean1 = new boolean[2];
        Vec3[] avec3 = new Vec3[2];
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        for (int i = 0; i < 2; ++i) {
            avec3[i] = this.dh.vrPlayer.vrdata_world_pre.getController(i).getPosition();
            Vec3 vec3 = this.dh.vrPlayer.vrdata_world_pre.getController(i).getDirection();
            this.inblock[i] = false;
            BlockPos blockpos = BlockPos.m_274446_((Position)avec3[i]);
            BlockState blockstate = this.mc.f_91073_.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)this.mc.f_91073_, blockpos);
            this.box[i] = voxelshape.m_83281_() ? null : voxelshape.m_83215_();
            if (!this.dh.climbTracker.isClimbeyClimb()) {
                BlockPos blockpos1;
                Object blockstate1;
                Block block1;
                boolean flag4;
                Vec3 vec31 = this.dh.vrPlayer.vrdata_world_pre.getController(i).getPosition().m_82546_(vec3.m_82490_(0.2));
                AABB aabb = new AABB(avec3[i], vec31);
                flag3 = true;
                boolean bl = flag4 = block instanceof LadderBlock || block instanceof VineBlock || blockstate.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE);
                if (!flag4 && ((block1 = (blockstate1 = this.mc.f_91073_.m_8055_(blockpos1 = BlockPos.m_274446_((Position)vec31))).m_60734_()) instanceof LadderBlock || block1 instanceof VineBlock || blockstate1.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE))) {
                    blockpos = blockpos1;
                    blockstate = blockstate1;
                    block = blockstate1.m_60734_();
                    avec3[i] = vec31;
                    VoxelShape voxelshape1 = blockstate1.m_60812_((BlockGetter)this.mc.f_91073_, blockpos1);
                    if (voxelshape1.m_83281_()) {
                        this.box[i] = null;
                        flag4 = false;
                    } else {
                        flag4 = true;
                        this.box[i] = voxelshape1.m_83215_();
                    }
                }
                if (flag4) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    if (block instanceof LadderBlock) {
                        switch ((Direction)blockstate.m_61143_((Property)LadderBlock.f_54337_)) {
                            case DOWN: {
                                flag4 = false;
                                break;
                            }
                            case EAST: {
                                list.add(this.eastBB);
                                break;
                            }
                            case NORTH: {
                                list.add(this.northbb);
                                break;
                            }
                            case SOUTH: {
                                list.add(this.southBB);
                                break;
                            }
                            case UP: {
                                list.add(this.upBB);
                                break;
                            }
                            case WEST: {
                                list.add(this.westBB);
                                break;
                            }
                            default: {
                                flag4 = false;
                            }
                        }
                    }
                    if (block instanceof VineBlock) {
                        flag4 = true;
                        this.box[i] = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        if (((Boolean)blockstate.m_61143_((Property)VineBlock.f_57834_)).booleanValue() && this.mc.f_91073_.m_8055_(blockpos.m_122012_()).m_60815_()) {
                            list.add(this.southBB);
                        }
                        if (((Boolean)blockstate.m_61143_((Property)VineBlock.f_57835_)).booleanValue() && this.mc.f_91073_.m_8055_(blockpos.m_122029_()).m_60815_()) {
                            list.add(this.westBB);
                        }
                        if (((Boolean)blockstate.m_61143_((Property)VineBlock.f_57836_)).booleanValue() && this.mc.f_91073_.m_8055_(blockpos.m_122019_()).m_60815_()) {
                            list.add(this.northbb);
                        }
                        if (((Boolean)blockstate.m_61143_((Property)VineBlock.f_57837_)).booleanValue() && this.mc.f_91073_.m_8055_(blockpos.m_122024_()).m_60815_()) {
                            list.add(this.eastBB);
                        }
                    }
                    this.inblock[i] = false;
                    if (flag4) {
                        blockstate1 = list.iterator();
                        while (blockstate1.hasNext()) {
                            AABB aabb2 = (AABB)blockstate1.next();
                            if (!aabb.m_82381_(aabb2.m_82338_(blockpos))) continue;
                            this.inblock[i] = true;
                            if (aabb2 == this.northbb) {
                                this.meta[i] = 2;
                            } else if (aabb2 == this.southBB) {
                                this.meta[i] = 3;
                            } else if (aabb2 == this.eastBB) {
                                this.meta[i] = 5;
                            } else if (aabb2 == this.westBB) {
                                this.meta[i] = 4;
                            }
                            break;
                        }
                    }
                } else {
                    Vec3 vec311 = this.latchStart[i].m_82546_(avec3[i]);
                    double d9 = vec311.m_82553_();
                    if (d9 > 0.5) {
                        this.inblock[i] = false;
                    } else {
                        BlockPos blockpos5 = BlockPos.m_274446_((Position)this.latchStart[i]);
                        BlockState blockstate2 = this.mc.f_91073_.m_8055_(blockpos5);
                        this.inblock[i] = this.wasinblock[i] && blockstate2.m_60734_() instanceof LadderBlock || blockstate2.m_60734_() instanceof VineBlock || blockstate2.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE);
                    }
                }
                aboolean[i] = this.inblock[i];
                aboolean1[i] = this.inblock[i];
            } else {
                Vec3 vec310;
                double d7;
                if (this.mc.f_91074_.m_20096_()) {
                    this.mc.f_91074_.m_6853_(!this.latched[0] && !this.latched[1]);
                }
                aboolean[i] = i == 0 ? VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) : VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT);
                boolean bl = this.inblock[i] = this.box[i] != null && this.box[i].m_82338_(blockpos).m_82390_(avec3[i]);
                if (!this.inblock[i] && (d7 = (vec310 = this.latchStart[i].m_82546_(avec3[i])).m_82553_()) > 0.5) {
                    aboolean[i] = false;
                }
                aboolean1[i] = this.allowed(blockstate);
            }
            this.waslatched[i] = this.latched[i];
            if (!aboolean[i] && this.latched[i]) {
                this.latched[i] = false;
                if (i == 0) {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                } else {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
                }
                flag2 = true;
            }
            if (!this.latched[i] && !flag && aboolean1[i]) {
                if (!this.wasinblock[i] && this.inblock[i]) {
                    this.dh.vr.triggerHapticPulse(i, 750);
                }
                if (!this.wasinblock[i] && this.inblock[i] && aboolean[i] || !this.wasbutton[i] && aboolean[i] && this.inblock[i]) {
                    flag1 = true;
                    this.wantjump = false;
                    this.latchStart[i] = avec3[i];
                    this.latchStart_room[i] = this.dh.vrPlayer.vrdata_room_pre.getController(i).getPosition();
                    this.latchStartBody[i] = player.m_20182_();
                    this.latchStartController = i;
                    this.latchbox[i] = this.box[i];
                    this.latched[i] = true;
                    if (i == 0) {
                        this.latched[1] = false;
                        flag = true;
                    } else {
                        this.latched[0] = false;
                    }
                    this.dh.vr.triggerHapticPulse(i, 2000);
                    ((PlayerExtension)this.mc.f_91074_).vivecraft$stepSound(blockpos, this.latchStart[i]);
                    if (!flag3) {
                        this.dh.vrPlayer.blockDust(this.latchStart[i].f_82479_, this.latchStart[i].f_82480_, this.latchStart[i].f_82481_, 5, blockpos, blockstate, 0.1f, 0.2f);
                    }
                }
            }
            this.wasbutton[i] = aboolean[i];
            this.wasinblock[i] = this.inblock[i];
        }
        if (!this.latched[0] && !this.latched[1]) {
            for (int k = 0; k < 2; ++k) {
                if (!this.inblock[k] || !aboolean[k] || !aboolean1[k]) continue;
                flag1 = true;
                this.latchStart[k] = avec3[k];
                this.latchStart_room[k] = this.dh.vrPlayer.vrdata_room_pre.getController(k).getPosition();
                this.latchStartBody[k] = player.m_20182_();
                this.latchStartController = k;
                this.latched[k] = true;
                this.latchbox[k] = this.box[k];
                this.wantjump = false;
                this.dh.vr.triggerHapticPulse(k, 2000);
                BlockPos blockpos4 = BlockPos.m_274446_((Position)this.latchStart[k]);
                BlockState blockstate4 = this.mc.f_91073_.m_8055_(blockpos4);
                if (flag3) continue;
                this.dh.vrPlayer.blockDust(this.latchStart[k].f_82479_, this.latchStart[k].f_82480_, this.latchStart[k].f_82481_, 5, blockpos4, blockstate4, 0.1f, 0.2f);
            }
        }
        if (!this.wantjump && !flag3) {
            this.wantjump = VivecraftVRMod.INSTANCE.keyClimbeyJump.m_90857_() && this.dh.jumpTracker.isClimbeyJumpEquipped();
        }
        flag2 &= this.wantjump;
        if ((this.latched[0] || this.latched[1]) && !this.gravityOverride) {
            this.unsetflag = true;
            player.m_20242_(true);
            this.gravityOverride = true;
        }
        if (!this.latched[0] && !this.latched[1] && this.gravityOverride) {
            player.m_20242_(false);
            this.gravityOverride = false;
        }
        if (!(this.latched[0] || this.latched[1] || flag2)) {
            if (player.m_20096_() && this.unsetflag) {
                this.unsetflag = false;
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
            }
            this.latchStartController = -1;
        } else {
            if ((this.latched[0] || this.latched[1]) && this.rand.nextInt(20) == 10) {
                this.mc.f_91074_.m_36399_(0.1f);
                BlockPos blockpos3 = BlockPos.m_274446_((Position)this.latchStart[this.latchStartController]);
                BlockState blockstate3 = this.mc.f_91073_.m_8055_(blockpos3);
                if (!flag3) {
                    this.dh.vrPlayer.blockDust(this.latchStart[this.latchStartController].f_82479_, this.latchStart[this.latchStartController].f_82480_, this.latchStart[this.latchStartController].f_82481_, 1, blockpos3, blockstate3, 0.1f, 0.2f);
                }
            }
            Vec3 vec34 = this.dh.vrPlayer.vrdata_world_pre.getController(this.latchStartController).getPosition();
            VRPlayer vrplayer = this.dh.vrPlayer;
            Vec3 vec35 = VRPlayer.room_to_world_pos(this.latchStart_room[this.latchStartController], this.dh.vrPlayer.vrdata_world_pre);
            Vec3 vec36 = vec34.m_82546_(vec35);
            this.latchStart_room[this.latchStartController] = this.dh.vrPlayer.vrdata_room_pre.getController(this.latchStartController).getPosition();
            if (this.wantjump) {
                this.dh.vr.triggerHapticPulse(this.latchStartController, 200);
            }
            if (!flag2) {
                Vec3 vec37 = this.latchStart[this.latchStartController];
                if (flag1) {
                    player.m_20334_(0.0, 0.0, 0.0);
                } else {
                    player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
                }
                player.f_19789_ = 0.0f;
                double d4 = player.m_20185_();
                double d6 = player.m_20186_();
                double d8 = player.m_20189_();
                double d10 = d4;
                double d0 = d8;
                double d11 = d6 - vec36.f_82480_;
                BlockPos blockpos2 = BlockPos.m_274446_((Position)vec37);
                if (!flag3) {
                    d10 = d4 - vec36.f_82479_;
                    d0 = d8 - vec36.f_82481_;
                } else {
                    int j = this.meta[this.latchStartController];
                    if (j != 2 && j != 3) {
                        if (j == 4 || j == 5) {
                            d0 = d8 - vec36.f_82481_;
                            d10 = (float)blockpos2.m_123341_() + 0.5f;
                            d10 += (1.0 - Math.min((double)ClientDataHolderVR.getInstance().vrPlayer.worldScale, 1.0)) * (j == 4 ? 0.5 : -0.5);
                        }
                    } else {
                        d10 = d4 - vec36.f_82479_;
                        d0 = (float)blockpos2.m_123343_() + 0.5f;
                        d0 += (1.0 - Math.min((double)ClientDataHolderVR.getInstance().vrPlayer.worldScale, 1.0)) * (j == 2 ? 0.5 : -0.5);
                    }
                }
                double d12 = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot().f_82480_;
                double d1 = this.dh.vrPlayer.vrdata_room_pre.getController((int)this.latchStartController).getPosition().f_82480_;
                if (!this.wantjump && this.latchbox[this.latchStartController] != null && d1 <= d12 / 2.0 && this.latchStart[this.latchStartController].f_82480_ > this.latchbox[this.latchStartController].f_82292_ * 0.8 + (double)blockpos2.m_123342_()) {
                    Vec3 vec32 = this.dh.vrPlayer.vrdata_world_pre.hmd.getDirection().m_82490_((double)0.1f);
                    Vec3 vec33 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_().m_82490_(0.1);
                    boolean flag5 = this.mc.f_91073_.m_45756_((Entity)player, player.m_20191_().m_82386_(vec33.f_82479_, this.latchbox[this.latchStartController].f_82292_ + (double)blockpos2.m_123342_() - player.m_20186_(), vec33.f_82481_));
                    if (flag5) {
                        d10 = player.m_20185_() + vec33.f_82479_;
                        d11 = this.latchbox[this.latchStartController].f_82292_ + (double)blockpos2.m_123342_();
                        d0 = player.m_20189_() + vec33.f_82481_;
                        this.latchStartController = -1;
                        this.latched[0] = false;
                        this.latched[1] = false;
                        this.wasinblock[0] = false;
                        this.wasinblock[1] = false;
                        player.m_20242_(false);
                    }
                }
                boolean flag6 = false;
                for (int l = 0; l < 8; ++l) {
                    double d13 = d10;
                    double d2 = d11;
                    double d3 = d0;
                    switch (l) {
                        default: {
                            break;
                        }
                        case 2: {
                            d2 = d6;
                            break;
                        }
                        case 3: {
                            d3 = d8;
                            break;
                        }
                        case 4: {
                            d13 = d4;
                            break;
                        }
                        case 5: {
                            d13 = d4;
                            d3 = d8;
                            break;
                        }
                        case 6: {
                            d13 = d4;
                            d2 = d6;
                            break;
                        }
                        case 7: {
                            d2 = d6;
                            d3 = d8;
                        }
                    }
                    player.m_6034_(d13, d2, d3);
                    AABB aabb1 = player.m_20191_();
                    flag6 = this.mc.f_91073_.m_45756_((Entity)player, aabb1);
                    if (!flag6) continue;
                    if (l <= 1) break;
                    this.dh.vr.triggerHapticPulse(0, 100);
                    this.dh.vr.triggerHapticPulse(1, 100);
                    break;
                }
                if (!flag6) {
                    player.m_6034_(d4, d6, d8);
                    this.dh.vr.triggerHapticPulse(0, 100);
                    this.dh.vr.triggerHapticPulse(1, 100);
                }
                if (this.mc.m_91090_()) {
                    for (ServerPlayer serverplayer : this.mc.m_91092_().m_6846_().m_11314_()) {
                        if (serverplayer.m_19879_() != this.mc.f_91074_.m_19879_()) continue;
                        serverplayer.f_19789_ = 0.0f;
                    }
                } else {
                    ServerboundCustomPayloadPacket serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.CLIMBING, new byte[0]);
                    if (this.mc.m_91403_() != null) {
                        this.mc.m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
                    }
                }
            } else {
                this.wantjump = false;
                Vec3 vec38 = player.m_20182_().m_82546_(vec36);
                Vec3 vec39 = this.dh.vr.controllerHistory[this.latchStartController].netMovement(0.3);
                double d5 = this.dh.vr.controllerHistory[this.latchStartController].averageSpeed(0.3f);
                vec39 = vec39.m_82490_(0.66 * d5);
                float f = 0.66f;
                if (vec39.m_82553_() > (double)f) {
                    vec39 = vec39.m_82490_((double)f / vec39.m_82553_());
                }
                if (player.m_21023_(MobEffects.f_19603_)) {
                    vec39 = vec39.m_82490_((double)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.5);
                }
                vec39 = vec39.m_82524_(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
                player.m_20256_(vec39.m_82542_(-1.0, -1.0, -1.0));
                player.f_19790_ = vec38.f_82479_;
                player.f_19791_ = vec38.f_82480_;
                player.f_19792_ = vec38.f_82481_;
                vec38 = vec38.m_82520_(player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_);
                player.m_6034_(vec38.f_82479_, vec38.f_82480_, vec38.f_82481_);
                this.dh.vrPlayer.snapRoomOriginToPlayerEntity(player, false, false);
                this.mc.f_91074_.m_36399_(0.3f);
            }
        }
    }

    private boolean allowed(BlockState bs) {
        if (this.serverblockmode == 0) {
            return true;
        }
        if (this.serverblockmode == 1) {
            return this.blocklist.contains(bs.m_60734_());
        }
        if (this.serverblockmode == 2) {
            return !this.blocklist.contains(bs.m_60734_());
        }
        return false;
    }
}

