/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.mod_compat_vr.pehkui.PehkuiHelper;

public class CrawlTracker
extends Tracker {
    private boolean wasCrawling;
    public boolean crawling;
    public boolean crawlsteresis;

    public CrawlTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.allowCrawling) {
            return false;
        }
        if (!ClientNetworking.serverAllowsCrawling) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        return !player.m_20159_();
    }

    @Override
    public void reset(LocalPlayer player) {
        this.crawling = false;
        this.crawlsteresis = false;
        this.updateState(player);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        double scaleMultiplier = 1.0;
        if (Xplat.isModLoaded("pehkui")) {
            scaleMultiplier /= (double)PehkuiHelper.getPlayerScale((Entity)player, this.mc.m_91296_());
        }
        this.crawling = this.dh.vr.hmdPivotHistory.averagePosition((double)((double)0.2f)).f_82480_ * (double)this.dh.vrPlayer.worldScale * scaleMultiplier + (double)0.1f < (double)this.dh.vrSettings.crawlThreshold;
        this.updateState(player);
    }

    private void updateState(LocalPlayer player) {
        if (this.crawling != this.wasCrawling) {
            if (this.crawling) {
                player.m_20124_(Pose.SWIMMING);
                this.crawlsteresis = true;
            }
            if (ClientNetworking.serverAllowsCrawling) {
                ServerboundCustomPayloadPacket serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.CRAWL, new byte[]{(byte)(this.crawling ? 1 : 0)});
                if (this.mc.m_91403_() != null) {
                    this.mc.m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
                }
            }
            this.wasCrawling = this.crawling;
        }
        if (!this.crawling && player.m_20089_() != Pose.SWIMMING) {
            this.crawlsteresis = false;
        }
    }
}

