/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;

public class InteractTracker
extends Tracker {
    public boolean[] bukkit = new boolean[2];
    public int hotbar = -1;
    private final boolean[] inBow = new boolean[2];
    public BlockHitResult[] inBlockHit = new BlockHitResult[2];
    BlockPos[] inBlockPos = new BlockPos[2];
    Entity[] inEntity = new Entity[2];
    private final EntityHitResult[] inEntityHit = new EntityHitResult[2];
    private final boolean[] inCamera = new boolean[2];
    private final boolean[] inHandheldCamera = new boolean[2];
    boolean[] active = new boolean[2];
    boolean[] wasactive = new boolean[2];
    private HashSet<Class> rightClickable = null;

    public InteractTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (p == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        if (p.m_5803_()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (dataholder.vrSettings.seated) {
            return false;
        }
        return !p.m_21254_() || this.hotbar >= 0;
    }

    @Override
    public void reset(LocalPlayer player) {
        for (int i = 0; i < 2; ++i) {
            this.reset(player, i);
        }
    }

    private void reset(LocalPlayer player, int c) {
        if (this.inCamera[c] && VRHotkeys.isMovingThirdPersonCam() && VRHotkeys.getMovingThirdPersonCamTriggerer() == VRHotkeys.Triggerer.INTERACTION && VRHotkeys.getMovingThirdPersonCamController() == c) {
            VRHotkeys.stopMovingThirdPersonCam();
        }
        if (this.inHandheldCamera[c] && this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.getMovingController() == c && !this.dh.cameraTracker.isQuickMode()) {
            this.dh.cameraTracker.stopMoving();
        }
        this.inBow[c] = false;
        this.inBlockPos[c] = null;
        this.inBlockHit[c] = null;
        this.inEntity[c] = null;
        this.inEntityHit[c] = null;
        this.inCamera[c] = false;
        this.inHandheldCamera[c] = false;
        this.active[c] = false;
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], false);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        if (this.rightClickable == null) {
            this.rightClickable = new HashSet();
            String name = Xplat.getUseMethodName();
            for (Object object : BuiltInRegistries.f_256975_) {
                Class<?> oclass = object.getClass();
                try {
                    if (oclass.getMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class).getDeclaringClass() == oclass) {
                        this.rightClickable.add(oclass);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                oclass = oclass.getSuperclass();
                try {
                    if (oclass.getMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class).getDeclaringClass() != oclass) continue;
                    this.rightClickable.add(oclass);
                }
                catch (Throwable throwable) {}
            }
            this.rightClickable.remove(Block.class);
            this.rightClickable.remove(BlockBehaviour.class);
            this.rightClickable.remove(BlockBehaviour.BlockStateBase.class);
        }
        Vec3 vec34 = new Vec3(0.0, 0.0, -1.0);
        for (int j = 0; j < 2; ++j) {
            if ((this.inCamera[j] || this.inHandheldCamera[j] || this.inBow[j]) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.values()[j])) continue;
            this.reset(player, j);
            if (j == 0 && this.hotbar >= 0) {
                this.active[j] = true;
            }
            if (!this.active[j] && this.dh.bowTracker.isNotched() && j == 0) {
                this.inBow[j] = true;
                this.active[j] = true;
            }
            Vec3 vec35 = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot();
            Vec3 vec3 = this.dh.vrPlayer.vrdata_world_pre.getController(j).getPosition();
            Vec3 vec31 = this.dh.vrPlayer.vrdata_world_pre.getHand(j).getCustomVector(vec34);
            ItemStack itemstack = player.m_21120_(j == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            Object item = null;
            if (!this.active[j] && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) && this.dh.vrSettings.mixedRealityRenderCameraModel) {
                VRData.VRDevicePose vrdata$vrdevicepose = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.THIRD);
                Vec3 vec32 = vrdata$vrdevicepose.getPosition();
                vec32 = vec32.m_82546_(vrdata$vrdevicepose.getCustomVector(new Vec3(0.0, 0.0, -1.0)).m_82490_((double)0.15f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale));
                if (vec3.m_82554_(vec32 = vec32.m_82546_(vrdata$vrdevicepose.getCustomVector(new Vec3(0.0, -1.0, 0.0)).m_82490_((double)0.05f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale))) < (double)0.15f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inCamera[j] = true;
                    this.active[j] = true;
                }
            }
            if (!this.active[j] && this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode()) {
                VRData.VRDevicePose vrdata$vrdevicepose1 = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.CAMERA);
                Vec3 vec36 = vrdata$vrdevicepose1.getPosition();
                if (vec3.m_82554_(vec36 = vec36.m_82546_(vrdata$vrdevicepose1.getCustomVector(new Vec3(0.0, 0.0, -1.0)).m_82490_((double)0.08f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale))) < (double)0.11f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inHandheldCamera[j] = true;
                    this.active[j] = true;
                }
            }
            if (this.dh.vrSettings.realisticEntityInteractEnabled && !this.active[j]) {
                int k = Mth.m_14107_((double)vec3.f_82479_);
                int l = Mth.m_14107_((double)vec3.f_82480_);
                int i = Mth.m_14107_((double)vec3.f_82481_);
                Vec3 vec33 = new Vec3(vec3.f_82479_ + vec31.f_82479_ * -0.1, vec3.f_82480_ + vec31.f_82480_ * -0.1, vec3.f_82481_ + vec31.f_82481_ * -0.1);
                AABB aabb = new AABB(vec3, vec33);
                this.inEntityHit[j] = ProjectileUtil.m_37287_((Entity)this.mc.m_91288_(), (Vec3)vec35, (Vec3)vec3, (AABB)aabb, e -> !e.m_5833_() && e.m_6087_() && e != this.mc.m_91288_().m_20202_(), (double)0.0);
                if (this.inEntityHit[j] != null) {
                    Entity entity;
                    this.inEntity[j] = entity = this.inEntityHit[j].m_82443_();
                    this.active[j] = true;
                }
            }
            if (this.dh.vrSettings.realisticBlockInteractEnabled && !this.active[j]) {
                BlockPos blockpos = null;
                blockpos = BlockPos.m_274446_((Position)vec3);
                BlockState blockstate = this.mc.f_91073_.m_8055_(blockpos);
                BlockHitResult blockhitresult = blockstate.m_60808_((BlockGetter)this.mc.f_91073_, blockpos).m_83220_(vec35, vec3, blockpos);
                this.inBlockPos[j] = blockpos;
                this.inBlockHit[j] = blockhitresult;
                this.active[j] = blockhitresult != null && (this.rightClickable.contains(blockstate.m_60734_().getClass()) || this.rightClickable.contains(blockstate.m_60734_().getClass().getSuperclass()));
                this.bukkit[j] = false;
                if (!this.active[j] && itemstack.m_41720_() == Items.f_42446_ && blockstate.m_278721_()) {
                    this.active[j] = true;
                    this.bukkit[j] = true;
                }
            }
            if (!this.wasactive[j] && this.active[j]) {
                this.dh.vr.triggerHapticPulse(j, 250);
            }
            this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[j], this.active[j]);
            this.wasactive[j] = this.active[j];
        }
    }

    public boolean isInteractActive(int controller) {
        return this.active[controller];
    }

    public boolean isInCamera() {
        return this.inCamera[0] || this.inCamera[1];
    }

    public boolean isInHandheldCamera() {
        return this.inHandheldCamera[0] || this.inHandheldCamera[1];
    }

    public void processBindings() {
        for (int i = 0; i < 2; ++i) {
            if (!VivecraftVRMod.INSTANCE.keyVRInteract.consumeClick(ControllerType.values()[i]) || !this.active[i]) continue;
            InteractionHand interactionhand = InteractionHand.values()[i];
            boolean flag = false;
            if (this.hotbar >= 0 && this.hotbar < 9 && this.mc.f_91074_.m_150109_().f_35977_ != this.hotbar && interactionhand == InteractionHand.MAIN_HAND) {
                this.mc.f_91074_.m_150109_().f_35977_ = this.hotbar;
                flag = true;
            } else if (this.hotbar == 9 && interactionhand == InteractionHand.MAIN_HAND) {
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                flag = true;
            } else if (this.inCamera[i]) {
                VRHotkeys.startMovingThirdPersonCam(i, VRHotkeys.Triggerer.INTERACTION);
                flag = true;
            } else if (this.inHandheldCamera[i]) {
                this.dh.cameraTracker.startMoving(i);
                flag = true;
            } else if (this.inEntityHit[i] != null) {
                flag = this.mc.f_91072_.m_105230_((Player)this.mc.f_91074_, this.inEntity[i], this.inEntityHit[i], interactionhand).m_19077_() || this.mc.f_91072_.m_105226_((Player)this.mc.f_91074_, this.inEntity[i], interactionhand).m_19077_();
            } else if (this.inBlockHit[i] != null) {
                flag = this.mc.f_91072_.m_233732_(this.mc.f_91074_, interactionhand, this.inBlockHit[i]).m_19077_();
            } else if (this.bukkit[i]) {
                flag = this.mc.f_91072_.m_233721_((Player)this.mc.f_91074_, interactionhand).m_19077_();
            }
            if (!flag) continue;
            ((PlayerExtension)this.mc.f_91074_).vivecraft$swingArm(interactionhand, VRFirstPersonArmSwing.Interact);
            this.dh.vr.triggerHapticPulse(i, 750);
        }
    }
}

