/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;

public class JumpTracker
extends Tracker {
    public Vec3[] latchStart = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    public Vec3[] latchStartOrigin = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    public Vec3[] latchStartPlayer = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    private boolean c0Latched = false;
    private boolean c1Latched = false;

    public JumpTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public boolean isClimbeyJump() {
        return this.isActive(Minecraft.m_91087_().f_91074_) && this.isClimbeyJumpEquipped();
    }

    public boolean isClimbeyJumpEquipped() {
        return ClientNetworking.serverAllowsClimbey && ((PlayerExtension)Minecraft.m_91087_().f_91074_).vivecraft$isClimbeyJumpEquipped();
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return false;
        }
        if (!ClientDataHolderVR.getInstance().vrPlayer.getFreeMove() && !ClientDataHolderVR.getInstance().vrSettings.simulateFalling) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.OFF) {
            return false;
        }
        if (p != null && p.m_6084_()) {
            if (this.mc.f_91072_ == null) {
                return false;
            }
            if (!p.m_20069_() && !p.m_20077_() && p.m_20096_()) {
                return !p.m_6144_() && !p.m_20159_();
            }
            return false;
        }
        return false;
    }

    public boolean isjumping() {
        return this.c1Latched || this.c0Latched;
    }

    @Override
    public void idleTick(LocalPlayer player) {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyJump).setEnabled(this.isClimbeyJumpEquipped() && (this.isActive(player) || this.dh.climbTracker.isClimbeyClimbEquipped() && this.dh.climbTracker.isGrabbingLadder()));
    }

    @Override
    public void reset(LocalPlayer player) {
        this.c1Latched = false;
        this.c0Latched = false;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        boolean climbeyEquipped = this.isClimbeyJumpEquipped();
        if (climbeyEquipped) {
            VRPlayer vrplayer = this.dh.vrPlayer;
            boolean[] aboolean = new boolean[2];
            for (int i = 0; i < 2; ++i) {
                aboolean[i] = VivecraftVRMod.INSTANCE.keyClimbeyJump.m_90857_();
            }
            boolean flag = false;
            if (!aboolean[0] && this.c0Latched) {
                this.dh.vr.triggerHapticPulse(0, 200);
                flag = true;
            }
            Vec3 vec3 = this.dh.vrPlayer.vrdata_room_pre.getController(0).getPosition();
            Vec3 vec31 = this.dh.vrPlayer.vrdata_room_pre.getController(1).getPosition();
            Vec3 vec32 = vec3.m_82549_(vec31).m_82490_(0.5);
            if (aboolean[0] && !this.c0Latched) {
                this.latchStart[0] = vec32;
                this.latchStartOrigin[0] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[0] = this.mc.f_91074_.m_20182_();
                this.dh.vr.triggerHapticPulse(0, 1000);
            }
            if (!aboolean[1] && this.c1Latched) {
                this.dh.vr.triggerHapticPulse(1, 200);
                flag = true;
            }
            if (aboolean[1] && !this.c1Latched) {
                this.latchStart[1] = vec32;
                this.latchStartOrigin[1] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[1] = this.mc.f_91074_.m_20182_();
                this.dh.vr.triggerHapticPulse(1, 1000);
            }
            this.c0Latched = aboolean[0];
            this.c1Latched = aboolean[1];
            int j = 0;
            Vec3 vec33 = vec32.m_82546_(this.latchStart[j]);
            vec33 = vec33.m_82524_(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            if (!flag && this.isjumping()) {
                this.dh.vr.triggerHapticPulse(0, 200);
                this.dh.vr.triggerHapticPulse(1, 200);
            }
            if (flag) {
                this.dh.climbTracker.forceActivate = true;
                Vec3 vec34 = this.dh.vr.controllerHistory[0].netMovement(0.3).m_82549_(this.dh.vr.controllerHistory[1].netMovement(0.3));
                double d0 = (this.dh.vr.controllerHistory[0].averageSpeed(0.3) + this.dh.vr.controllerHistory[1].averageSpeed(0.3)) / 2.0;
                vec34 = vec34.m_82490_((double)0.33f * d0);
                float f = 0.66f;
                if (vec34.m_82553_() > (double)f) {
                    vec34 = vec34.m_82490_((double)f / vec34.m_82553_());
                }
                if (player.m_21023_(MobEffects.f_19603_)) {
                    vec34 = vec34.m_82490_((double)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.5);
                }
                vec34 = vec34.m_82524_(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
                Vec3 vec35 = this.mc.f_91074_.m_20182_().m_82546_(vec33);
                if (vec33.f_82480_ < 0.0 && vec34.f_82480_ < 0.0) {
                    double d2 = -vec34.f_82479_;
                    double d1 = player.m_20184_().f_82479_ + d2 * 1.25;
                    d2 = -vec34.f_82480_;
                    double d3 = -vec34.f_82481_;
                    player.m_20334_(d1, d2, player.m_20184_().f_82481_ + d3 * 1.25);
                    player.f_19790_ = vec35.f_82479_;
                    player.f_19791_ = vec35.f_82480_;
                    player.f_19792_ = vec35.f_82481_;
                    vec35 = vec35.m_82549_(player.m_20184_());
                    player.m_6034_(vec35.f_82479_, vec35.f_82480_, vec35.f_82481_);
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity(player, false, true);
                    this.mc.f_91074_.m_36399_(0.3f);
                    this.mc.f_91074_.m_6853_(false);
                } else {
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity(player, false, true);
                }
            } else if (this.isjumping()) {
                Vec3 vec36 = this.latchStartOrigin[0].m_82546_(this.latchStartPlayer[0]).m_82549_(this.mc.f_91074_.m_20182_()).m_82546_(vec33);
                this.dh.vrPlayer.setRoomOrigin(vec36.f_82479_, vec36.f_82480_, vec36.f_82481_, false);
            }
        }
        if ((!climbeyEquipped || ClientDataHolderVR.getInstance().vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.ON) && this.dh.vr.hmdPivotHistory.netMovement((double)0.25).f_82480_ > 0.1 && this.dh.vr.hmdPivotHistory.latest().f_82480_ - (double)AutoCalibration.getPlayerHeight() > (double)this.dh.vrSettings.jumpThreshold) {
            player.m_6135_();
        }
    }

    public boolean isBoots(ItemStack i) {
        if (i.m_41619_()) {
            return false;
        }
        if (!i.m_41788_()) {
            return false;
        }
        if (i.m_41720_() != Items.f_42463_) {
            return false;
        }
        if (!i.m_41782_() || !i.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return i.m_41786_().m_214077_() instanceof TranslatableContents && ((TranslatableContents)i.m_41786_().m_214077_()).m_237508_().equals("vivecraft.item.jumpboots") || i.m_41786_().getString().equals("Jump Boots");
    }
}

