/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Quaternion;

public class RowTracker
extends Tracker {
    Vec3[] lastUWPs = new Vec3[2];
    public double[] forces = new double[]{0.0, 0.0};
    double transmissionEfficiency = 0.9;
    public float LOar;
    public float ROar;
    public float Foar;

    public RowTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return false;
        }
        if (!ClientDataHolderVR.getInstance().vrSettings.realisticRowEnabled) {
            return false;
        }
        if (p != null && p.m_6084_()) {
            if (this.mc.f_91072_ == null) {
                return false;
            }
            if (Minecraft.m_91087_().f_91066_.f_92085_.m_90857_()) {
                return false;
            }
            if (!(p.m_20202_() instanceof Boat)) {
                return false;
            }
            return !ClientDataHolderVR.getInstance().bowTracker.isNotched();
        }
        return false;
    }

    public boolean isRowing() {
        return this.ROar + this.LOar + this.Foar > 0.0f;
    }

    @Override
    public void reset(LocalPlayer player) {
        this.LOar = 0.0f;
        this.ROar = 0.0f;
        this.Foar = 0.0f;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        double d0 = this.dh.vr.controllerHistory[0].averageSpeed(0.5);
        double d1 = this.dh.vr.controllerHistory[1].averageSpeed(0.5);
        float f = 0.5f;
        float f1 = 2.0f;
        this.ROar = (float)Math.max(d0 - (double)f, 0.0);
        this.LOar = (float)Math.max(d1 - (double)f, 0.0);
        float f2 = this.Foar = this.ROar > 0.0f && this.LOar > 0.0f ? (this.ROar + this.LOar) / 2.0f : 0.0f;
        if (this.Foar > f1) {
            this.Foar = f1;
        }
        if (this.ROar > f1) {
            this.ROar = f1;
        }
        if (this.LOar > f1) {
            this.LOar = f1;
        }
    }

    public void doProcessFinaltransmithastofixthis(LocalPlayer player) {
        Boat boat = (Boat)player.m_20202_();
        Quaternion quaternion = new Quaternion(boat.m_146909_(), -(boat.m_146908_() % 360.0f), 0.0f).normalized();
        for (int i = 0; i <= 1; ++i) {
            if (!this.isPaddleUnderWater(i, boat)) {
                this.forces[i] = 0.0;
                this.lastUWPs[i] = null;
                continue;
            }
            Vec3 vec3 = this.getArmToPaddleVector(i, boat);
            Vec3 vec31 = this.getAttachmentPoint(i, boat);
            Vec3 vec32 = vec31.m_82549_(vec3.m_82541_()).m_82546_(boat.m_20182_());
            if (this.lastUWPs[i] != null) {
                Vec3 vec34;
                Vec3 vec33 = this.lastUWPs[i].m_82546_(vec32);
                double d0 = (vec33 = vec33.m_82546_(boat.m_20184_())).m_82526_(vec34 = quaternion.multiply(new Vec3(0.0, 0.0, 1.0))) * this.transmissionEfficiency / 5.0;
                this.forces[i] = !(d0 < 0.0 && this.forces[i] > 0.0 || d0 > 0.0 && this.forces[i] < 0.0) ? Math.min(Math.max(d0, -0.1), 0.1) : 0.0;
            }
            this.lastUWPs[i] = vec32;
        }
    }

    Vec3 getArmToPaddleVector(int paddle, Boat boat) {
        Vec3 vec3 = this.getAttachmentPoint(paddle, boat);
        Vec3 vec31 = this.getAbsArmPos(paddle == 0 ? 1 : 0);
        return vec3.m_82546_(vec31);
    }

    Vec3 getAttachmentPoint(int paddle, Boat boat) {
        Vec3 vec3 = new Vec3((double)((paddle == 0 ? 9.0f : -9.0f) / 16.0f), 0.625, 0.1875);
        Quaternion quaternion = new Quaternion(boat.m_146909_(), -(boat.m_146908_() % 360.0f), 0.0f).normalized();
        return boat.m_20182_().m_82549_(quaternion.multiply(vec3));
    }

    Vec3 getAbsArmPos(int side) {
        Vec3 vec3 = this.dh.vr.controllerHistory[side].averagePosition(0.1);
        Quaternion quaternion = new Quaternion(0.0f, VRSettings.inst.worldRotation, 0.0f);
        return VRPlayer.get().roomOrigin.m_82549_(quaternion.multiply(vec3));
    }

    boolean isPaddleUnderWater(int paddle, Boat boat) {
        Vec3 vec3 = this.getAttachmentPoint(paddle, boat);
        Vec3 vec31 = this.getArmToPaddleVector(paddle, boat).m_82541_();
        BlockPos blockpos = BlockPos.m_274446_((Position)vec3.m_82549_(vec31));
        return boat.m_9236_().m_8055_(blockpos).m_278721_();
    }
}

