/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FakeBlockAccess
implements LevelReader {
    private final int version;
    private final long seed;
    private final DimensionType dimensionType;
    private final boolean isFlat;
    private final BlockState[] blocks;
    private final byte[] skylightmap;
    private final byte[] blocklightmap;
    private final Biome[] biomemap;
    private final short[][] heightmap;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private float ground;
    public float effectiveGround;
    private final float rotation;
    private final boolean rain;
    private final boolean thunder;
    private final BiomeManager biomeManager;
    private final DimensionSpecialEffects dimensionInfo;

    public FakeBlockAccess(int version, long seed, BlockState[] blocks, byte[] skylightmap, byte[] blocklightmap, Biome[] biomemap, short[][] heightmap, int xSize, int ySize, int zSize, int ground, DimensionType dimensionType, boolean isFlat, float rotation, boolean rain, boolean thunder) {
        this.version = version;
        this.seed = seed;
        this.blocks = blocks;
        this.skylightmap = skylightmap;
        this.blocklightmap = blocklightmap;
        this.biomemap = biomemap;
        this.heightmap = heightmap;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.ground = ground - dimensionType.f_156647_();
        this.dimensionType = dimensionType;
        this.isFlat = isFlat;
        this.rotation = rotation;
        this.rain = rain;
        this.thunder = thunder;
        this.biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)this, BiomeManager.m_47877_((long)seed));
        this.dimensionInfo = DimensionSpecialEffects.m_108876_((DimensionType)dimensionType);
        BlockPos pos = new BlockPos(0, (int)this.ground, 0);
        BlockState standing = blocks[this.encodeCoords(pos)];
        this.effectiveGround = this.ground = (float)((double)this.ground + Math.max(standing.m_60812_((BlockGetter)this, pos).m_83297_(Direction.Axis.Y), 0.0));
    }

    private int encodeCoords(int x, int z) {
        return z * this.xSize + x;
    }

    private int encodeCoords(int x, int y, int z) {
        return ((y + (int)this.effectiveGround) * this.zSize + (z + this.zSize / 2)) * this.xSize + (x + this.xSize / 2);
    }

    private int encodeCoords(BlockPos pos) {
        return this.encodeCoords(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private boolean checkCoords(int x, int y, int z) {
        return x >= -this.xSize / 2 && y >= -((int)this.effectiveGround) && z >= -this.zSize / 2 && x < this.xSize / 2 && y < this.ySize - (int)this.effectiveGround && z < this.zSize / 2;
    }

    private boolean checkCoords(BlockPos pos) {
        return this.checkCoords(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public float getGround() {
        return this.effectiveGround;
    }

    public void setGroundOffset(float offset) {
        this.effectiveGround = this.ground + offset;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public long getSeed() {
        return this.seed;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean getRain() {
        return this.rain;
    }

    public boolean getThunder() {
        return this.thunder;
    }

    public DimensionType m_6042_() {
        return this.dimensionType;
    }

    public DimensionSpecialEffects getDimensionReaderInfo() {
        return this.dimensionInfo;
    }

    public double getVoidFogYFactor() {
        return this.isFlat ? 1.0 : 0.03125;
    }

    public double getHorizon() {
        return this.isFlat ? (double)(-this.effectiveGround) : 63.0 - (double)this.effectiveGround + (double)this.m_141937_();
    }

    public BlockState m_8055_(BlockPos pos) {
        if (!this.checkCoords(pos)) {
            return Blocks.f_50752_.m_49966_();
        }
        BlockState state = this.blocks[this.encodeCoords(pos)];
        return state != null ? state : Blocks.f_50016_.m_49966_();
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public BlockEntity m_7702_(BlockPos pos) {
        return null;
    }

    public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        if (i == 0) {
            return colorResolverIn.m_130045_((Biome)this.m_204166_(blockPosIn).m_203334_(), (double)blockPosIn.m_123341_(), (double)blockPosIn.m_123343_());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        Cursor3D cursor3D = new Cursor3D(blockPosIn.m_123341_() - i, blockPosIn.m_123342_(), blockPosIn.m_123343_() - i, blockPosIn.m_123341_() + i, blockPosIn.m_123342_(), blockPosIn.m_123343_() + i);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        while (cursor3D.m_122304_()) {
            blockpos$mutable.m_122178_(cursor3D.m_122305_(), cursor3D.m_122306_(), cursor3D.m_122307_());
            int j1 = colorResolverIn.m_130045_((Biome)this.m_204166_((BlockPos)blockpos$mutable).m_203334_(), (double)blockpos$mutable.m_123341_(), (double)blockpos$mutable.m_123343_());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        if (!this.checkCoords(pos)) {
            return 0;
        }
        if (type == LightLayer.SKY) {
            return this.dimensionType.f_223549_() ? this.skylightmap[this.encodeCoords(pos)] : 0;
        }
        return type == LightLayer.BLOCK ? this.blocklightmap[this.encodeCoords(pos)] : 0;
    }

    public int m_45524_(BlockPos pos, int amount) {
        if (!this.checkCoords(pos.m_123341_(), 0, pos.m_123343_())) {
            return 0;
        }
        if (pos.m_123342_() < 0) {
            return 0;
        }
        if (pos.m_123342_() >= 256) {
            int light = 15 - amount;
            if (light < 0) {
                light = 0;
            }
            return light;
        }
        int light = (this.dimensionType.f_223549_() ? this.skylightmap[this.encodeCoords(pos)] : 0) - amount;
        int blockLight = this.blocklightmap[this.encodeCoords(pos)];
        if (blockLight > light) {
            light = blockLight;
        }
        return light;
    }

    public float m_7717_(Direction face, boolean shade) {
        boolean flag = this.dimensionInfo.m_108885_();
        if (!shade) {
            return flag ? 0.9f : 1.0f;
        }
        switch (face) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public boolean m_7232_(int x, int z) {
        return this.checkCoords(x * 16, 0, z * 16);
    }

    public ChunkAccess m_6522_(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    public int m_6924_(Heightmap.Types heightmapType, int x, int z) {
        if (heightmapType == Heightmap.Types.MOTION_BLOCKING) {
            return this.getHeightBlocking(x, z);
        }
        return 0;
    }

    public int getHeightBlocking(int x, int z) {
        return this.heightmap[x + this.xSize / 2][z + this.zSize / 2] - (int)this.effectiveGround;
    }

    public BlockPos m_5452_(Heightmap.Types heightmapType, BlockPos pos) {
        return BlockPos.f_121853_;
    }

    public int m_7445_() {
        return 0;
    }

    public WorldBorder m_6857_() {
        return new WorldBorder();
    }

    public boolean m_5450_(Entity entityIn, VoxelShape shape) {
        return false;
    }

    public List<VoxelShape> m_183134_(@Nullable Entity entityIn, AABB aabb) {
        return Collections.emptyList();
    }

    public boolean m_46859_(BlockPos pos) {
        return this.m_8055_(pos).m_60795_();
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        int xMoved = x + this.xSize / 8;
        int yMoved = y + (int)this.effectiveGround / 4;
        int zMoved = z + this.zSize / 8;
        if (!this.checkCoords(x * 4, y * 4, z * 4)) {
            xMoved = Mth.m_14045_((int)xMoved, (int)0, (int)(this.xSize / 4 - 1));
            yMoved = Mth.m_14045_((int)yMoved, (int)0, (int)((this.ySize - (int)this.effectiveGround) / 4 - 1));
            zMoved = Mth.m_14045_((int)zMoved, (int)0, (int)(this.zSize / 4 - 1));
        }
        return Holder.m_205709_((Object)this.biomemap[(yMoved * (this.zSize / 4) + zMoved) * (this.xSize / 4) + xMoved]);
    }

    public int m_277075_(BlockPos pos, Direction direction) {
        return 0;
    }

    public boolean m_5776_() {
        return false;
    }

    public int m_5736_() {
        return (int)(63.0f - this.effectiveGround + (float)this.m_141937_());
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public BiomeManager m_7062_() {
        return this.biomeManager;
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return null;
    }

    public RegistryAccess m_9598_() {
        return null;
    }

    public FeatureFlagSet m_246046_() {
        return null;
    }
}

