/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import org.joml.Matrix4f;
import org.lwjgl.openvr.HiddenAreaMesh;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VRSystem;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.RenderPass;

public class OpenVRStereoRenderer
extends VRRenderer {
    private final HiddenAreaMesh[] hiddenMeshes = new HiddenAreaMesh[2];
    private final MCOpenVR openvr;

    public OpenVRStereoRenderer(MCVR vr) {
        super(vr);
        this.openvr = (MCOpenVR)vr;
        this.hiddenMeshes[0] = HiddenAreaMesh.calloc();
        this.hiddenMeshes[1] = HiddenAreaMesh.calloc();
    }

    @Override
    public Tuple<Integer, Integer> getRenderTextureSizes() {
        if (this.resolution != null) {
            return this.resolution;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer intbyreference = stack.callocInt(1);
            IntBuffer intbyreference1 = stack.callocInt(1);
            VRSystem.VRSystem_GetRecommendedRenderTargetSize(intbyreference, intbyreference1);
            this.resolution = new Tuple((Object)intbyreference.get(0), (Object)intbyreference1.get(0));
            System.out.println("OpenVR Render Res " + this.resolution.m_14418_() + " x " + this.resolution.m_14419_());
            this.ss = this.openvr.getSuperSampling();
            System.out.println("OpenVR Supersampling: " + this.ss);
        }
        for (int i = 0; i < 2; ++i) {
            this.hiddenMeshes[i] = VRSystem.VRSystem_GetHiddenAreaMesh(i, 0, this.hiddenMeshes[i]);
            int j = this.hiddenMeshes[i].unTriangleCount();
            if (j <= 0) {
                System.out.println("No stencil mesh found for eye " + i);
                continue;
            }
            this.hiddenMesheVertecies[i] = new float[this.hiddenMeshes[i].unTriangleCount() * 3 * 2];
            MemoryUtil.memFloatBuffer((long)MemoryUtil.memAddress((CustomBuffer)this.hiddenMeshes[i].pVertexData()), (int)this.hiddenMesheVertecies[i].length).get(this.hiddenMesheVertecies[i]);
            for (int k = 0; k < this.hiddenMesheVertecies[i].length; k += 2) {
                float[] fArray = this.hiddenMesheVertecies[i];
                int n = k;
                fArray[n] = fArray[n] * (float)((Integer)this.resolution.m_14418_()).intValue();
                float[] fArray2 = this.hiddenMesheVertecies[i];
                int n2 = k + 1;
                fArray2[n2] = fArray2[n2] * (float)((Integer)this.resolution.m_14419_()).intValue();
            }
            System.out.println("Stencil mesh loaded for eye " + i);
        }
        return this.resolution;
    }

    @Override
    public Matrix4f getProjectionMatrix(int eyeType, float nearClip, float farClip) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (eyeType == 0) {
                Matrix4f matrix4f = Utils.Matrix4fFromOpenVR(VRSystem.VRSystem_GetProjectionMatrix(0, nearClip, farClip, HmdMatrix44.calloc(stack)));
                return matrix4f;
            }
            Matrix4f matrix4f = Utils.Matrix4fFromOpenVR(VRSystem.VRSystem_GetProjectionMatrix(1, nearClip, farClip, HmdMatrix44.calloc(stack)));
            return matrix4f;
        }
    }

    @Override
    public String getLastError() {
        return "";
    }

    @Override
    public void createRenderTexture(int lwidth, int lheight) {
        this.LeftEyeTextureId = GlStateManager._genTexture();
        int i = GlStateManager._getInteger((int)32873);
        RenderSystem.bindTexture((int)this.LeftEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)lwidth, (int)lheight, (int)0, (int)6408, (int)5124, null);
        RenderSystem.bindTexture((int)i);
        this.openvr.texType0.handle(this.LeftEyeTextureId);
        this.openvr.texType0.eColorSpace(1);
        this.openvr.texType0.eType(1);
        this.RightEyeTextureId = GlStateManager._genTexture();
        i = GlStateManager._getInteger((int)32873);
        RenderSystem.bindTexture((int)this.RightEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)lwidth, (int)lheight, (int)0, (int)6408, (int)5124, null);
        RenderSystem.bindTexture((int)i);
        this.openvr.texType1.handle(this.RightEyeTextureId);
        this.openvr.texType1.eColorSpace(1);
        this.openvr.texType1.eType(1);
    }

    public boolean endFrame(RenderPass eye) {
        return true;
    }

    @Override
    public void endFrame() throws RenderConfigException {
        if (OpenVR.VRCompositor.Submit != 0L) {
            int i = VRCompositor.VRCompositor_Submit(0, this.openvr.texType0, null, 0);
            int j = VRCompositor.VRCompositor_Submit(1, this.openvr.texType1, null, 0);
            VRCompositor.VRCompositor_PostPresentHandoff();
            if (i + j > 0) {
                throw new RenderConfigException("Compositor Error", (Component)Component.m_237113_((String)("Texture submission error: Left/Right " + OpenVRStereoRenderer.getCompostiorError(i) + "/" + OpenVRStereoRenderer.getCompostiorError(j))));
            }
        }
    }

    public static String getCompostiorError(int code) {
        switch (code) {
            case 0: {
                return "None:";
            }
            case 1: {
                return "RequestFailed";
            }
            case 100: {
                return "IncompatibleVersion";
            }
            case 101: {
                return "DoesNotHaveFocus";
            }
            case 102: {
                return "InvalidTexture";
            }
            case 103: {
                return "IsNotSceneApplication";
            }
            case 104: {
                return "TextureIsOnWrongDevice";
            }
            case 105: {
                return "TextureUsesUnsupportedFormat:";
            }
            case 106: {
                return "SharedTexturesNotSupported";
            }
            case 107: {
                return "IndexOutOfRange";
            }
            case 108: {
                return "AlreadySubmitted:";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean providesStencilMask() {
        return true;
    }

    @Override
    public float[] getStencilMask(RenderPass eye) {
        if (this.hiddenMesheVertecies != null && (eye == RenderPass.LEFT || eye == RenderPass.RIGHT)) {
            return eye == RenderPass.LEFT ? this.hiddenMesheVertecies[0] : this.hiddenMesheVertecies[1];
        }
        return null;
    }

    @Override
    public String getName() {
        return "OpenVR";
    }

    @Override
    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    @Override
    public String getinitError() {
        return this.vr.initStatus;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.LeftEyeTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.LeftEyeTextureId);
            this.LeftEyeTextureId = -1;
        }
        if (this.RightEyeTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.RightEyeTextureId);
            this.RightEyeTextureId = -1;
        }
    }
}

