/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL43C;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.mixin.client.blaze3d.RenderSystemAccessor;

public class RenderHelper {
    private static int polyBlendSrcA;
    private static int polyBlendDstA;
    private static int polyBlendSrcRGB;
    private static int polyBlendDstRGB;
    private static boolean polyBlend;
    private static boolean polyTex;
    private static boolean polyLight;
    private static boolean polyCull;
    private static final ClientDataHolderVR dataHolder;
    private static final Minecraft mc;

    public static void applyVRModelView(RenderPass currentPass, PoseStack poseStack) {
        Matrix4f modelView = currentPass == RenderPass.CENTER && RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth > 0.0f ? new Matrix4f().rotation((Quaternionfc)MCVR.get().hmdRotHistory.averageRotation(RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth)) : RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(currentPass).getMatrix().transposed().toMCMatrix();
        poseStack.m_85850_().m_252922_().mul((Matrix4fc)modelView);
        poseStack.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f((Matrix4fc)modelView));
    }

    public static Vec3 getSmoothCameraPosition(RenderPass renderpass, VRData vrData) {
        if (RenderHelper.dataHolder.currentPass == RenderPass.CENTER && RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth > 0.0f) {
            return MCVR.get().hmdHistory.averagePosition(RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth).m_82490_((double)vrData.worldScale).m_82524_(vrData.rotation_radians).m_82549_(vrData.origin);
        }
        return vrData.getEye(renderpass).getPosition();
    }

    public static void applyStereo(RenderPass currentPass, PoseStack matrix) {
        if (currentPass == RenderPass.LEFT || currentPass == RenderPass.RIGHT) {
            Vec3 eye = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(currentPass).getPosition().m_82546_(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition());
            matrix.m_85837_(-eye.f_82479_, -eye.f_82480_, -eye.f_82481_);
        }
    }

    public static Vec3 getControllerRenderPos(int c) {
        if (!RenderHelper.dataHolder.vrSettings.seated) {
            return RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getController(c).getPosition();
        }
        Vec3 out = null;
        int mainHand = InteractionHand.MAIN_HAND.ordinal();
        if (RenderHelper.dataHolder.vrSettings.reverseHands) {
            c = 1 - c;
            mainHand = InteractionHand.OFF_HAND.ordinal();
        }
        if (mc.m_91288_() != null && RenderHelper.mc.f_91073_ != null) {
            Vec3 dir = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir = dir.m_82524_((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
            dir = new Vec3(dir.f_82479_, 0.0, dir.f_82481_);
            dir = dir.m_82541_();
            if (TelescopeTracker.isTelescope(RenderHelper.mc.f_91074_.m_21211_()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.mc.f_91074_.m_21205_() : RenderHelper.mc.f_91074_.m_21206_())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.dataHolder.vrPlayer.vrdata_world_render.eye0 : RenderHelper.dataHolder.vrPlayer.vrdata_world_render.eye1;
                out = eye.getPosition().m_82549_(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection().m_82490_(0.2 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale));
            }
            if (out == null) {
                out = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition().m_82520_(dir.f_82479_ * 0.3 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale, -0.4 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale, dir.f_82481_ * 0.3 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale);
            }
        } else {
            Vec3 dir = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir = dir.m_82524_((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
            dir = new Vec3(dir.f_82479_, 0.0, dir.f_82481_);
            dir = dir.m_82541_();
            out = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getPosition().m_82520_(dir.f_82479_ * 0.3, -0.4, dir.f_82481_ * 0.3);
        }
        return out;
    }

    public static void setupRenderingAtController(int controller, PoseStack matrix) {
        Vec3 aimSource = RenderHelper.getControllerRenderPos(controller);
        aimSource = aimSource.m_82546_(RenderHelper.getSmoothCameraPosition(RenderHelper.dataHolder.currentPass, RenderHelper.dataHolder.vrPlayer.getVRDataWorld()));
        matrix.m_85837_(aimSource.f_82479_, aimSource.f_82480_, aimSource.f_82481_);
        float sc = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.dataHolder.vrSettings.seated && RenderHelper.mc.f_91073_ != null && TelescopeTracker.isTelescope(RenderHelper.mc.f_91074_.m_21211_()) && TelescopeTracker.isTelescope(controller == 0 ? RenderHelper.mc.f_91074_.m_21205_() : RenderHelper.mc.f_91074_.m_21206_())) {
            matrix.m_252931_(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getMatrix().inverted().transposed().toMCMatrix());
            MethodHolder.rotateDegXp(matrix, 90);
            matrix.m_85837_(controller == (RenderHelper.dataHolder.vrSettings.reverseHands ? 1 : 0) ? 0.075 * (double)sc : -0.075 * (double)sc, -0.025 * (double)sc, 0.0325 * (double)sc);
        } else {
            matrix.m_252931_(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getController(controller).getMatrix().inverted().transposed().toMCMatrix());
        }
        matrix.m_85841_(sc, sc, sc);
    }

    public static void renderDebugAxes(int r, int g, int b, float radius) {
        RenderHelper.setupPolyRendering(true);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/white.png"));
        RenderHelper.renderCircle(new Vec3(0.0, 0.0, 0.0), radius, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new Vec3(0.0, 0.01, 0.0), radius * 0.75f, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new Vec3(0.0, 0.02, 0.0), radius * 0.25f, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new Vec3(0.0, 0.0, 0.15), radius * 0.5f, 32, r, g, b, 255, 2);
        RenderHelper.setupPolyRendering(false);
    }

    public static void renderCircle(Vec3 pos, float radius, int edges, int r, int g, int b, int a, int side) {
        Tesselator tesselator = Tesselator.m_85913_();
        tesselator.m_85915_().m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        tesselator.m_85915_().m_5483_(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_6122_(r, g, b, a).m_5752_();
        for (int i = 0; i < edges + 1; ++i) {
            float z;
            float y;
            float x;
            float startAngle = (float)i / (float)edges * (float)Math.PI * 2.0f;
            if (side == 0 || side == 1) {
                x = (float)pos.f_82479_ + (float)Math.cos(startAngle) * radius;
                y = (float)pos.f_82480_;
                z = (float)pos.f_82481_ + (float)Math.sin(startAngle) * radius;
                tesselator.m_85915_().m_5483_((double)x, (double)y, (double)z).m_6122_(r, g, b, a).m_5752_();
                continue;
            }
            if (side == 2 || side == 3) {
                x = (float)pos.f_82479_ + (float)Math.cos(startAngle) * radius;
                y = (float)pos.f_82480_ + (float)Math.sin(startAngle) * radius;
                z = (float)pos.f_82481_;
                tesselator.m_85915_().m_5483_((double)x, (double)y, (double)z).m_6122_(r, g, b, a).m_5752_();
                continue;
            }
            if (side != 4 && side != 5) continue;
            x = (float)pos.f_82479_;
            y = (float)pos.f_82480_ + (float)Math.cos(startAngle) * radius;
            z = (float)pos.f_82481_ + (float)Math.sin(startAngle) * radius;
            tesselator.m_85915_().m_5483_((double)x, (double)y, (double)z).m_6122_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
    }

    public static void setupPolyRendering(boolean enable) {
        boolean flag = false;
        if (enable) {
            polyBlendSrcA = GlStateManager.BLEND.f_84580_;
            polyBlendDstA = GlStateManager.BLEND.f_84581_;
            polyBlendSrcRGB = GlStateManager.BLEND.f_84578_;
            polyBlendDstRGB = GlStateManager.BLEND.f_84579_;
            polyBlend = GL43C.glIsEnabled((int)3042);
            polyTex = true;
            polyLight = false;
            polyCull = true;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            if (flag) {
                // empty if block
            }
        } else {
            RenderSystem.blendFuncSeparate((int)polyBlendSrcRGB, (int)polyBlendDstRGB, (int)polyBlendSrcA, (int)polyBlendDstA);
            if (!polyBlend) {
                RenderSystem.disableBlend();
            }
            if (polyTex) {
                // empty if block
            }
            if (polyLight) {
                // empty if block
            }
            if (polyCull) {
                RenderSystem.enableCull();
            }
        }
    }

    public static void drawScreen(float f, Screen screen, GuiGraphics guiGraphics) {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, -11000.0);
        RenderSystem.applyModelViewMatrix();
        Matrix4f guiProjection = new Matrix4f().setOrtho(0.0f, (float)((double)mc.m_91268_().m_85441_() / mc.m_91268_().m_85449_()), (float)((double)mc.m_91268_().m_85442_() / mc.m_91268_().m_85449_()), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        screen.m_88315_(guiGraphics, 0, 0, f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderTarget main = mc.m_91385_();
        main.m_83956_();
        ((RenderTargetExtension)main).vivecraft$genMipMaps();
        main.m_83963_();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size) {
        RenderHelper.drawSizedQuad(displayWidth, displayHeight, size, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color) {
        float aspect = displayHeight / displayWidth;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_5483_((double)(-(size / 2.0f)), (double)(-(size * aspect) / 2.0f), 0.0).m_7421_(0.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(size / 2.0f), (double)(-(size * aspect) / 2.0f), 0.0).m_7421_(1.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(size / 2.0f), (double)(size * aspect / 2.0f), 0.0).m_7421_(1.0f, 1.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(-(size / 2.0f)), (double)(size * aspect / 2.0f), 0.0).m_7421_(0.0f, 1.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f pMatrix) {
        float aspect = displayHeight / displayWidth;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(pMatrix, -(size / 2.0f), -(size * aspect) / 2.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, size / 2.0f, -(size * aspect) / 2.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, size / 2.0f, size * aspect / 2.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, -(size / 2.0f), size * aspect / 2.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSizedQuadWithLightmapCutout(float displayWidth, float displayHeight, float size, int lighti, Matrix4f pMatrix, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmapCutout(displayWidth, displayHeight, size, lighti, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, pMatrix, flipY);
    }

    public static void drawSizedQuadWithLightmapCutout(float displayWidth, float displayHeight, float size, int lighti, float[] color, Matrix4f pMatrix, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, lighti, color, pMatrix, GameRenderer::m_172667_, flipY);
    }

    public static void drawSizedQuadSolid(float displayWidth, float displayHeight, float size, float[] color, Matrix4f pMatrix) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, LightTexture.m_109885_((int)15, (int)15), color, pMatrix, GameRenderer::m_172661_, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int lighti, float[] color, Matrix4f pMatrix, Supplier<ShaderInstance> shader, boolean flipY) {
        float aspect = displayHeight / displayWidth;
        RenderSystem.setShader(shader);
        RenderHelper.mc.f_91063_.m_109154_().m_109896_();
        RenderHelper.mc.f_91063_.m_109155_().m_118087_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        Vector3f light0Old = RenderSystemAccessor.getShaderLightDirections()[0];
        Vector3f light1Old = RenderSystemAccessor.getShaderLightDirections()[1];
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        RenderSystem.setupShaderLights((ShaderInstance)RenderSystem.getShader());
        bufferbuilder.m_252986_(pMatrix, -(size / 2.0f), -(size * aspect) / 2.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, flipY ? 1.0f : 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lighti).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, size / 2.0f, -(size * aspect) / 2.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, flipY ? 1.0f : 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lighti).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, size / 2.0f, size * aspect / 2.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, flipY ? 0.0f : 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lighti).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(pMatrix, -(size / 2.0f), size * aspect / 2.0f, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, flipY ? 0.0f : 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lighti).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderHelper.mc.f_91063_.m_109154_().m_109891_();
        if (light0Old != null && light1Old != null) {
            RenderSystem.setShaderLights((Vector3f)light0Old, (Vector3f)light1Old);
            RenderSystem.setupShaderLights((ShaderInstance)RenderSystem.getShader());
        }
    }

    public static void renderFlatQuad(Vec3 pos, float width, float height, float yaw, int r, int g, int b, int a, PoseStack poseStack) {
        Tesselator tesselator = Tesselator.m_85913_();
        tesselator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        Vec3 offset = new Vec3((double)(width / 2.0f), 0.0, (double)(height / 2.0f)).m_82524_((float)Math.toRadians(-yaw));
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        tesselator.m_85915_().m_252986_(mat, (float)(pos.f_82479_ + offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ + offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        tesselator.m_85915_().m_252986_(mat, (float)(pos.f_82479_ + offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ - offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        tesselator.m_85915_().m_252986_(mat, (float)(pos.f_82479_ - offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ - offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        tesselator.m_85915_().m_252986_(mat, (float)(pos.f_82479_ - offset.f_82479_), (float)pos.f_82480_, (float)(pos.f_82481_ + offset.f_82481_)).m_6122_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    public static void renderBox(Tesselator tes, Vec3 start, Vec3 end, float minX, float maxX, float minY, float maxY, Vec3i color, byte alpha, PoseStack poseStack) {
        Vec3 forward = start.m_82546_(end).m_82541_();
        Vec3 right = forward.m_82537_(new Vec3(0.0, 1.0, 0.0));
        Vec3 up = right.m_82537_(forward);
        Vec3 left = right.m_82490_((double)minX);
        right = right.m_82490_((double)maxX);
        Vec3 down = up.m_82490_((double)minY);
        up = up.m_82490_((double)maxY);
        Vec3 upNormal = up.m_82541_();
        Vec3 rightNormal = right.m_82541_();
        Vec3 backRightBottom = start.m_82520_(right.f_82479_ + down.f_82479_, right.f_82480_ + down.f_82480_, right.f_82481_ + down.f_82481_);
        Vec3 backRightTop = start.m_82520_(right.f_82479_ + up.f_82479_, right.f_82480_ + up.f_82480_, right.f_82481_ + up.f_82481_);
        Vec3 backLeftBottom = start.m_82520_(left.f_82479_ + down.f_82479_, left.f_82480_ + down.f_82480_, left.f_82481_ + down.f_82481_);
        Vec3 backLeftTop = start.m_82520_(left.f_82479_ + up.f_82479_, left.f_82480_ + up.f_82480_, left.f_82481_ + up.f_82481_);
        Vec3 frontRightBottom = end.m_82520_(right.f_82479_ + down.f_82479_, right.f_82480_ + down.f_82480_, right.f_82481_ + down.f_82481_);
        Vec3 frontRightTop = end.m_82520_(right.f_82479_ + up.f_82479_, right.f_82480_ + up.f_82480_, right.f_82481_ + up.f_82481_);
        Vec3 frontLeftBottom = end.m_82520_(left.f_82479_ + down.f_82479_, left.f_82480_ + down.f_82480_, left.f_82481_ + down.f_82481_);
        Vec3 frontLeftTop = end.m_82520_(left.f_82479_ + up.f_82479_, left.f_82480_ + up.f_82480_, left.f_82481_ + up.f_82481_);
        BufferBuilder bufferbuilder = tes.m_85915_();
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, forward);
        forward.m_82548_();
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, rightNormal);
        rightNormal.m_82548_();
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, upNormal);
        upNormal.m_82548_();
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, upNormal);
    }

    private static void addVertex(BufferBuilder buff, Matrix4f mat, Vec3 pos, Vec3i color, int alpha, Vec3 normal) {
        buff.m_252986_(mat, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(color.m_123341_(), color.m_123342_(), color.m_123343_(), alpha).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    static {
        dataHolder = ClientDataHolderVR.getInstance();
        mc = Minecraft.m_91087_();
    }
}

