/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector2f;
import org.lwjgl.opengl.GL11C;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.gui.VivecraftClickEvent;
import org.vivecraft.client.gui.settings.GuiOtherHUDSettings;
import org.vivecraft.client.gui.settings.GuiRenderOpticsSettings;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.LevelRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VRArmHelper;
import org.vivecraft.client_vr.render.helpers.VRWidgetHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.mod_compat_vr.ShadersHelper;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VREffectsHelper {
    private static final ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
    private static final Minecraft mc = Minecraft.m_91087_();
    private static boolean wasStencilOn;
    private static boolean showedStencilMessage;
    private static final ResourceLocation cubeFront;
    private static final ResourceLocation cubeRight;
    private static final ResourceLocation cubeBack;
    private static final ResourceLocation cubeLeft;
    private static final ResourceLocation cubeUp;
    private static final ResourceLocation cubeDown;
    private static final ResourceLocation dirt;
    private static final ResourceLocation grass;

    public static boolean isInsideOpaqueBlock(Vec3 in) {
        if (VREffectsHelper.mc.f_91073_ == null) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)in);
        return VREffectsHelper.mc.f_91073_.m_8055_(blockpos).m_60804_((BlockGetter)VREffectsHelper.mc.f_91073_, blockpos);
    }

    public static Triple<Float, BlockState, BlockPos> getNearOpaqueBlock(Vec3 in, double dist) {
        if (VREffectsHelper.mc.f_91073_ == null) {
            return null;
        }
        AABB aabb = new AABB(in.m_82492_(dist, dist, dist), in.m_82520_(dist, dist, dist));
        Stream<BlockPos> stream = BlockPos.m_121921_((AABB)aabb).filter(bp -> VREffectsHelper.mc.f_91073_.m_8055_(bp).m_60804_((BlockGetter)VREffectsHelper.mc.f_91073_, bp));
        Optional<BlockPos> optional = stream.findFirst();
        return optional.isPresent() ? Triple.of((Object)Float.valueOf(1.0f), (Object)VREffectsHelper.mc.f_91073_.m_8055_(optional.get()), (Object)optional.get()) : null;
    }

    public static void drawScopeFB(PoseStack matrixStackIn, int i) {
        if (VREffectsHelper.dataHolder.currentPass != RenderPass.SCOPEL && VREffectsHelper.dataHolder.currentPass != RenderPass.SCOPER) {
            VREffectsHelper.mc.f_91063_.m_109154_().m_109891_();
            matrixStackIn.m_85836_();
            RenderSystem.enableDepthTest();
            if (i == 0) {
                VREffectsHelper.dataHolder.vrRenderer.telescopeFramebufferR.m_83956_();
                RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.dataHolder.vrRenderer.telescopeFramebufferR.m_83975_());
            } else {
                VREffectsHelper.dataHolder.vrRenderer.telescopeFramebufferL.m_83956_();
                RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.dataHolder.vrRenderer.telescopeFramebufferL.m_83975_());
            }
            float scale = 0.0785f;
            float alpha = TelescopeTracker.viewPercent(i);
            RenderHelper.drawSizedQuadSolid(720.0f, 720.0f, scale, new float[]{alpha, alpha, alpha, 1.0f}, matrixStackIn.m_85850_().m_252922_());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("textures/misc/spyglass_scope.png"));
            RenderSystem.enableBlend();
            matrixStackIn.m_85837_(0.0, 0.0, 1.0E-5);
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)VREffectsHelper.mc.f_91073_, (BlockPos)BlockPos.m_274446_((Position)VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(i).getPosition()));
            RenderHelper.drawSizedQuadWithLightmapCutout(720.0f, 720.0f, scale, light, matrixStackIn.m_85850_().m_252922_(), true);
            matrixStackIn.m_85849_();
            VREffectsHelper.mc.f_91063_.m_109154_().m_109896_();
        }
    }

    public static void drawEyeStencil(boolean flag1) {
        wasStencilOn = GL11C.glIsEnabled((int)2960);
        if (wasStencilOn && !showedStencilMessage && VREffectsHelper.dataHolder.vrSettings.vrUseStencil && VREffectsHelper.dataHolder.vrSettings.showChatMessageStencil) {
            showedStencilMessage = true;
            VREffectsHelper.mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"vivecraft.messages.stencil", (Object[])new Object[]{Component.m_237110_((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.m_237115_((String)"options.title"), Component.m_237115_((String)"vivecraft.options.screen.main"), Component.m_237115_((String)"vivecraft.options.screen.stereorendering")}).m_130938_(style -> style.m_131142_((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiRenderOpticsSettings(null))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"vivecraft.messages.openSettings"))).m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))), Component.m_237110_((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.m_237115_((String)"options.title"), Component.m_237115_((String)"vivecraft.options.screen.main"), Component.m_237115_((String)"vivecraft.options.screen.guiother")}).m_130938_(style -> style.m_131142_((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiOtherHUDSettings(null))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"vivecraft.messages.openSettings"))).m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)))}));
        }
        if (!(VREffectsHelper.dataHolder.currentPass != RenderPass.LEFT && VREffectsHelper.dataHolder.currentPass != RenderPass.RIGHT || !VREffectsHelper.dataHolder.vrSettings.vrUseStencil || Xplat.isModLoaded("immersive_portals") && ImmersivePortalsHelper.isRenderingPortal())) {
            VREffectsHelper.dataHolder.vrRenderer.doStencil(false);
        }
    }

    public static void disableStencilTest() {
        if (!wasStencilOn) {
            GL11C.glDisable((int)2960);
        }
    }

    public static void renderMenuPanorama(PoseStack poseStack) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(-50.0f, -50.0f, -50.0f);
        org.joml.Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeDown);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeUp);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeLeft);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeRight);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeFront);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cubeBack);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 100.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 100.0f, 100.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 100.0f, 100.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 100.0f, 0.0f, 100.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        poseStack.m_85849_();
        Vector2f area = VREffectsHelper.dataHolder.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        for (int i = 0; i < 2; ++i) {
            int b;
            int g;
            int r;
            float width = area.x + (float)(i * 2);
            float length = area.y + (float)(i * 2);
            poseStack.m_85836_();
            RenderSystem.setShader(GameRenderer::m_172838_);
            if (i == 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)grass);
                r = 114;
                g = 148;
                b = 70;
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)dirt);
                b = 128;
                g = 128;
                r = 128;
            }
            org.joml.Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
            poseStack.m_252880_(-width / 2.0f, 0.0f, -length / 2.0f);
            int repeat = 4;
            bufferbuilder.m_252986_(matrix4f, 0.0f, 0.005f * (float)(-i), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 0.0f, 0.005f * (float)(-i), length).m_7421_(0.0f, 4.0f * length).m_6122_(r, g, b, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, width, 0.005f * (float)(-i), length).m_7421_(4.0f * width, 4.0f * length).m_6122_(r, g, b, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, width, 0.005f * (float)(-i), 0.0f).m_7421_(4.0f * width, 0.0f).m_6122_(r, g, b, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
    }

    public static void renderJrbuddasAwesomeMainMenuRoomNew(PoseStack pMatrixStack) {
        int repeat = 4;
        float height = 2.5f;
        float oversize = 1.3f;
        Vector2f area = VREffectsHelper.dataHolder.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.depthFunc((int)519);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pMatrixStack.m_85836_();
        float width = area.x + oversize;
        float length = area.y + oversize;
        pMatrixStack.m_252880_(-width / 2.0f, 0.0f, -length / 2.0f);
        org.joml.Matrix4f matrix = pMatrixStack.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float b = 0.8f;
        float g = 0.8f;
        float r = 0.8f;
        float a = 1.0f;
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_(0.0f, (float)repeat * length).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * width, (float)repeat * length).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, length).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * length).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, 0.0f).m_7421_((float)repeat * width, (float)repeat * length).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, length).m_7421_((float)repeat * length, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_((float)repeat * length, 0.0f).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * length, 0.0f).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * length, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, 0.0f).m_7421_((float)repeat * width, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, length).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, height, length).m_7421_(0.0f, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, length).m_7421_((float)repeat * width, (float)repeat * height).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, length).m_7421_((float)repeat * width, 0.0f).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        pMatrixStack.m_85849_();
    }

    public static void renderTechjarsAwesomeMainMenuRoom(PoseStack poseStack) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        poseStack.m_85836_();
        int tzOffset = Calendar.getInstance().get(15);
        VREffectsHelper.dataHolder.menuWorldRenderer.time = VREffectsHelper.dataHolder.menuWorldRenderer.fastTime ? (long)((float)((long)VREffectsHelper.dataHolder.menuWorldRenderer.ticks * 10L) + 10.0f * mc.m_91296_()) : (long)((double)(System.currentTimeMillis() + (long)tzOffset - 21600000L) / 8.64E7 * 24000.0);
        VREffectsHelper.dataHolder.menuWorldRenderer.fogRenderer.setupFogColor();
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        VREffectsHelper.dataHolder.menuWorldRenderer.updateLightmap();
        VREffectsHelper.dataHolder.menuWorldRenderer.render(poseStack);
        Vector2f area = VREffectsHelper.dataHolder.vr.getPlayAreaSize();
        if (area != null) {
            poseStack.m_85836_();
            float width = area.x;
            float length = area.y;
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
            float sun = VREffectsHelper.dataHolder.menuWorldRenderer.getSkyDarken();
            RenderSystem.setShaderColor((float)sun, (float)sun, (float)sun, (float)0.3f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            org.joml.Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
            poseStack.m_252880_(-width / 2.0f, 0.0f, -length / 2.0f);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 0.005f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 0.0f, 0.005f, length).m_7421_(0.0f, 4.0f * length).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, width, 0.005f, length).m_7421_(4.0f * width, 4.0f * length).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, width, 0.005f, 0.0f).m_7421_(4.0f * width, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderVRFabulous(float partialTicks, LevelRenderer levelRenderer, boolean menuHandRight, boolean menuHandLeft, PoseStack poseStack) {
        if (ClientDataHolderVR.getInstance().currentPass == RenderPass.SCOPEL || ClientDataHolderVR.getInstance().currentPass == RenderPass.SCOPER) {
            return;
        }
        mc.m_91307_().m_6182_("VR");
        VREffectsHelper.renderCrosshairAtDepth(!ClientDataHolderVR.getInstance().vrSettings.useCrosshairOcclusion, poseStack);
        mc.m_91385_().m_83970_();
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVROccludedFramebuffer().m_83954_(Minecraft.f_91002_);
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVROccludedFramebuffer().m_83945_(mc.m_91385_());
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVROccludedFramebuffer().m_83947_(true);
        if (VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTicks, false, false);
        }
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRUnoccludedFramebuffer().m_83954_(Minecraft.f_91002_);
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRUnoccludedFramebuffer().m_83947_(true);
        if (!VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTicks, false, false);
        }
        VREffectsHelper.renderVRSelfEffects(partialTicks);
        VRWidgetHelper.renderVRThirdPersonCamWidget();
        VRWidgetHelper.renderVRHandheldCameraWidget();
        boolean renderHands = VRArmHelper.shouldRenderHands();
        VRArmHelper.renderVRHands(partialTicks, renderHands && menuHandRight, renderHands && menuHandLeft, true, true, poseStack);
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRHandsFramebuffer().m_83954_(Minecraft.f_91002_);
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRHandsFramebuffer().m_83945_(mc.m_91385_());
        ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRHandsFramebuffer().m_83947_(true);
        VRArmHelper.renderVRHands(partialTicks, renderHands && !menuHandRight, renderHands && !menuHandLeft, false, false, poseStack);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.m_91385_().m_83947_(true);
    }

    public static void renderVrFast(float partialTicks, boolean secondPass, boolean menuHandRight, boolean menuHandLeft, PoseStack poseStack) {
        boolean renderHandsSecond;
        if (VREffectsHelper.dataHolder.currentPass == RenderPass.SCOPEL || VREffectsHelper.dataHolder.currentPass == RenderPass.SCOPER) {
            return;
        }
        mc.m_91307_().m_6182_("VR");
        VREffectsHelper.mc.f_91063_.m_109154_().m_109891_();
        if (!secondPass) {
            VREffectsHelper.renderCrosshairAtDepth(!VREffectsHelper.dataHolder.vrSettings.useCrosshairOcclusion, poseStack);
            VRWidgetHelper.renderVRThirdPersonCamWidget();
            VRWidgetHelper.renderVRHandheldCameraWidget();
        } else {
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTicks, !VREffectsHelper.shouldOccludeGui(), true);
        }
        boolean bl = renderHandsSecond = RadialHandler.isShowing() || KeyboardHandler.Showing || Minecraft.m_91087_().f_91080_ != null;
        if (secondPass == renderHandsSecond) {
            VRArmHelper.renderVRHands(partialTicks, VRArmHelper.shouldRenderHands(), VRArmHelper.shouldRenderHands(), menuHandRight, menuHandLeft, poseStack);
        }
        VREffectsHelper.renderVRSelfEffects(partialTicks);
    }

    private static boolean shouldOccludeGui() {
        Vec3 pos = VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.dataHolder.currentPass).getPosition();
        if (VREffectsHelper.dataHolder.currentPass != RenderPass.THIRD && VREffectsHelper.dataHolder.currentPass != RenderPass.CAMERA) {
            return !((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isInMenuRoom() && VREffectsHelper.mc.f_91080_ == null && !KeyboardHandler.Showing && !RadialHandler.isShowing() && VREffectsHelper.dataHolder.vrSettings.hudOcclusion && !VREffectsHelper.isInsideOpaqueBlock(pos);
        }
        return true;
    }

    private static void renderGuiAndShadow(PoseStack poseStack, float partialTicks, boolean depthAlways, boolean shadowFirst) {
        if (shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTicks, depthAlways, poseStack);
        }
        if (Minecraft.m_91087_().f_91080_ != null || !KeyboardHandler.Showing) {
            VREffectsHelper.renderGuiLayer(partialTicks, depthAlways, poseStack);
        }
        if (!shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTicks, depthAlways, poseStack);
        }
        if (KeyboardHandler.Showing) {
            if (VREffectsHelper.dataHolder.vrSettings.physicalKeyboard) {
                VREffectsHelper.renderPhysicalKeyboard(partialTicks, poseStack);
            } else {
                VREffectsHelper.render2D(partialTicks, KeyboardHandler.Framebuffer, KeyboardHandler.Pos_room, KeyboardHandler.Rotation_room, depthAlways, poseStack);
            }
        }
        if (RadialHandler.isShowing()) {
            VREffectsHelper.render2D(partialTicks, RadialHandler.Framebuffer, RadialHandler.Pos_room, RadialHandler.Rotation_room, depthAlways, poseStack);
        }
    }

    public static void renderVrShadow(float partialTicks, boolean depthAlways, PoseStack poseStack) {
        if (VREffectsHelper.dataHolder.currentPass != RenderPass.THIRD && VREffectsHelper.dataHolder.currentPass != RenderPass.CAMERA && VREffectsHelper.mc.f_91074_.m_6084_() && !(((PlayerExtension)VREffectsHelper.mc.f_91074_).vivecraft$getRoomYOffsetFromPose() < 0.0) && VREffectsHelper.mc.f_91074_.m_20202_() == null) {
            mc.m_91307_().m_6180_("vr shadow");
            AABB aabb = VREffectsHelper.mc.f_91074_.m_20191_();
            if (VREffectsHelper.dataHolder.vrSettings.vrShowBlueCircleBuddy && aabb != null) {
                poseStack.m_85836_();
                poseStack.m_166856_();
                RenderSystem.disableCull();
                RenderHelper.applyVRModelView(VREffectsHelper.dataHolder.currentPass, poseStack);
                Vec3 vec3 = RenderHelper.getSmoothCameraPosition(VREffectsHelper.dataHolder.currentPass, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
                Vec3 interpolatedPlayerPos = ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$getRvePos(partialTicks);
                Vec3 pos = interpolatedPlayerPos.m_82546_(vec3).m_82520_(0.0, 0.005, 0.0);
                RenderHelper.setupPolyRendering(true);
                RenderSystem.enableDepthTest();
                if (depthAlways) {
                    RenderSystem.depthFunc((int)519);
                } else {
                    RenderSystem.depthFunc((int)515);
                }
                RenderSystem.setShader(GameRenderer::m_172811_);
                mc.m_91097_().m_174784_(new ResourceLocation("vivecraft:textures/white.png"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/white.png"));
                RenderHelper.renderFlatQuad(pos, (float)(aabb.f_82291_ - aabb.f_82288_), (float)(aabb.f_82293_ - aabb.f_82290_), 0.0f, 0, 0, 0, 64, poseStack);
                RenderSystem.depthFunc((int)515);
                RenderHelper.setupPolyRendering(false);
                poseStack.m_85849_();
                RenderSystem.enableCull();
            }
            mc.m_91307_().m_7238_();
        }
    }

    private static void renderVRSelfEffects(float par1) {
        if (((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isOnFire() && VREffectsHelper.dataHolder.currentPass != RenderPass.THIRD && VREffectsHelper.dataHolder.currentPass != RenderPass.CAMERA) {
            VREffectsHelper.renderFireInFirstPerson();
        }
        VREffectsHelper.mc.f_91063_.m_109100_(0, 0, par1);
    }

    public static void renderFireInFirstPerson() {
        PoseStack posestack = new PoseStack();
        RenderHelper.applyVRModelView(VREffectsHelper.dataHolder.currentPass, posestack);
        RenderHelper.applyStereo(VREffectsHelper.dataHolder.currentPass, posestack);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthFunc((int)519);
        if (VREffectsHelper.dataHolder.currentPass == RenderPass.THIRD || VREffectsHelper.dataHolder.currentPass == RenderPass.CAMERA) {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        TextureAtlasSprite fireSprite = ModelBakery.f_119220_.m_119204_();
        RenderSystem.enableDepthTest();
        if (OptifineHelper.isOptifineLoaded()) {
            OptifineHelper.markTextureAsActive(fireSprite);
        }
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)fireSprite.m_247685_());
        float uMin = fireSprite.m_118409_();
        float uMax = fireSprite.m_118410_();
        float uMid = (uMin + uMax) / 2.0f;
        float vMin = fireSprite.m_118411_();
        float vMax = fireSprite.m_118412_();
        float vMid = (vMin + vMax) / 2.0f;
        float ShrinkRatio = fireSprite.m_118417_();
        float u0 = Mth.m_14179_((float)ShrinkRatio, (float)uMin, (float)uMid);
        float u1 = Mth.m_14179_((float)ShrinkRatio, (float)uMax, (float)uMid);
        float v0 = Mth.m_14179_((float)ShrinkRatio, (float)vMin, (float)vMid);
        float v1 = Mth.m_14179_((float)ShrinkRatio, (float)vMax, (float)vMid);
        float a = 0.3f;
        float b = (float)(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getHeadPivot().f_82480_ - ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$getRveY());
        for (int i = 0; i < 4; ++i) {
            posestack.m_85836_();
            posestack.m_252781_(Axis.f_252436_.m_252977_((float)i * 90.0f - VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getBodyYaw()));
            posestack.m_85837_(0.0, (double)(-b), 0.0);
            org.joml.Matrix4f matrix4f = posestack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_252986_(matrix4f, -a, 0.0f, -a).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, a, 0.0f, -a).m_7421_(u0, v1).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, a, b, -a).m_7421_(u0, v0).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -a, b, -a).m_7421_(u1, v0).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            posestack.m_85849_();
        }
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
    }

    public static void renderPhysicalKeyboard(float partialTicks, PoseStack poseStack) {
        if (!VREffectsHelper.dataHolder.bowTracker.isDrawing) {
            ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$resetProjectionMatrix(partialTicks);
            poseStack.m_85836_();
            poseStack.m_166856_();
            mc.m_91307_().m_6180_("applyPhysicalKeyboardModelView");
            Vec3 eye = RenderHelper.getSmoothCameraPosition(VREffectsHelper.dataHolder.currentPass, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
            Vec3 guiPos = VRPlayer.room_to_world_pos(KeyboardHandler.Pos_room, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
            Matrix4f rot = Matrix4f.rotationY(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.rotation_radians);
            Matrix4f guiRot = Matrix4f.multiply(rot, KeyboardHandler.Rotation_room);
            RenderHelper.applyVRModelView(VREffectsHelper.dataHolder.currentPass, poseStack);
            poseStack.m_252880_((float)(guiPos.f_82479_ - eye.f_82479_), (float)(guiPos.f_82480_ - eye.f_82480_), (float)(guiPos.f_82481_ - eye.f_82481_));
            poseStack.m_252931_(guiRot.toMCMatrix());
            float scale = VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale;
            poseStack.m_85841_(scale, scale, scale);
            mc.m_91307_().m_7238_();
            KeyboardHandler.physicalKeyboard.render(poseStack);
            poseStack.m_85849_();
        }
    }

    private static void setupScreenRendering(PoseStack poseStack, float partialTicks) {
        ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$resetProjectionMatrix(partialTicks);
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderHelper.applyVRModelView(VREffectsHelper.dataHolder.currentPass, poseStack);
        PoseStack modelView = RenderSystem.getModelViewStack();
        modelView.m_85836_();
        modelView.m_166856_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void finishScreenRendering(PoseStack poseStack) {
        poseStack.m_85849_();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderScreen(PoseStack poseStack, RenderTarget screenFramebuffer, boolean depthAlways, boolean noFog, Vec3 screenPos) {
        screenFramebuffer.m_83956_();
        RenderSystem.disableCull();
        RenderSystem.setShaderTexture((int)0, (int)screenFramebuffer.m_83975_());
        float fogStart = RenderSystem.getShaderFogStart();
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (!((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isInMenuRoom()) {
            if (VREffectsHelper.mc.f_91080_ == null) {
                color[3] = VREffectsHelper.dataHolder.vrSettings.hudOpacity;
            }
            if (noFog || VREffectsHelper.mc.f_91080_ != null) {
                RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            }
            if (VREffectsHelper.mc.f_91074_ != null && VREffectsHelper.mc.f_91074_.m_6144_()) {
                color[3] = color[3] * 0.75f;
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            if (VREffectsHelper.dataHolder.vrSettings.shaderGUIRender == VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID && ShadersHelper.isShaderActive()) {
                RenderSystem.disableBlend();
            }
        } else {
            RenderSystem.enableBlend();
        }
        if (depthAlways) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        if (VREffectsHelper.mc.f_91073_ != null) {
            if (VREffectsHelper.isInsideOpaqueBlock(screenPos) || ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isInBlock() > 0.0f) {
                screenPos = VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getPosition();
            }
            int minLight = ShadersHelper.ShaderLight();
            int light = Utils.getCombinedLightWithMin((BlockAndTintGetter)VREffectsHelper.mc.f_91073_, BlockPos.m_274446_((Position)screenPos), minLight);
            RenderHelper.drawSizedQuadWithLightmapCutout(mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_(), 1.5f, light, color, poseStack.m_85850_().m_252922_(), false);
        } else {
            RenderHelper.drawSizedQuad(mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_(), 1.5f, color, poseStack.m_85850_().m_252922_());
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    public static void renderGuiLayer(float partialTicks, boolean depthAlways, PoseStack poseStack) {
        if (!(VREffectsHelper.dataHolder.bowTracker.isDrawing || VREffectsHelper.mc.f_91080_ == null && VREffectsHelper.mc.f_91066_.f_92062_ || RadialHandler.isShowing())) {
            mc.m_91307_().m_6180_("GuiLayer");
            VREffectsHelper.setupScreenRendering(poseStack, partialTicks);
            if (((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isInMenuRoom()) {
                depthAlways = true;
                poseStack.m_85836_();
                Vec3 eye = RenderHelper.getSmoothCameraPosition(VREffectsHelper.dataHolder.currentPass, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
                poseStack.m_85837_(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.origin.f_82479_ - eye.f_82479_, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.origin.f_82480_ - eye.f_82480_, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.origin.f_82481_ - eye.f_82481_);
                poseStack.m_252781_(Axis.f_252392_.m_252961_(-VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.rotation_radians));
                if (VREffectsHelper.dataHolder.menuWorldRenderer.isReady()) {
                    try {
                        VREffectsHelper.renderTechjarsAwesomeMainMenuRoom(poseStack);
                    }
                    catch (Exception exception) {
                        System.out.println("Error rendering main menu world, unloading to prevent more errors");
                        exception.printStackTrace();
                        VREffectsHelper.dataHolder.menuWorldRenderer.destroy();
                    }
                } else if (VREffectsHelper.dataHolder.vrSettings.menuWorldFallbackPanorama) {
                    VREffectsHelper.renderMenuPanorama(poseStack);
                } else {
                    VREffectsHelper.renderJrbuddasAwesomeMainMenuRoomNew(poseStack);
                }
                poseStack.m_85849_();
            }
            Vec3 guiPos = GuiHandler.applyGUIModelView(VREffectsHelper.dataHolder.currentPass, poseStack);
            VREffectsHelper.renderScreen(poseStack, GuiHandler.guiFramebuffer, depthAlways, false, guiPos);
            VREffectsHelper.finishScreenRendering(poseStack);
            mc.m_91307_().m_7238_();
        }
    }

    public static void render2D(float partialTicks, RenderTarget framebuffer, Vec3 pos, Matrix4f rot, boolean depthAlways, PoseStack poseStack) {
        if (!VREffectsHelper.dataHolder.bowTracker.isDrawing) {
            VREffectsHelper.setupScreenRendering(poseStack, partialTicks);
            mc.m_91307_().m_6180_("apply2DModelView");
            Vec3 eye = RenderHelper.getSmoothCameraPosition(VREffectsHelper.dataHolder.currentPass, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
            Vec3 guiPos = VRPlayer.room_to_world_pos(pos, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render);
            Matrix4f yRot = Matrix4f.rotationY(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.rotation_radians);
            Matrix4f guiRot = Matrix4f.multiply(yRot, rot);
            poseStack.m_252880_((float)(guiPos.f_82479_ - eye.f_82479_), (float)(guiPos.f_82480_ - eye.f_82480_), (float)(guiPos.f_82481_ - eye.f_82481_));
            poseStack.m_252931_(guiRot.toMCMatrix());
            float scale = GuiHandler.guiScale * VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale;
            poseStack.m_85841_(scale, scale, scale);
            mc.m_91307_().m_7238_();
            VREffectsHelper.renderScreen(poseStack, framebuffer, depthAlways, true, guiPos);
            VREffectsHelper.finishScreenRendering(poseStack);
        }
    }

    public static void renderFaceOverlay(float partialTicks, PoseStack poseStack) {
        if (((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$isInBlock() > 0.0f) {
            VREffectsHelper.renderFaceInBlock();
            VREffectsHelper.renderGuiAndShadow(poseStack, partialTicks, true, true);
            VRArmHelper.renderVRHands(partialTicks, true, true, true, true, poseStack);
        }
    }

    public static void renderFaceInBlock() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        org.joml.Matrix4f mat = new org.joml.Matrix4f();
        mat.m00(1.0f);
        mat.m11(1.0f);
        mat.m22(-1.0f);
        mat.m33(1.0f);
        mat.m32(-1.0f);
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_252986_(mat, -1.5f, -1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 1.5f, -1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 1.5f, 1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, -1.5f, 1.5f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static boolean shouldRenderCrosshair() {
        if (ClientDataHolderVR.viewonly) {
            return false;
        }
        if (VREffectsHelper.mc.f_91073_ == null) {
            return false;
        }
        if (VREffectsHelper.mc.f_91080_ != null) {
            return false;
        }
        if (VREffectsHelper.dataHolder.vrSettings.renderInGameCrosshairMode != VRSettings.RenderPointerElement.ALWAYS && (VREffectsHelper.dataHolder.vrSettings.renderInGameCrosshairMode != VRSettings.RenderPointerElement.WITH_HUD || VREffectsHelper.mc.f_91066_.f_92062_)) {
            return false;
        }
        if (VREffectsHelper.dataHolder.currentPass != RenderPass.LEFT && VREffectsHelper.dataHolder.currentPass != RenderPass.RIGHT && VREffectsHelper.dataHolder.currentPass != RenderPass.CENTER) {
            return false;
        }
        if (KeyboardHandler.Showing) {
            return false;
        }
        if (RadialHandler.isUsingController(ControllerType.RIGHT)) {
            return false;
        }
        if (GuiHandler.guiPos_room != null) {
            return false;
        }
        if (VREffectsHelper.dataHolder.bowTracker.isNotched()) {
            return false;
        }
        if (VREffectsHelper.dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.dataHolder.teleportTracker.isAiming()) {
            return false;
        }
        if (VREffectsHelper.dataHolder.climbTracker.isGrabbingLadder(0)) {
            return false;
        }
        return !(VREffectsHelper.dataHolder.vrPlayer.worldScale > 15.0f);
    }

    public static void renderCrosshairAtDepth(boolean depthAlways, PoseStack poseStack) {
        if (VREffectsHelper.shouldRenderCrosshair()) {
            mc.m_91307_().m_6180_("crosshair");
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vec3 crosshairRenderPos = ((GameRendererExtension)VREffectsHelper.mc.f_91063_).vivecraft$getCrossVec();
            Vec3 aim = crosshairRenderPos.m_82546_(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(0).getPosition());
            float crossDepth = (float)aim.m_82553_();
            float scale = (float)((double)(0.125f * VREffectsHelper.dataHolder.vrSettings.crosshairScale) * Math.sqrt(VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale));
            crosshairRenderPos = crosshairRenderPos.m_82549_(aim.m_82541_().m_82490_(-0.01));
            poseStack.m_85836_();
            poseStack.m_166856_();
            RenderHelper.applyVRModelView(VREffectsHelper.dataHolder.currentPass, poseStack);
            Vec3 translate = crosshairRenderPos.m_82546_(mc.m_91288_().m_20182_());
            poseStack.m_85837_(translate.f_82479_, translate.f_82480_, translate.f_82481_);
            if (VREffectsHelper.mc.f_91077_ != null && VREffectsHelper.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockhitresult = (BlockHitResult)VREffectsHelper.mc.f_91077_;
                switch (blockhitresult.m_82434_()) {
                    case DOWN: {
                        MethodHolder.rotateDeg(poseStack, VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(0).getYaw(), 0.0f, 1.0f, 0.0f);
                        MethodHolder.rotateDeg(poseStack, -90.0f, 1.0f, 0.0f, 0.0f);
                        break;
                    }
                    case UP: {
                        MethodHolder.rotateDeg(poseStack, -VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(0).getYaw(), 0.0f, 1.0f, 0.0f);
                        MethodHolder.rotateDeg(poseStack, 90.0f, 1.0f, 0.0f, 0.0f);
                        break;
                    }
                    case WEST: {
                        MethodHolder.rotateDeg(poseStack, 90.0f, 0.0f, 1.0f, 0.0f);
                        break;
                    }
                    case EAST: {
                        MethodHolder.rotateDeg(poseStack, -90.0f, 0.0f, 1.0f, 0.0f);
                        break;
                    }
                    case SOUTH: {
                        MethodHolder.rotateDeg(poseStack, 180.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
            } else {
                MethodHolder.rotateDeg(poseStack, -VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(0).getYaw(), 0.0f, 1.0f, 0.0f);
                MethodHolder.rotateDeg(poseStack, -VREffectsHelper.dataHolder.vrPlayer.vrdata_world_render.getController(0).getPitch(), 1.0f, 0.0f, 0.0f);
            }
            if (VREffectsHelper.dataHolder.vrSettings.crosshairScalesWithDistance) {
                float depthscale = 0.3f + 0.2f * crossDepth;
                scale *= depthscale;
            }
            VREffectsHelper.mc.f_91063_.m_109154_().m_109896_();
            poseStack.m_85841_(scale, scale, scale);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            if (depthAlways) {
                RenderSystem.depthFunc((int)519);
            } else {
                RenderSystem.depthFunc((int)515);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)VREffectsHelper.mc.f_91073_, (BlockPos)BlockPos.m_274446_((Position)crosshairRenderPos));
            float brightness = 1.0f;
            if (VREffectsHelper.mc.f_91077_ == null || VREffectsHelper.mc.f_91077_.m_6662_() == HitResult.Type.MISS) {
                brightness = 0.5f;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Gui.f_279580_);
            float uMax = 0.05859375f;
            float vMax = 0.05859375f;
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.setShader(GameRenderer::m_172667_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(uMax, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), -1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthFunc((int)515);
            poseStack.m_85849_();
            mc.m_91307_().m_7238_();
        }
    }

    static {
        showedStencilMessage = false;
        cubeFront = new ResourceLocation("textures/gui/title/background/panorama_0.png");
        cubeRight = new ResourceLocation("textures/gui/title/background/panorama_1.png");
        cubeBack = new ResourceLocation("textures/gui/title/background/panorama_2.png");
        cubeLeft = new ResourceLocation("textures/gui/title/background/panorama_3.png");
        cubeUp = new ResourceLocation("textures/gui/title/background/panorama_4.png");
        cubeDown = new ResourceLocation("textures/gui/title/background/panorama_5.png");
        dirt = new ResourceLocation("minecraft:textures/block/dirt.png");
        grass = new ResourceLocation("minecraft:textures/block/grass_block_top.png");
    }
}

