/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.client_vr.extensions.ItemInHandRendererExtension;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRArmRenderer;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.render.VivecraftItemRendering;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

@Mixin(value={ItemInHandRenderer.class}, priority=999)
public abstract class ItemInHandRendererVRMixin
implements ItemInHandRendererExtension {
    @Unique
    private VRFirstPersonArmSwing vivecraft$swingType = VRFirstPersonArmSwing.Attack;
    @Final
    @Shadow
    private Minecraft f_109299_;
    @Final
    @Shadow
    private EntityRenderDispatcher f_109306_;
    @Final
    @Shadow
    private ItemRenderer f_109307_;
    @Shadow
    private float f_109303_;
    @Shadow
    private float f_109302_;
    @Shadow
    private float f_109305_;
    @Shadow
    private float f_109304_;

    @Inject(at={@At(value="HEAD")}, method={"renderPlayerArm"}, cancellable=true)
    public void vivecraft$overrideArm(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, float f, float g, HumanoidArm humanoidArm, CallbackInfo ci) {
        if (!VRState.vrRunning) {
            return;
        }
        this.vivecraft$vrPlayerArm(poseStack, multiBufferSource, i, f, g, humanoidArm);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderArmWithItem"}, cancellable=true)
    public void vivecraft$overrideArmItem(AbstractClientPlayer abstractClientPlayer, float f, float g, InteractionHand interactionHand, float h, ItemStack itemStack, float i, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, CallbackInfo ci) {
        if (!VRState.vrRunning) {
            return;
        }
        this.vivecraft$vrRenderArmWithItem(abstractClientPlayer, f, g, interactionHand, h, itemStack, i, poseStack, multiBufferSource, j);
        ci.cancel();
    }

    @Unique
    private void vivecraft$vrRenderArmWithItem(AbstractClientPlayer pPlayer, float pPartialTicks, float pPitch, InteractionHand pHand, float pSwingProgress, ItemStack pStack, float pEquippedProgress, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight) {
        boolean renderArm;
        boolean mainHand = pHand == InteractionHand.MAIN_HAND;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        HumanoidArm humanoidarm = mainHand ? pPlayer.m_5737_() : pPlayer.m_5737_().m_20828_();
        pEquippedProgress = this.vivecraft$getEquipProgress(pHand, pPartialTicks);
        pMatrixStack.m_85836_();
        boolean bl = renderArm = dh.currentPass != RenderPass.THIRD || dh.vrSettings.mixedRealityRenderHands;
        if (dh.currentPass == RenderPass.CAMERA) {
            renderArm = false;
        }
        if (BowTracker.isBow(pStack) && dh.bowTracker.isActive((LocalPlayer)pPlayer)) {
            renderArm = false;
        }
        if (TelescopeTracker.isTelescope(pStack) && (pHand == InteractionHand.OFF_HAND && dh.currentPass == RenderPass.SCOPEL || pHand == InteractionHand.MAIN_HAND && dh.currentPass == RenderPass.SCOPER)) {
            renderArm = false;
        }
        if (renderArm && !pPlayer.m_20145_()) {
            this.m_109346_(pMatrixStack, pBuffer, pCombinedLight, pEquippedProgress, pSwingProgress, humanoidarm);
        }
        if (!pStack.m_41619_()) {
            ItemDisplayContext itemDisplayContext;
            boolean isBow;
            pMatrixStack.m_85836_();
            if (pPlayer.f_20912_ == pHand) {
                this.vivecraft$transformFirstPersonVR(pMatrixStack, humanoidarm, pSwingProgress);
            }
            VivecraftItemRendering.VivecraftItemTransformType rendertype = VivecraftItemRendering.getTransformType(pStack, pPlayer, this.f_109307_);
            boolean useLeftHandModelinLeftHand = false;
            if (dh.climbTracker.isClaws(pStack) && dh.vrSettings.reverseHands) {
                mainHand = !mainHand;
            }
            boolean hasCMD = pStack.m_41782_() && pStack.m_41783_().m_128451_("CustomModelData") != 0 && rendertype != VivecraftItemRendering.VivecraftItemTransformType.Crossbow && rendertype != VivecraftItemRendering.VivecraftItemTransformType.Spear && rendertype != VivecraftItemRendering.VivecraftItemTransformType.Shield;
            boolean bl2 = isBow = BowTracker.isBow(pStack) && dh.bowTracker.isActive((LocalPlayer)pPlayer);
            if ((ClientNetworking.isThirdPersonItems() || hasCMD && ClientNetworking.isThirdPersonItemsCustom()) && !isBow || dh.climbTracker.isClaws(pStack)) {
                useLeftHandModelinLeftHand = true;
                VivecraftItemRendering.applyThirdPersonItemTransforms(pMatrixStack, rendertype, mainHand, pPlayer, pEquippedProgress, pPartialTicks, pStack, pHand);
                itemDisplayContext = mainHand ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : (useLeftHandModelinLeftHand ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
            } else {
                VivecraftItemRendering.applyFirstPersonItemTransforms(pMatrixStack, rendertype, mainHand, pPlayer, pEquippedProgress, pPartialTicks, pStack, pHand);
                itemDisplayContext = mainHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : (useLeftHandModelinLeftHand ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
            }
            ClientDataHolderVR.isfphand = true;
            if (rendertype == VivecraftItemRendering.VivecraftItemTransformType.Map) {
                RenderSystem.disableCull();
                this.m_109366_(pMatrixStack, pBuffer, pCombinedLight, pStack);
            } else if (rendertype == VivecraftItemRendering.VivecraftItemTransformType.Telescope) {
                if (dh.currentPass != RenderPass.SCOPEL && dh.currentPass != RenderPass.SCOPER) {
                    pMatrixStack.m_85836_();
                    pMatrixStack.m_85841_(0.625f, 0.625f, 0.625f);
                    pMatrixStack.m_85837_(mainHand ? -0.03 : 0.03, 0.0, -0.1);
                    this.m_269530_((LivingEntity)pPlayer, pStack, itemDisplayContext, !mainHand && useLeftHandModelinLeftHand, pMatrixStack, pBuffer, pCombinedLight);
                    pMatrixStack.m_85849_();
                }
                pMatrixStack.m_85836_();
                pMatrixStack.m_85837_(mainHand ? -0.01875 : 0.01875, 0.215, -0.0626);
                pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                    OptifineHelper.endEntities();
                }
                VREffectsHelper.drawScopeFB(pMatrixStack, pHand == InteractionHand.MAIN_HAND ? 0 : 1);
                pMatrixStack.m_85849_();
                if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                    OptifineHelper.beginEntities();
                }
            } else {
                this.m_269530_((LivingEntity)pPlayer, pStack, itemDisplayContext, !mainHand && useLeftHandModelinLeftHand, pMatrixStack, pBuffer, pCombinedLight);
            }
            ClientDataHolderVR.isfphand = false;
            pMatrixStack.m_85849_();
        }
        pMatrixStack.m_85849_();
    }

    @Shadow
    public abstract void m_269530_(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, boolean var4, PoseStack var5, MultiBufferSource var6, int var7);

    @Shadow
    protected abstract void m_109366_(PoseStack var1, MultiBufferSource var2, int var3, ItemStack var4);

    @Shadow
    protected abstract void m_109346_(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Unique
    private float vivecraft$getEquipProgress(InteractionHand hand, float partialTicks) {
        return hand == InteractionHand.MAIN_HAND ? 1.0f - (this.f_109303_ + (this.f_109302_ - this.f_109303_) * partialTicks) : 1.0f - (this.f_109305_ + (this.f_109304_ - this.f_109305_) * partialTicks);
    }

    @Unique
    private void vivecraft$vrPlayerArm(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, float f, float g, HumanoidArm humanoidArm) {
        boolean flag = humanoidArm != HumanoidArm.LEFT;
        float h = flag ? 1.0f : -1.0f;
        LocalPlayer abstractclientplayer = this.f_109299_.f_91074_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)abstractclientplayer.m_108560_());
        VRArmRenderer vrarmrenderer = ((EntityRenderDispatcherVRExtension)this.f_109306_).vivecraft$getArmSkinMap().get(abstractclientplayer.m_108564_());
        poseStack.m_85836_();
        if (abstractclientplayer.f_20912_ == InteractionHand.MAIN_HAND && flag) {
            this.vivecraft$transformFirstPersonVR(poseStack, humanoidArm, g);
        }
        if (abstractclientplayer.f_20912_ == InteractionHand.OFF_HAND && !flag) {
            this.vivecraft$transformFirstPersonVR(poseStack, humanoidArm, g);
        }
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        boolean slim = abstractclientplayer.m_108564_().equals("slim");
        poseStack.m_252880_((slim ? -0.34375f : -0.375f) * h, 0.0f, slim ? 0.78125f : 0.75f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (flag) {
            vrarmrenderer.m_117770_(poseStack, multiBufferSource, i, (AbstractClientPlayer)abstractclientplayer);
        } else {
            vrarmrenderer.m_117813_(poseStack, multiBufferSource, i, (AbstractClientPlayer)abstractclientplayer);
        }
        poseStack.m_85849_();
    }

    @Override
    @Unique
    public void vivecraft$setSwingType(VRFirstPersonArmSwing interact) {
        this.vivecraft$swingType = interact;
    }

    @Unique
    private void vivecraft$transformFirstPersonVR(PoseStack matrixStackIn, HumanoidArm hand, float swingProgress) {
        if (swingProgress != 0.0f) {
            switch (this.vivecraft$swingType) {
                case Attack: {
                    float f2 = Mth.m_14031_((float)((float)((double)(swingProgress * 3.0f) * Math.PI)));
                    if ((double)swingProgress > 0.5) {
                        f2 = Mth.m_14031_((float)((float)((double)swingProgress * Math.PI + Math.PI)));
                    }
                    matrixStackIn.m_85837_(0.0, 0.0, (double)0.2f);
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(f2 * 30.0f));
                    matrixStackIn.m_85837_(0.0, 0.0, (double)-0.2f);
                    break;
                }
                case Interact: {
                    float f1 = Mth.m_14031_((float)((float)((double)(swingProgress * 3.0f) * Math.PI)));
                    if ((double)swingProgress > 0.5) {
                        f1 = Mth.m_14031_((float)((float)((double)swingProgress * Math.PI + Math.PI)));
                    }
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((float)(hand == HumanoidArm.RIGHT ? -1 : 1) * f1 * 45.0f));
                    break;
                }
                case Use: {
                    float f = Mth.m_14031_((float)((float)((double)(swingProgress * 2.0f) * Math.PI)));
                    if ((double)swingProgress > 0.25) {
                        f = Mth.m_14031_((float)((float)((double)(swingProgress / 2.0f) * Math.PI + Math.PI)));
                    }
                    matrixStackIn.m_85837_(0.0, 0.0, (double)(-(1.0f + f) * 0.1f));
                }
            }
        }
    }
}

