/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer.entity;

import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.client_vr.extensions.LevelRendererExtension;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRArmRenderer;
import org.vivecraft.client_xr.render_pass.RenderPassType;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherVRMixin
implements ResourceManagerReloadListener,
EntityRenderDispatcherVRExtension {
    @Unique
    private VRArmRenderer vivecraft$armRenderer;
    @Unique
    public final Map<String, VRArmRenderer> vivecraft$armSkinMap = new HashMap<String, VRArmRenderer>();
    @Shadow
    public Camera f_114358_;
    @Shadow
    private Quaternionf f_114367_;

    @Inject(at={@At(value="HEAD")}, method={"cameraOrientation"}, cancellable=true)
    public void vivecraft$cameraOrientation(CallbackInfoReturnable<Quaternionf> cir) {
        if (RenderPassType.isVanilla() || RenderPassType.isGuiOnly()) {
            cir.setReturnValue((Object)this.f_114367_);
        } else {
            Entity entity = ((LevelRendererExtension)Minecraft.m_91087_().f_91060_).vivecraft$getRenderedEntity();
            if (entity == null) {
                cir.setReturnValue((Object)this.f_114358_.m_253121_());
            } else {
                Vec3 vec3 = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getEye(RenderPass.CENTER).getPosition();
                if (ClientDataHolderVR.getInstance().currentPass == RenderPass.THIRD || ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA) {
                    vec3 = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getEye(ClientDataHolderVR.getInstance().currentPass).getPosition();
                }
                Vec3 vec31 = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(vec3).m_82541_();
                Quaternionf q = new Quaternionf();
                q.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)(-Math.toDegrees(Math.atan2(-vec31.f_82479_, vec31.f_82481_)))));
                q.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(-Math.toDegrees(Math.asin(vec31.f_82480_ / vec31.m_82553_())))));
                cir.setReturnValue((Object)q);
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderers;createPlayerRenderers(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)Ljava/util/Map;")}, method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void vivecraft$reload(ResourceManager resourceManager, CallbackInfo ci, EntityRendererProvider.Context context) {
        this.vivecraft$armRenderer = new VRArmRenderer(context, false);
        this.vivecraft$armSkinMap.put("default", this.vivecraft$armRenderer);
        this.vivecraft$armSkinMap.put("slim", new VRArmRenderer(context, true));
    }

    @Override
    @Unique
    public Quaternionf vivecraft$getCameraOrientationOffset(float offset) {
        if (RenderPassType.isVanilla() || RenderPassType.isGuiOnly()) {
            return this.f_114367_;
        }
        Entity entity = ((LevelRendererExtension)Minecraft.m_91087_().f_91060_).vivecraft$getRenderedEntity();
        if (entity == null) {
            return this.f_114358_.m_253121_();
        }
        Vec3 vec3 = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getEye(RenderPass.CENTER).getPosition();
        if (ClientDataHolderVR.getInstance().currentPass == RenderPass.THIRD || ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA) {
            vec3 = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getEye(ClientDataHolderVR.getInstance().currentPass).getPosition();
        }
        Vec3 vec31 = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() + offset), 0.0).m_82546_(vec3).m_82541_();
        Quaternionf q = new Quaternionf();
        q.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)(-Math.toDegrees(Math.atan2(-vec31.f_82479_, vec31.f_82481_)))));
        q.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(-Math.toDegrees(Math.asin(vec31.f_82480_ / vec31.m_82553_())))));
        return q;
    }

    @Override
    public Map<String, VRArmRenderer> vivecraft$getArmSkinMap() {
        return this.vivecraft$armSkinMap;
    }
}

